/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool;

import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.ImageIcon;
import smart_gs.drawing_tool.DrawableCanvas;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorDrawMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.View;
import smart_gs.keyboard.action.SelectRegionAction;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.region.PolygonRegion;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.smleditor.swingui.IDATPanel;

public class SpreadCanvas
extends DrawableCanvas {
    private Spread currentSpread = null;
    public ImageLabel imageLabel;
    private ImageIcon imageIcon;
    private GSEditor gsEditor = null;
    private GSTabbedPane gsTabbedPane;
    private int selectedNumberOfRegion;
    private int selectedNumberOfLine;

    public SpreadCanvas() {
        this.getVerticalScrollBar().setUnitIncrement(20);
        this.getHorizontalScrollBar().setUnitIncrement(20);
        this.setFocusable(true);
        this.setKeyListener();
    }

    public SpreadCanvas(Spread spread) {
        this();
        this.setSpread(spread);
    }

    public void setGSEditor(GSEditor gsEditor) {
        this.gsEditor = gsEditor;
    }

    public GSEditor getGSEditor() {
        return this.gsEditor;
    }

    public void setGSTabbedPane(GSTabbedPane gsTabbedPane) {
        this.gsTabbedPane = gsTabbedPane;
    }

    public GSTabbedPane getGSTabbedPane() {
        return this.gsTabbedPane;
    }

    public void setKeyListener() {
        this.addKeyListener(new SelectRegionAction(this));
    }

    public Point getCornerPoint() {
        return this.getCornerPoint();
    }

    public void setSpread(Spread spread) {
        this.setCurrentSpread(spread);
        this.imageIcon = spread.getImageIcon();
        this.imageLabel = new ImageLabel(this, this.imageIcon);
        this.setViewportView(this.imageLabel);
    }

    public Spread getSpread() {
        return this.getCurrentSpread();
    }

    public ImageLabel getImageLabel() {
        return this.imageLabel;
    }

    public void addRegion(Region region) {
        this.imageLabel.addRegion(region);
    }

    public void addTempView(View view) {
        this.imageLabel.addTempView(view);
    }

    public void zoomIn() {
        this.imageLabel.zoomIn();
    }

    public void zoomOut() {
        this.imageLabel.zoomOut();
    }

    public void fullSize() {
        this.imageLabel.fullSize();
    }

    public void fitWidth() {
        this.imageLabel.fitWidth(this.getWidth());
    }

    public void fitHeight() {
        this.imageLabel.fitHeight(this.getHeight());
    }

    public boolean containRegions(Point point) {
        List<Region> regions = this.getCurrentSpread().getRegions();
        for (int i = 0; i < regions.size(); ++i) {
            MemoPadView mview;
            if (regions.get(i).contains(new Point2D.Double(point.x, point.y))) {
                return true;
            }
            if (regions.get(i).getView().getType() != 5 || !(mview = (MemoPadView)regions.get(i).getView()).containsInArrowHead(point) && !mview.containsInArrow(point)) continue;
            return true;
        }
        if (ImageLabel.isLineShown() && !(DefaultState.getInstance().getMode() instanceof LineSegEditorDrawMode)) {
            List<LineSegment> lines = this.getCurrentSpread().getLines();
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).getView().contains(point)) continue;
                this.selectLineEvent(i, lines.get(i), point);
                return true;
            }
        }
        return false;
    }

    public void setCenterLocation(Point point) {
        this.imageLabel.setCenterLocation(point);
    }

    public Region getRegion(Point point) {
        List<Region> regions = this.getCurrentSpread().getRegions();
        for (int i = regions.size() - 1; i >= 0; --i) {
            View view = regions.get(i).getView();
            boolean is_memopad = view.getType() == 5;
            Point2D.Double point2 = new Point2D.Double(point.x, point.y);
            boolean contains_in_arrow = is_memopad ? ((MemoPadView)view).containsInArrow(point2) : false;
            if (!regions.get(i).contains(point2) && !contains_in_arrow) continue;
            regions.add(regions.remove(i));
            this.setSelectedNumberOfRegion(regions.size() - 1);
            return regions.get(regions.size() - 1);
        }
        if (ImageLabel.isLineShown()) {
            List<LineSegment> lines = this.getCurrentSpread().getLines();
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).getView().contains(point)) continue;
                this.selectedNumberOfLine = i;
                return lines.get(i);
            }
        }
        return null;
    }

    public Region getRegionByIndex(int index) {
        List<Region> regions = this.getCurrentSpread().getRegions();
        regions.add(regions.remove(index));
        this.setSelectedNumberOfRegion(regions.size() - 1);
        return regions.get(regions.size() - 1);
    }

    public Region getAnotherRegion(Point point) {
        List<Region> regions = this.getCurrentSpread().getRegions();
        for (int i = 0; i < regions.size() - 1; ++i) {
            if (i > regions.size() - 1) {
                i = 0;
            }
            if (!regions.get(i).contains(new Point2D.Double(point.x, point.y))) continue;
            regions.add(regions.remove(i));
            this.setSelectedNumberOfRegion(regions.size() - 1);
            return regions.get(this.getSelectedNumberOfRegion());
        }
        return regions.get(this.getSelectedNumberOfRegion());
    }

    public void clear() {
        this.getViewport().removeAll();
        this.getCurrentSpread().release();
    }

    public void selectLineEvent(int clickPosition, LineSegment lineSegment, Point point) {
        Component component = this.gsTabbedPane.getComponent(this.gsTabbedPane.getSelectedIndex());
        if (component != null && component instanceof IDATPanel) {
            ((IDATPanel)component).jumpLinkToText(clickPosition);
        }
    }

    public void protectAllRegions() {
        List<Region> regions = this.getCurrentSpread().getRegions();
        for (int i = 0; i < regions.size(); ++i) {
            regions.get(i).setProtection("protected");
            regions.get(i).getView().setIsProtected("protected");
        }
    }

    public void releaseAllRegions() {
        List<Region> regions = this.getCurrentSpread().getRegions();
        for (int i = 0; i < regions.size(); ++i) {
            regions.get(i).setProtection("normal");
            regions.get(i).getView().setIsProtected("normal");
        }
    }

    public void setCurrentSpread(Spread currentSpread) {
        this.currentSpread = currentSpread;
    }

    public Spread getCurrentSpread() {
        return this.currentSpread;
    }

    public void setSelectedNumberOfRegion(int selectedNumberOfRegion) {
        this.selectedNumberOfRegion = selectedNumberOfRegion;
    }

    public int getSelectedNumberOfRegion() {
        return this.selectedNumberOfRegion;
    }

    public void selectRegion(Region region) {
        List<Region> regions = this.currentSpread.getRegions();
        int index = -1;
        for (int i = 0; i < regions.size(); ++i) {
            if (!regions.get(i).getURI().equals(region.getURI())) continue;
            index = i;
        }
        if (index >= 0) {
            regions.get(regions.size() - 1).getView().setIsSelected(false);
            regions.add(regions.remove(index));
            this.setSelectedNumberOfRegion(regions.size() - 1);
            regions.get(regions.size() - 1).getView().setIsSelected(true);
            UniSelectedState.getInstance().setSelectedRegion(regions.get(regions.size() - 1));
            ImageLabel.setState(UniSelectedState.getInstance());
        }
    }

    public void resetSelection() {
        this.tmpPolyDeleteAndResetSelection(false);
    }

    public void tmpPolyDeleteAndResetSelection(boolean tmpDelete) {
        List<Region> regions = this.currentSpread.getRegions();
        for (int i = 0; i < regions.size(); ++i) {
            Region region = regions.get(i);
            if (!region.isSelected()) continue;
            region.setSelected(false);
            ImageLabel.setState(DefaultState.getInstance());
            if (!tmpDelete || !region.isTemporary() || !(region instanceof PolygonRegion) || !region.isJumpedTo()) continue;
            new DeleteRegionAction(region).execute();
        }
    }
}

