/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import smart_gs.dictionary.DictionaryRegisterDialog;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.action.ChangeRegionTitleAction;
import smart_gs.drawing_tool.action.ProtectRegionAction;
import smart_gs.drawing_tool.action.ReleaseProtectedRegionAction;
import smart_gs.drawing_tool.state.LineSegEditorUniSelectedState;
import smart_gs.logical.Region;
import smart_gs.swingui.WorkspaceWindow;

public class LineSegEditorRightClickMenu
extends JPopupMenu {
    public LineSegEditorRightClickMenu(final Region region, LineSegEditorCanvas canvas, LineSegEditorUniSelectedState lineSegEditorUniSelectedState) {
        String title = region.getView().getTitle();
        JMenuItem displayTitle = new JMenuItem("Title: " + title);
        displayTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ChangeRegionTitleAction(region).execute();
            }
        });
        this.add(displayTitle);
        this.addSeparator();
        this.addSeparator();
        if (region.isProtected().equals("normal")) {
            JMenuItem protectRegion = new JMenuItem("Protect Markup");
            protectRegion.addActionListener(new ProtectRegionAction(region));
            this.add(protectRegion);
        } else {
            JMenuItem releaseProtectedRegion = new JMenuItem("Release Protected Markup");
            releaseProtectedRegion.addActionListener(new ReleaseProtectedRegionAction(region));
            this.add(releaseProtectedRegion);
        }
        JMenuItem registDic = new JMenuItem("Register in the dictionary");
        registDic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DictionaryRegisterDialog dialog = new DictionaryRegisterDialog((Frame)WorkspaceWindow.getInstance(), "Register", true, region);
                dialog.setVisible(true);
            }
        });
        this.add(registDic);
    }
}

