/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.dictionary.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import smart_gs.dictionary.viewer.AbstractSearchResultPanel;
import smart_gs.dictionary.viewer.QueryPanel;
import smart_gs.dictionary.viewer.SearchResultListPanel;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;

public class SearchResultDictionaryViewer
extends JFrame {
    private List<SearchResult> results;
    private List<SearchResult> newResults;
    private AbstractSearchResultPanel resultPanel;
    private JScrollPane scrollPane;
    private GSQuery query;
    private QueryBucket bucket;
    protected List<SearchResult> selectedResults;
    private JPanel mainPanel;
    private static int pSize;
    private JLabel searchedPageLabel;
    private String searchedPage;

    public SearchResultDictionaryViewer(QueryBucket bucket, List<SearchResult> results) {
        super("Search Result");
        this.bucket = bucket;
        this.results = results;
        pSize = bucket.size();
        this.newResults = new ArrayList<SearchResult>();
        for (int i = 0; i < results.size(); ++i) {
            if (results.get(i).wasShown()) continue;
            this.newResults.add(results.get(i));
        }
        this.query = this.bucket.get(0);
        this.selectedResults = new ArrayList<SearchResult>();
        Region region = new Region(this.query.getSpread(), new RectangleView(this.query.getRectangle()));
        this.build(this.query.getQueryImage(), region);
        int xresize = 730;
        switch (results.size()) {
            case 0: {
                xresize = 350;
                break;
            }
            case 1: {
                xresize = 450;
                break;
            }
            case 2: {
                xresize = 550;
                break;
            }
            case 3: {
                xresize = 650;
                break;
            }
            default: {
                xresize = 750;
            }
        }
        int resultsize = results.size();
        int yresize = 250;
        if (yresize != 0) {
            int linesize = (int)Math.ceil((double)resultsize / 4.0);
            switch (linesize) {
                case 0: {
                    yresize = 250;
                    break;
                }
                case 1: {
                    yresize = 300;
                    break;
                }
                case 2: {
                    yresize = 380;
                    break;
                }
                case 3: {
                    yresize = 450;
                    break;
                }
                case 4: {
                    yresize = 530;
                    break;
                }
                default: {
                    yresize = 600;
                }
            }
        }
        this.setSize(xresize, yresize);
    }

    public SearchResultDictionaryViewer(QueryBucket bucket, List<SearchResult> results, String searchedPage) {
        this(bucket, results);
        this.searchedPage = searchedPage;
    }

    public int getPreviousBucketSize() {
        return pSize;
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public List<SearchResult> getNewResults() {
        return this.newResults;
    }

    public List<SearchResult> getSelectedResults() {
        return this.selectedResults;
    }

    public QueryBucket getBucket() {
        return this.bucket;
    }

    private void build(Image image, Region region) {
        this.setDefaultCloseOperation(2);
        QueryPanel queryPanel = new QueryPanel(image);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.resultPanel = new SearchResultListPanel(this, this.results, region, 20);
        this.scrollPane.setViewportView(this.resultPanel);
        this.mainPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JButton back = new JButton("back");
        back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultDictionaryViewer.this.resultPanel.back();
                SearchResultDictionaryViewer.this.scrollPane.getVerticalScrollBar().setValue(0);
                SearchResultDictionaryViewer.this.validate();
            }
        });
        JButton next = new JButton("next");
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchResultDictionaryViewer.this.resultPanel.next();
                SearchResultDictionaryViewer.this.scrollPane.getVerticalScrollBar().setValue(0);
                SearchResultDictionaryViewer.this.validate();
            }
        });
        buttonPanel.add(back);
        buttonPanel.add(next);
        this.mainPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        this.searchedPageLabel = new JLabel("search scope: " + this.searchedPage);
        topPanel.add(this.searchedPageLabel);
        topPanel.add(queryPanel);
        this.mainPanel.add((Component)topPanel, "North");
        if (this.resultPanel instanceof SearchResultListPanel) {
            JScrollPane scrollpane = new JScrollPane(this.resultPanel);
            scrollpane.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.mainPanel.add((Component)this.resultPanel, "Center");
        } else {
            this.mainPanel.add((Component)this.scrollPane, "Center");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }
}

