/*
 * Decompiled with CFR 0.152.
 */
package reasoning_web.logical;

import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSVersion;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.URIBearer;

public class Connection
implements RWElement,
URIBearer {
    public static final int LOOP = 0;
    public static final int SOURCE = 1;
    public static final int TARGET = 2;
    protected ExplanatoryNote expNote;
    protected ResourcePointer source;
    protected ResourcePointer target;
    protected String name = "";
    protected String uri;
    protected String originalURI;
    protected String oldVersionURI;
    protected String version;

    protected Connection(ResourcePointer source, ResourcePointer target, ExplanatoryNote note, String uri, String originalURI, String version) {
        this.source = source;
        this.target = target;
        this.target.addSource(source);
        this.target.addConnection(this);
        this.source.addTarget(target);
        if (!this.source.equals(this.target)) {
            source.addConnection(this);
        }
        this.expNote = note;
        this.setURIs(uri, originalURI);
        if (originalURI.equals("")) {
            note.appendContainer(this);
        }
        this.version = version;
    }

    protected Connection(ResourcePointer source, ResourcePointer target, ExplanatoryNote note) {
        this.source = source;
        this.target = target;
        this.target.addSource(source);
        this.target.addConnection(this);
        this.source.addTarget(target);
        if (!this.source.equals(this.target)) {
            source.addConnection(this);
        }
        this.expNote = note;
        this.setURIs();
        this.version = GSVersion.getVersion();
        note.appendContainer(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ExplanatoryNote getExplanatoryNote() {
        return this.expNote;
    }

    public ResourcePointer getSourcePointer() {
        return this.source;
    }

    public ResourcePointer getTargetPointer() {
        return this.target;
    }

    public int typeOfPointerInConnection(ResourcePointer pointer) {
        boolean is_source = pointer.equals(this.source);
        boolean is_target = pointer.equals(this.target);
        if (is_source && is_target) {
            return 0;
        }
        if (is_source) {
            return 1;
        }
        if (is_target) {
            return 2;
        }
        System.out.println("Error in typeOfPointerInConnection");
        return -1;
    }

    @Override
    public String getSource() throws NotMarkupException {
        throw new NotMarkupException();
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    public String getURIWithoutExtension() {
        return this.uri.substring("smart://".length());
    }

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    @Override
    public String getTypeString() {
        return "connection";
    }

    public RWElement getSourceRWElement() {
        return this.getSourcePointer().getRwElement();
    }

    public RWElement getTargetRWElement() {
        return this.getTargetPointer().getRwElement();
    }

    @Override
    public String getOriginalURI() {
        return this.originalURI;
    }

    @Override
    public void setOriginalURI(String originalURI) {
        this.originalURI = originalURI;
    }

    @Override
    public void setURIs(String uri, String originalURI) {
        URICreator.setURIs(this, uri, originalURI);
    }

    @Override
    public void setURIs() {
        this.uri = this.originalURI = URICreator.createURI(this);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getOldVersionURI() {
        return this.oldVersionURI;
    }

    @Override
    public void setOldVersionURI(String oldVersionURI) {
        this.oldVersionURI = oldVersionURI;
    }
}

