/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import jp.ac.hokudai.meme.core_smart_gs.searcher.AbstractDTWCalculator;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DistanceAndIndex;

public class DTWCalculatorType1
extends AbstractDTWCalculator {
    @Override
    public DistanceAndIndex calcDTWDist(int startIndex, int endIndex, double[][] pattern, double[][] dtwArray) {
        int textLength = endIndex - startIndex + 1;
        int patLength = pattern.length;
        this.initDTWArray(dtwArray, startIndex);
        this.initDTWArrayLocal(dtwArray, startIndex);
        double diag = 0.0;
        double left = 0.0;
        double down = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 2; i < patLength; ++i) {
            for (int j = 2; j < textLength; ++j) {
                diag = this.getDist(startIndex + j, i);
                left = this.getDist(startIndex + j - 1, i);
                down = this.getDist(startIndex + j, i - 1);
                d1 = dtwArray[i - 2][j - 1] + 2.0 * left + diag;
                d2 = dtwArray[i - 1][j - 1] + 2.0 * diag;
                d3 = dtwArray[i - 1][j - 2] + 2.0 * down + diag;
                dtwArray[i][j] = this.min(d1, d2, d3);
            }
        }
        double minDist = Double.POSITIVE_INFINITY;
        int resEndIndex = 0;
        for (int i = 0; i < textLength; ++i) {
            if (!(dtwArray[patLength - 1][i] < minDist)) continue;
            minDist = dtwArray[patLength - 1][i];
            resEndIndex = startIndex + i;
        }
        return new DistanceAndIndex(minDist, startIndex, resEndIndex);
    }

    private void initDTWArrayLocal(double[][] dtwArray, int startIndex) {
        int i;
        for (i = 1; i < dtwArray.length; ++i) {
            dtwArray[i][0] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i < dtwArray[0].length; ++i) {
            dtwArray[0][i] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i < dtwArray.length; ++i) {
            dtwArray[i][1] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i < dtwArray[0].length; ++i) {
            dtwArray[1][i] = Double.POSITIVE_INFINITY;
        }
        dtwArray[1][1] = dtwArray[0][0] + 2.0 * this.getDist(startIndex + 1, 1);
        dtwArray[1][2] = dtwArray[1][1] + this.getDist(startIndex + 1, 2);
        dtwArray[2][1] = dtwArray[1][1] + this.getDist(startIndex + 2, 1);
    }

    public static void main(String[] args) {
    }
}

