/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.hokudai.meme.core_smart_gs.io;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import jp.ac.hokudai.meme.core_smart_gs.DSCData;
import jp.ac.hokudai.meme.core_smart_gs.DSCFileHeader;
import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;
import jp.ac.hokudai.meme.core_smart_gs.io.IDSCFileLoader;

public class DSCFileLoader
implements IDSCFileLoader {
    protected static final int HEADER_SIZE = 12;
    protected static final int BUF_MAX = 8192;
    protected static int bufSize_ = 0;
    protected ByteBuffer buffer_;

    @Override
    public void loadDscFile(DSCData dataContainer, File dscFile) throws IOException, InvalidDataFormatException {
        FileChannel inChannel = new FileInputStream(dscFile).getChannel();
        DSCFileHeader header = this.loadHeader(inChannel);
        this.makeBuffer(header.getDscDimension());
        try {
            this.loadDscData(dataContainer, inChannel, header);
        }
        catch (InvalidDataFormatException e) {
            String mes = e.getMessage();
            mes = mes + "in " + dscFile.getName() + " .";
            InvalidDataFormatException newEx = new InvalidDataFormatException(mes);
            newEx.setFileName(dscFile.getName());
            throw newEx;
        }
    }

    protected DSCData loadDscData(DSCData dataContainer, FileChannel inChannel, DSCFileHeader header) throws IOException, InvalidDataFormatException {
        ArrayList dataArray = new ArrayList(header.getSlitCount());
        ArrayList areaArray = new ArrayList(header.getSlitCount());
        while (true) {
            this.buffer_.clear();
            if (inChannel.read(this.buffer_) < 0) break;
            this.buffer_.flip();
            this.constructData(dataArray, areaArray, this.buffer_, header.getDscDimension());
        }
        inChannel.close();
        double[][] dscData = (double[][])dataArray.toArray((T[])new double[0][]);
        Rectangle[] areaData = areaArray.toArray(new Rectangle[0]);
        dataContainer.addDscData(header, areaData, dscData);
        return dataContainer;
    }

    protected void constructData(ArrayList dscDataArray, ArrayList areaArray, ByteBuffer buffer, int dim) {
        int[] rect = new int[4];
        while (buffer.position() < buffer.limit()) {
            for (int i = 0; i < rect.length; ++i) {
                rect[i] = buffer.getShort();
            }
            areaArray.add(new Rectangle(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]));
            double[] features = new double[dim];
            for (int i = 0; i < dim; ++i) {
                features[i] = buffer.getDouble();
            }
            dscDataArray.add(features);
        }
    }

    protected DSCFileHeader loadHeader(FileChannel inChannel) throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(12);
        headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int read = inChannel.read(headerBuffer);
        headerBuffer.flip();
        byte[] fileType = new byte[]{headerBuffer.get(), headerBuffer.get()};
        short version = headerBuffer.getShort();
        headerBuffer.getShort();
        short dscDimension = headerBuffer.getShort();
        int slitCount = headerBuffer.getInt();
        return new DSCFileHeader(DSCFileHeader.checkFType(fileType), version, dscDimension, slitCount);
    }

    protected void makeBuffer(int featDim) {
        int bufSize_;
        for (bufSize_ = 8 * (featDim + 1); bufSize_ < 8192; bufSize_ += bufSize_) {
        }
        this.buffer_ = ByteBuffer.allocateDirect(bufSize_);
        this.buffer_.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static void main(String[] args) {
    }
}

