/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.ExtendedHTMLDocument;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

public class HTMLUtilities {
    GSHTMLEditor parent;
    Hashtable tags = new Hashtable();

    public HTMLUtilities(GSHTMLEditor newParent) {
        this.parent = newParent;
        HTML.Tag[] tagList = HTML.getAllTags();
        for (int i = 0; i < tagList.length; ++i) {
            this.tags.put(tagList[i].toString(), tagList[i]);
        }
    }

    public void insertListElement(String content) {
        String idString;
        int pos = this.parent.getCaretPosition();
        String source = this.parent.getSourcePane().getText();
        boolean hit = false;
        int counter = 0;
        do {
            hit = false;
            idString = "diesisteineidzumsuchenimsource" + counter;
            if (source.indexOf(idString) <= -1) continue;
            hit = true;
            if (++counter <= 10000) continue;
            return;
        } while (hit);
        Element element = this.getListItemParent();
        if (element == null) {
            return;
        }
        SimpleAttributeSet sa = new SimpleAttributeSet(element.getAttributes());
        sa.addAttribute("id", idString);
        this.parent.getExtendedHtmlDoc().replaceAttributes(element, sa, HTML.Tag.LI);
        this.parent.refreshOnUpdate();
        source = this.parent.getSourcePane().getText();
        StringBuffer newHtmlString = new StringBuffer();
        int[] positions = this.getPositions(element, source, true, idString);
        newHtmlString.append(source.substring(0, positions[3]));
        newHtmlString.append("<li>");
        newHtmlString.append(content);
        newHtmlString.append("</li>");
        newHtmlString.append(source.substring(positions[3] + 1, source.length()));
        this.parent.getTextPane().setText(newHtmlString.toString());
        this.parent.refreshOnUpdate();
        this.parent.setCaretPosition(pos - 1);
        element = this.getListItemParent();
        sa = new SimpleAttributeSet(element.getAttributes());
        sa = this.removeAttributeByKey(sa, "id");
        this.parent.getExtendedHtmlDoc().replaceAttributes(element, sa, HTML.Tag.LI);
    }

    public void removeTag(Element element, boolean closingTag) {
        String idString;
        if (element == null) {
            return;
        }
        int pos = this.parent.getCaretPosition();
        HTML.Tag tag = this.getHTMLTag(element);
        String source = this.parent.getSourcePane().getText();
        boolean hit = false;
        int counter = 0;
        do {
            hit = false;
            idString = "diesisteineidzumsuchenimsource" + counter;
            if (source.indexOf(idString) <= -1) continue;
            hit = true;
            if (++counter <= 10000) continue;
            return;
        } while (hit);
        SimpleAttributeSet sa = new SimpleAttributeSet(element.getAttributes());
        sa.addAttribute("id", idString);
        this.parent.getExtendedHtmlDoc().replaceAttributes(element, sa, tag);
        this.parent.refreshOnUpdate();
        source = this.parent.getSourcePane().getText();
        StringBuffer newHtmlString = new StringBuffer();
        int[] position = this.getPositions(element, source, closingTag, idString);
        if (position == null) {
            return;
        }
        for (int i = 0; i < position.length; ++i) {
            if (position[i] >= 0) continue;
            return;
        }
        int beginStartTag = position[0];
        int endStartTag = position[1];
        if (closingTag) {
            int beginEndTag = position[2];
            int endEndTag = position[3];
            newHtmlString.append(source.substring(0, beginStartTag));
            newHtmlString.append(source.substring(endStartTag, beginEndTag));
            newHtmlString.append(source.substring(endEndTag, source.length()));
        } else {
            newHtmlString.append(source.substring(0, beginStartTag));
            newHtmlString.append(source.substring(endStartTag, source.length()));
        }
        this.parent.getTextPane().setText(newHtmlString.toString());
        this.parent.refreshOnUpdate();
    }

    private int[] getPositions(Element element, String source, boolean closingTag, String idString) {
        HTML.Tag tag = this.getHTMLTag(element);
        int[] position = new int[4];
        for (int i = 0; i < position.length; ++i) {
            position[i] = -1;
        }
        String searchString = "<" + tag.toString();
        int caret = -1;
        caret = source.indexOf(idString);
        if (caret != -1) {
            position[0] = source.lastIndexOf("<", caret);
            position[1] = source.indexOf(">", caret) + 1;
        }
        if (closingTag) {
            String searchEndTagString = "</" + tag.toString() + ">";
            int hitUp = 0;
            int beginEndTag = -1;
            int endEndTag = -1;
            caret = position[1];
            boolean end = false;
            beginEndTag = source.indexOf(searchEndTagString, caret);
            endEndTag = beginEndTag + searchEndTagString.length();
            int interncaret = position[1];
            do {
                int temphitpoint = -1;
                boolean flaghitup = false;
                hitUp = 0;
                do {
                    flaghitup = false;
                    temphitpoint = source.indexOf(searchString, interncaret);
                    if (temphitpoint <= 0 || temphitpoint >= beginEndTag) continue;
                    ++hitUp;
                    flaghitup = true;
                    interncaret = temphitpoint + searchString.length();
                } while (flaghitup);
                if (hitUp == 0) {
                    end = true;
                    continue;
                }
                for (int i = 1; i <= hitUp; ++i) {
                    caret = endEndTag;
                    beginEndTag = source.indexOf(searchEndTagString, caret);
                    endEndTag = beginEndTag + searchEndTagString.length();
                }
                end = false;
            } while (!end);
            if (beginEndTag < 0 | endEndTag < 0) {
                return null;
            }
            position[2] = beginEndTag;
            position[3] = endEndTag;
        }
        return position;
    }

    public boolean checkParentsTag(HTML.Tag tag) {
        Element e = this.parent.getExtendedHtmlDoc().getParagraphElement(this.parent.getCaretPosition());
        String tagString = tag.toString();
        if (e.getName().equalsIgnoreCase(tag.toString())) {
            return true;
        }
        do {
            if (!(e = e.getParentElement()).getName().equalsIgnoreCase(tagString)) continue;
            return true;
        } while (!e.getName().equalsIgnoreCase("html"));
        return false;
    }

    public boolean checkParentsTag(HTML.Tag tag, int pos) {
        Element e = this.parent.getExtendedHtmlDoc().getParagraphElement(pos);
        String tagString = tag.toString();
        if (e.getName().equalsIgnoreCase(tag.toString())) {
            return true;
        }
        do {
            if (!(e = e.getParentElement()).getName().equalsIgnoreCase(tagString)) continue;
            return true;
        } while (!e.getName().equalsIgnoreCase("html"));
        return false;
    }

    public Element getListItemParent() {
        String listItemTag = HTML.Tag.LI.toString();
        Element eleSearch = this.parent.getExtendedHtmlDoc().getCharacterElement(this.parent.getCaretPosition());
        do {
            if (!listItemTag.equals(eleSearch.getName())) continue;
            return eleSearch;
        } while ((eleSearch = eleSearch.getParentElement()).getName() != HTML.Tag.HTML.toString());
        return null;
    }

    public SimpleAttributeSet removeAttributeByKey(SimpleAttributeSet sourceAS, String removeKey) {
        SimpleAttributeSet temp = new SimpleAttributeSet();
        temp.addAttribute(removeKey, "NULL");
        return this.removeAttribute(sourceAS, temp);
    }

    public SimpleAttributeSet removeAttribute(SimpleAttributeSet sourceAS, SimpleAttributeSet removeAS) {
        try {
            String[] sourceKeys = new String[sourceAS.getAttributeCount()];
            String[] sourceValues = new String[sourceAS.getAttributeCount()];
            Enumeration<?> sourceEn = sourceAS.getAttributeNames();
            int i = 0;
            while (sourceEn.hasMoreElements()) {
                Object temp = new Object();
                temp = sourceEn.nextElement();
                sourceKeys[i] = temp.toString();
                sourceValues[i] = new String();
                sourceValues[i] = sourceAS.getAttribute(temp).toString();
                ++i;
            }
            String[] removeKeys = new String[removeAS.getAttributeCount()];
            String[] removeValues = new String[removeAS.getAttributeCount()];
            Enumeration<?> removeEn = removeAS.getAttributeNames();
            int j = 0;
            while (removeEn.hasMoreElements()) {
                removeKeys[j] = removeEn.nextElement().toString();
                removeValues[j] = removeAS.getAttribute(removeKeys[j]).toString();
                ++j;
            }
            SimpleAttributeSet result = new SimpleAttributeSet();
            boolean hit = false;
            for (int countSource = 0; countSource < sourceKeys.length; ++countSource) {
                hit = false;
                if (sourceKeys[countSource] == "name" | sourceKeys[countSource] == "resolver") {
                    hit = true;
                } else {
                    for (int countRemove = 0; countRemove < removeKeys.length; ++countRemove) {
                        if (removeKeys[countRemove] != "NULL") {
                            if (sourceKeys[countSource].toString() != removeKeys[countRemove].toString()) continue;
                            if (removeValues[countRemove] != "NULL") {
                                if (sourceValues[countSource].toString() != removeValues[countRemove].toString()) continue;
                                hit = true;
                                continue;
                            }
                            if (removeValues[countRemove] != "NULL") continue;
                            hit = true;
                            continue;
                        }
                        if (removeKeys[countRemove] != "NULL" || sourceValues[countSource].toString() != removeValues[countRemove].toString()) continue;
                        hit = true;
                    }
                }
                if (hit) continue;
                result.addAttribute(sourceKeys[countSource].toString(), sourceValues[countSource].toString());
            }
            return result;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public HTML.Tag getHTMLTag(Element e) {
        if (this.tags.containsKey(e.getName())) {
            return (HTML.Tag)this.tags.get(e.getName());
        }
        return null;
    }

    public String[] getUniString(int strings) {
        this.parent.refreshOnUpdate();
        String[] result = new String[strings];
        String source = this.parent.getSourcePane().getText();
        for (int i = 0; i < strings; ++i) {
            String idString;
            int start = -1;
            int end = -1;
            boolean hit = false;
            int counter = 0;
            do {
                hit = false;
                idString = "diesisteineidzumsuchen" + counter + "#" + i;
                if (source.indexOf(idString) <= -1) continue;
                hit = true;
                if (++counter <= 10000) continue;
                return null;
            } while (hit);
            result[i] = idString;
        }
        return result;
    }

    public void delete() throws BadLocationException, IOException {
        JTextPane jtpMain = this.parent.getTextPane();
        JTextArea jtpSource = this.parent.getSourcePane();
        ExtendedHTMLDocument htmlDoc = this.parent.getExtendedHtmlDoc();
        int selStart = jtpMain.getSelectionStart();
        int selEnd = jtpMain.getSelectionEnd();
        String[] posStrings = this.getUniString(2);
        if (posStrings == null) {
            return;
        }
        htmlDoc.insertString(selStart, posStrings[0], null);
        htmlDoc.insertString(selEnd + posStrings[0].length(), posStrings[1], null);
        this.parent.refreshOnUpdate();
        int start = jtpSource.getText().indexOf(posStrings[0]);
        int end = jtpSource.getText().indexOf(posStrings[1]);
        if (start == -1 || end == -1) {
            return;
        }
        String htmlString = new String();
        htmlString = htmlString + jtpSource.getText().substring(0, start);
        htmlString = htmlString + jtpSource.getText().substring(start + posStrings[0].length(), end);
        String source = htmlString = htmlString + jtpSource.getText().substring(end + posStrings[1].length(), jtpSource.getText().length());
        htmlString = new String();
        htmlString = htmlString + source.substring(0, start);
        htmlString = htmlString + this.getAllTableTags(source.substring(start, end -= posStrings[0].length()));
        htmlString = htmlString + source.substring(end, source.length());
        this.parent.getTextPane().setText(htmlString);
        this.parent.refreshOnUpdate();
    }

    private String getAllTableTags(String source) throws BadLocationException, IOException {
        StringBuffer result = new StringBuffer();
        int caret = -1;
        do {
            int[] tableCarets = new int[]{source.indexOf("<table", ++caret), source.indexOf("<tr", caret), source.indexOf("<td", caret), source.indexOf("</table", caret), source.indexOf("</tr", caret), source.indexOf("</td", caret)};
            Arrays.sort(tableCarets);
            caret = -1;
            for (int i = 0; i < tableCarets.length; ++i) {
                if (tableCarets[i] < 0) continue;
                caret = tableCarets[i];
                break;
            }
            if (caret == -1) continue;
            result.append(source.substring(caret, source.indexOf(">", caret) + 1));
        } while (caret != -1);
        return result.toString();
    }

    public static String getBodyText(String s) {
        String containingTag = "body";
        String docTextCase = s.toLowerCase();
        int tagStart = docTextCase.indexOf("<" + containingTag.toLowerCase());
        int tagStartClose = docTextCase.indexOf(">", tagStart) + 1;
        String closeTag = "</" + containingTag.toLowerCase() + ">";
        int tagEndOpen = docTextCase.indexOf(closeTag);
        if (tagStartClose < 0) {
            tagStartClose = 0;
        }
        if (tagEndOpen < 0 || tagEndOpen > docTextCase.length()) {
            tagEndOpen = docTextCase.length();
        }
        return s.substring(tagStartClose, tagEndOpen);
    }
}

