/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.action;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.HTMLUtilities;
import com.hexidec.ekit.component.SimpleInfoDialog;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class ListAutomationAction
extends HTMLEditorKit.InsertHTMLTextAction {
    protected GSHTMLEditor parentEkit;
    private HTML.Tag baseTag;
    private String sListType;
    private HTMLUtilities htmlUtilities;

    public ListAutomationAction(GSHTMLEditor ekit, String sLabel, HTML.Tag listType) {
        super(sLabel, "", listType, HTML.Tag.LI);
        this.parentEkit = ekit;
        this.baseTag = listType;
        this.htmlUtilities = new HTMLUtilities(ekit);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            JTextPane jepEditor = this.parentEkit.getTextPane();
            String selTextBase = jepEditor.getSelectedText();
            int textLength = -1;
            if (selTextBase != null) {
                textLength = selTextBase.length();
            }
            if (selTextBase == null || textLength < 1) {
                int pos = this.parentEkit.getCaretPosition();
                this.parentEkit.setCaretPosition(pos);
                if (ae.getActionCommand() != "newListPoint" && (this.htmlUtilities.checkParentsTag(HTML.Tag.OL) || this.htmlUtilities.checkParentsTag(HTML.Tag.UL))) {
                    SimpleInfoDialog sidWarn = new SimpleInfoDialog(this.parentEkit.getFrame(), "", true, "Lists cannot be created inside other lists.", 0);
                }
                String sListType = this.baseTag == HTML.Tag.OL ? "ol" : "ul";
                StringBuffer sbNew = new StringBuffer();
                if (this.htmlUtilities.checkParentsTag(this.baseTag)) {
                    sbNew.append("<li></li>");
                    this.insertHTML(this.parentEkit.getTextPane(), this.parentEkit.getExtendedHtmlDoc(), this.parentEkit.getTextPane().getCaretPosition(), sbNew.toString(), 0, 0, HTML.Tag.LI);
                } else {
                    sbNew.append("<" + sListType + "><li></li></" + sListType + "><br>");
                    this.insertHTML(this.parentEkit.getTextPane(), this.parentEkit.getExtendedHtmlDoc(), this.parentEkit.getTextPane().getCaretPosition(), sbNew.toString(), 0, 0, sListType.equals("ol") ? HTML.Tag.OL : HTML.Tag.UL);
                }
                this.parentEkit.refreshOnUpdate();
            } else {
                String sListType = this.baseTag == HTML.Tag.OL ? "ol" : "ul";
                HTMLDocument htmlDoc = (HTMLDocument)jepEditor.getDocument();
                int iStart = jepEditor.getSelectionStart();
                int iEnd = jepEditor.getSelectionEnd();
                String selText = htmlDoc.getText(iStart, iEnd - iStart);
                StringBuffer sbNew = new StringBuffer();
                String sToken = selText.indexOf("\r") > -1 ? "\r" : "\n";
                StringTokenizer stTokenizer = new StringTokenizer(selText, sToken);
                sbNew.append("<" + sListType + ">");
                while (stTokenizer.hasMoreTokens()) {
                    sbNew.append("<li>");
                    sbNew.append(stTokenizer.nextToken());
                    sbNew.append("</li>");
                }
                sbNew.append("</" + sListType + "><br>");
                htmlDoc.remove(iStart, iEnd - iStart);
                this.insertHTML(jepEditor, htmlDoc, iStart, sbNew.toString(), 1, 1, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

