package smart_gs.util;

import java.io.File;

// The grammar of GS <StandardPath> is
//  <StandardPath> := [[A-z]:]/<StandardRelativePath> | <StandardRelativePath> | <StandardAbsolutePath>
//  <StandardAbsolutePath> := <DottedPath> | <NonDottedPath>
//  
//  [A-z]:/<standardRelativePath>
//  <GenuineWinPath> := 
public class GSStandardPath {
	
	public static String normalizeSeparators(String string) {
		String copy = new String(string);
		String ans = copy.replaceAll("[\\x2f\\x5c]+", "/");
		return ans;
	}

	public static String win2unix(String dir) {
		String ans = normalizeSeparators(dir);
		ans = StringUtils.replaceString(ans, "\\", "/");
		return ans;
	}
	
	public static String unix2win(String dir) {
		String ans = normalizeSeparators(dir);
		ans = StringUtils.replaceString(ans,"/","\\" );
		return ans;
	}
	
	public static String win2mac(String dir) {
		return win2unix(dir);
	}
	
	public static String mac2win(String dir) {
		return unix2win(dir);
	}
	
	public static String unix2mac(String dir) {
		return normalizeSeparators(dir);
	}
	
	public static String mac2unix(String dir) {
		return normalizeSeparators(dir);
	}
	
	// The standard is UNIX format
	public static String toStandardOnCurrentOS(String string) {
		string = normalizeSeparators(string);
		if (isGenuineWinPath(string)) {
			return win2standard(string);
		} 
		return string;
	}
	
	private static boolean isGenuineWinPath(String string) {
		if (string.indexOf('\\') != -1) return true;
		if (string.indexOf(':') != -1) return true;
		return false;
	}

	// The standard is UNIX format
	public static String toStandardOnPathGrammar(String string) {
//TODO
		return win2unix(string);
	}
	
	public static String addSeparatorToEnd (String pathString){
		char lastChar = pathString.charAt(pathString.length()-1);
		if (lastChar == '/'){
			return pathString;
		} else {
			return pathString + '/';
		}
	}
	
	public static String addSeparatorToBeginning (String pathString){
		if (pathString.length() == 0) return new String();
		char firstChar = pathString.charAt(0);
		if (firstChar == '/'){
			return pathString;
		} else {
			return '/' + pathString;
		}
	}
	
	public static String concStandardPaths (String fst, String snd) {
		System.out.println(fst);
		System.out.println(snd);
		if (fst.length() ==0 || snd.length() == 0) return null;
		if (snd.charAt(0) != '/') {
			snd = snd.substring(1, snd.length());
		}
		return addSeparatorToEnd(fst) + snd;
	}
	
//	an alias
	public static String win2standard(String dir) {
		return win2unix(dir);
	}
	
//	an alias
	public static String standardizeFileName(String string) {
		return win2unix(string);
	}

	public static String standardizeDirName(String string) {
		String tmp = win2unix(string);
		return addSeparatorToEnd(tmp);
	}
}
