package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.action.ChangeSizeAction;
import smart_gs.smleditor.swingui.GSTreeTextEditortPaneMamager;
import smart_gs.swingui.toolbar.action.DeleteDscFileAction;
import smart_gs.swingui.toolbar.action.DeleteLineSegmentsFileAction;
import smart_gs.swingui.toolbar.action.DscCompileAction;
import smart_gs.swingui.toolbar.action.ImportDscFileAction;
import smart_gs.swingui.toolbar.action.LineSegDscInformationAction;
import smart_gs.swingui.toolbar.action.ReadSegmentInfoAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAndDscCompileAction;
import smart_gs.swingui.toolbar.action.PolygonalLineActionListener;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;
import sml_editor.swingui.toolbar.action.SaveLineSegmentsAction;

public class LineSegmentsEditingFrame extends JFrame {
	private static JToggleButton polygonalLine = null;
	private static boolean polygonalLineSelect = false;
	private static LineSegmentsEditingFrame singleton;

	//	shayashi 2011.05.29
	//	This class implementation employs a modified singleton pattern so as 
	//	getInstance has an argument. It is to pass WorkspaceWindow to the class.
	//	Perhaps, it is more natural to make WorkspaceWindow a singleton.
	//	It is, however, not a singleton. And the passing WorkspaceWindow
	//	through arguments is employed for other tool bars. Thus, this time,
	//	I follow the old implementation style.
	//	It would be better to make WorkspaceWindow a singleton to rewrite
	//	this and other tool bars (and menu@bars as well?).

	public static LineSegmentsEditingFrame getInstance(AbstractGSWindow parent){
		if (singleton == null) {
			singleton = new LineSegmentsEditingFrame(parent);
		}
		return singleton;
	}

	private LineSegmentsEditingFrame(AbstractGSWindow parent){
		super("Editing Line Segments");
		Container contentPane = getContentPane();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				ImageLabel.setLineVisible(false);
			}
		});	
		
		polygonalLine = new JToggleButton("Edit Line Segments");
		//polygonalLine.setSelected(true);
		polygonalLine.addActionListener(new PolygonalLineActionListener());
		polygonalLine.setToolTipText("Edit Line Segments");
		//20081031 North Grid Removed
		polygonalLine.setAlignmentX(Component.CENTER_ALIGNMENT);
		polygonalLine.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(polygonalLine);

		JButton changeSize = new JButton("Zoom & Move");
		changeSize.addActionListener (new ChangeSizeAction(parent));
		changeSize.setToolTipText("Change Size");
		changeSize.setAlignmentX(Component.CENTER_ALIGNMENT);
		changeSize.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(changeSize);
		
		JButton readLSeg = new JButton("Read Line Segments");
		readLSeg.addActionListener(new ReadSegmentInfoAction(parent));
		readLSeg.setToolTipText("Read Line Segments");
		readLSeg.setAlignmentX(Component.CENTER_ALIGNMENT);
		readLSeg.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(readLSeg);
		
		JButton saveLSeg = new JButton("Save Line Segments");
		saveLSeg.addActionListener(new SaveLineSegmentsAction(parent));
		saveLSeg.setToolTipText("Save Line Segments");
		saveLSeg.setAlignmentX(Component.CENTER_ALIGNMENT);
		saveLSeg.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(saveLSeg);
		
		JButton infoLSeg = new JButton("Line Seg & DSC Information");
		infoLSeg.addActionListener(new LineSegDscInformationAction(parent,this));
		infoLSeg.setToolTipText("Line Seg & DSC Information");
		infoLSeg.setAlignmentX(Component.CENTER_ALIGNMENT);
		infoLSeg.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(infoLSeg);
		
		JButton deleteLSeg = new JButton("Delete Line Segments File");
		deleteLSeg.addActionListener(new DeleteLineSegmentsFileAction(parent));
		deleteLSeg.setToolTipText("Delete Line Segments File");
		deleteLSeg.setAlignmentX(Component.CENTER_ALIGNMENT);
		deleteLSeg.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(deleteLSeg);
		
		JButton createDSC = new JButton("Make DSC File");
		createDSC.addActionListener(new DscCompileAction(parent));
		createDSC.setToolTipText("Make DSC File");
		createDSC.setAlignmentX(Component.CENTER_ALIGNMENT);
		createDSC.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(createDSC);
		
		JButton createLineSegAndDSC = new JButton("Save Line Seg & Make DSC File");
		createLineSegAndDSC.addActionListener(new SaveLineSegmentsAndDscCompileAction(parent));
		createLineSegAndDSC.setToolTipText("Save Line Seg & Make DSC File");
		createLineSegAndDSC.setAlignmentX(Component.CENTER_ALIGNMENT);
		createLineSegAndDSC.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(createLineSegAndDSC);
		
		JButton deleteDSC = new JButton("Delete DSC File");
		deleteDSC.addActionListener(new DeleteDscFileAction(parent));
		deleteDSC.setToolTipText("Delete DSC File");
		deleteDSC.setAlignmentX(Component.CENTER_ALIGNMENT);
		deleteDSC.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(deleteDSC);
		
		JButton importDSC = new JButton("Import DSC File");
		importDSC.addActionListener(new ImportDscFileAction(parent));
		importDSC.setToolTipText("Import DSC File");
		importDSC.setAlignmentX(Component.CENTER_ALIGNMENT);
		importDSC.setMaximumSize(new Dimension(1000, 1000));
		getContentPane().add(importDSC);
		
//		The widest Button
		int width = createLineSegAndDSC.getWidth()+300;
		
		this.pack();
		deleteDSC.repaint();
	}

	public static boolean isPolygonalLineSelect(){
		return polygonalLineSelect;
	}

	public static void polygonalLineClaer(){
		polygonalLine.setSelected(false);
		polygonalLineSelect = false;
	}

	public static void polygonalLineSet(){
		polygonalLine.setSelected(true);
		polygonalLineSelect = true;
	}
}


