/* $Id: GSKeyEventPost.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.smleditor.swingui;

import java.awt.KeyEventPostProcessor;
import java.awt.event.KeyEvent;

public class GSKeyEventPost implements KeyEventPostProcessor{
	public boolean alt = false;
	public boolean ctrl = false;
	public boolean shift = false;
	public boolean postProcessKeyEvent(KeyEvent e) {
	    switch(e.getID()){
	    case KeyEvent.KEY_PRESSED:
	    	if(((e.getModifiersEx() & KeyEvent.SHIFT_DOWN_MASK) != 0)){
	    		shift = true;
            }
            if(((e.getModifiersEx() & KeyEvent.CTRL_DOWN_MASK) != 0)){
            	ctrl = true;
            }
            if(((e.getModifiersEx() & KeyEvent.ALT_DOWN_MASK) != 0)){
            	alt = true;
           	}
	      break;
	    case KeyEvent.KEY_RELEASED:
	    	int keycode = e.getKeyCode();
	    	if((keycode == 16)){
	    		shift = false;
            }
            if(keycode == 17){
            	ctrl = false;
            }
            if(keycode == 18){
            	alt = false;
            }
	      break;
	    case KeyEvent.KEY_TYPED:
	      break;
	    }
	    return false;
	}
	public boolean isAlt() {
		return alt;
	}
	public boolean isCtrl() {
		return ctrl;
	}
	public boolean isShift() {
		return shift;
	}

}
