/* $Id: PointerRightClickMenu.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.reasoning_web.swingui.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

import reasoning_web.logical.ResourcePointer;
public class PointerRightClickMenu extends JPopupMenu {
	private JMenuItem rename;
	private ResourcePointer pointer;

	public PointerRightClickMenu(ResourcePointer pointer) {
		this.pointer = pointer;
		this.rename = new JMenuItem("rename");
		this.rename.addActionListener(new ElementAction());
		this.add(rename);
	}

	class ElementAction implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			if (e.getSource().equals(rename)) {
				String name = pointer.getName();
				name = (String) JOptionPane
						.showInputDialog("Input pointer name", name);
				if (name != null) {
					pointer.setName(name);
				}
			}
		}
	}
}
