/* $Id: ExpNoteManager.java 365 2011-09-29 07:38:02Z shayashi $ */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;

public class ExpNoteManager {
	
	private static ExpNoteManager singleton = new ExpNoteManager();
	
	private List<GSExplanatoryNote> notes;
	
	private ExpNoteManager(){
		notes = new ArrayList<GSExplanatoryNote>();
	}
	public static ExpNoteManager getInstance() {
		return singleton;
	}
	public GSExplanatoryNote getExplanatoryNote(int id) {
		for(int i=0;i<notes.size();i++){
			if(notes.get(i).getId() == id){
				return notes.get(i);
			}
		}
		return null;
	}

	//2007/11/12 kazuhiro kobayashi
	public void addNote(GSExplanatoryNote note){
		this.notes.add(note);
	}
	
	public GSResource getResource(String uri) {
		for(int i=0;i<this.notes.size();i++){
			if(this.notes.get(i).equals(uri)){
				return this.notes.get(i);
			}
			GSResource segment = this.notes.get(i).getTextSegmentByURI(uri);
			if(segment != null){
				return segment;
			}
		}
		return null;
	}
	public GSExplanatoryNote getExplanatoryNoteByTextSegmentURI(String uri) {
		String expNoteURI = extractExplanatoryNoteURIfromTextSegment(uri);

		for(int i=0;i<this.notes.size();i++){
			if(URICreator.getURIWithoutHeader(this.notes.get(i)).equals(expNoteURI)){
				System.out.println("  return notes.get("+i+")");
				return this.notes.get(i);
			}
		}
		System.out.println("  return null");
		return null;
	}
	private String extractExplanatoryNoteURIfromTextSegment(String uri) {
		return uri.substring(uri.indexOf(URICreator.SEP2 + URICreator.EXPLANATORY_NOTE)+1);
	}
	
	public List<GSExplanatoryNote> getNotes() {
		return this.notes;
	}

	public boolean has(GSExplanatoryNote note) {
		List<GSExplanatoryNote> notes = this.notes;
		for (GSExplanatoryNote n: notes) {
			if (n.getURI() == note.getURI()) {
				System.out.println(n.getURI());
				return true;
			}
		}
		return false;
	}

}