/* $Id: SpreadSelectionListManager.java 131 2011-03-25 15:25:12Z shayashi $ */
package smart_gs.logical;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JOptionPane;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.logical.visitor.CreateXMLElementVisitor;
import smart_gs.spread_selection.GUISaveSpreadSelectionListAction;
import smart_gs.spread_selection.IndexChangeTable;
import smart_gs.spread_selection.NormalizedSelectionListInString;
import smart_gs.spread_selection.SelectionListMembershipChecker;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Pair;

public final class SpreadSelectionListManager {
	private ArrayList<SpreadSelectionList> selection_lists = new ArrayList();
	
	private static final SpreadSelectionListManager unique_instance = new SpreadSelectionListManager();
	
	private SpreadSelectionListManager(){};
	
	public static SpreadSelectionListManager getInstance(){
		return SpreadSelectionListManager.unique_instance;
	}
	
	public ArrayList<SpreadSelectionList> getSpreadSelectionLists() {
		return selection_lists;
	}
	
	public void cleraSpreadSlectionLists () {selection_lists.clear(); }
	
	public void addSpreadSelectionList(String name, String selectionList) {
		SpreadSelectionList ssl = getSpreadSelectionList(name);
		if (ssl != null){
			int answer =
				JOptionPane.showConfirmDialog(null, 
					name + " exists. Overwrite?", 
					"dummy string", JOptionPane.YES_NO_OPTION);
			if (answer ==0)	{
				ssl.setSpreadSelectionListSpec(selectionList);
			}
		}else 
			selection_lists.add(new SpreadSelectionList(name,selectionList));
		WorkspaceWindow.setUpdated(true);
	}
	
	public void deleteSpreadSelectionList(String name) {
		SpreadSelectionList ssl = getSpreadSelectionList(name);
		if (ssl == null){
			JOptionPane.showMessageDialog(null, name + " does not exist");
			return; 
		} else selection_lists.remove(ssl);
		WorkspaceWindow.setUpdated(true);
	}

	public String getSpreadSelectionListString (String SpreadSelectionListName){
		SpreadSelectionList result = getSpreadSelectionList(SpreadSelectionListName);
		if ( result != null )
			return result.getSpreadSelectionListSpec();
		else
			return null;
	}
	
	public SpreadSelectionList getSpreadSelectionList (String SpreadSelectionListName){
		Integer size = selection_lists.size();
		SpreadSelectionList result = null;
		int i;
		for (i = 0; i < size; i++) {
			if (SpreadSelectionListName != null){
				if (SpreadSelectionListName.equals(selection_lists.get(i).getName())){
					result  = (selection_lists.get(i));
					break;
				}
			}
		}
		return result;
	}

	public void adjustSpreadSelctionLists(IndexChangeTable ict) {
		Enumeration<SpreadSelectionList> enm = Collections.enumeration(SpreadSelectionListManager.getInstance().getSpreadSelectionLists());
		while (enm.hasMoreElements()) {
			SpreadSelectionList next = enm.nextElement();
			next.setSpreadSelectionListSpec(adjustSpreadSelectionList(next.getSpreadSelectionListSpec(),ict));
		}
		WorkspaceWindow.setUpdated(true);
	}
	
//	returns the adjusted SpreadSelectionList after the given correspondence
	public String adjustSpreadSelectionList(String oldSpreadSelectionList, IndexChangeTable ict) {	
		if (oldSpreadSelectionList == "") return "";
		
		ArrayList<Integer> newSelectionList = new ArrayList();
		String [] stringInterval_list;
		stringInterval_list = oldSpreadSelectionList.split(",");
		
		int size = stringInterval_list.length;

		for (int i = 0; i< size;i++) {
			String[] tmp = stringInterval_list[i].split("-");
			if (tmp.length == 1){
				newSelectionList.add(ict.get(Integer.parseInt(tmp[0].trim())));
			} else {
				int start = Integer.parseInt(tmp[0].trim());
				int end = Integer.parseInt(tmp[1].trim());
				for (int j = start; j <= end; j++) {
					int tmp_index = ict.get(j);
//					Note that if it's -1, the spread is just deleted by the last action on SpreadTree
					if ( tmp_index != -1 ) newSelectionList.add(tmp_index);
				}	
			}
		}
		
		return NormalizedSelectionListInString.convert(newSelectionList);
		
	}
	
	public void save(Document document, Element parent) {
		Element element = document.createElement("spreadSelectionLists");
		for (int i = 0; i < this.selection_lists.size(); i++) {
			element.appendChild(this.selection_lists.get(i).createXMLElement(document));
		}
		parent.appendChild(element);
	}

	public void restore(Element SpreadSlectionListsElement) {
		cleraSpreadSlectionLists ();

		NodeList elements = SpreadSlectionListsElement.getElementsByTagName("spreadSelectionList");

		for (int i = 0; i < elements.getLength(); i++) {
			Element currentElement = (Element)elements.item(i);
			String name, spec;
			name =  currentElement.getAttribute("name");
			spec =  currentElement.getAttribute("spec");
			addSpreadSelectionList(name,spec);

		}
	}
}
		