/* $Id: BookmarkMode.java 303 2011-08-18 23:45:09Z minao $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.logical.Preference;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.GSMouseEvent;

public class BookmarkMode  extends DrawingModeAdapter {

	private static Mode singleton = new BookmarkMode();

	public static Mode getInstance() {
		return singleton;
	}
	
	@Override
	public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas){
		String title = JOptionPane.showInputDialog("Title", "");
		if (title == null) {
			return;
		}
		if (title.equals("")) {
			title = "UNTITLED";
		}
		int x = (int)e.getPoint().getX();
		int y = (int)e.getPoint().getY();
		Point origin = new Point(x,y);
		BookmarkView view = new BookmarkView(origin, title, new Double(Preference.getInstance().getBookmarkSize()));
		BookmarkRegion region = new BookmarkRegion(canvas.getSpread(), view);
		canvas.addRegion(region);
	}
}
