/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.swingui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import smart_gs.logical.TextSegment;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.mouse_state.DefaultMouseMode;
import sml_editor.swingui.mouse_state.MouseMode;

public class EditorMouseListener
extends MouseAdapter
implements MouseMotionListener {
    protected EditorTextPane textPane;
    private static MouseMode mouseMode = DefaultMouseMode.getInstance();

    protected EditorMouseListener(EditorTextPane textPane) {
        this.textPane = textPane;
    }

    public static void restoreDefaultMouseMode() {
        mouseMode = DefaultMouseMode.getInstance();
    }

    public static void setMouseMode(MouseMode mode) {
        mouseMode = mode;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        mouseMode.mouseClicked(e, this.textPane);
        SimpleAttributeSet element = this.textPane.getSelectID(e.getPoint());
        if (element == null) {
            return;
        }
        int id = -1;
        try {
            id = new Integer((String)element.getAttribute(HTML.Attribute.HREF));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TextSegment segment = ((GSEditorTextPane)this.textPane).getSmartDocument().getSegmentByID(id);
        ReasoningWebFrame.getInstance().getElementsPanel().setElement(segment);
        GlobalViewPanel.getInstance().setSelectedElement(segment);
        GlobalViewPanel.getInstance().repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        mouseMode.mouseEntered(e, this.textPane);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        mouseMode.mouseExited(e, this.textPane);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        mouseMode.mousePressed(e, this.textPane);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        mouseMode.mouseReleased(e, this.textPane);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        mouseMode.mouseDragged(e, this.textPane);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        mouseMode.mouseMoved(e, this.textPane);
    }
}

