/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XMLSaver {
    private Document document;
    private String filename;

    public XMLSaver(Document document, String filename) {
        this.document = document;
        this.filename = filename;
    }

    public synchronized void save() {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.document);
            File file = new File(this.filename);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            transformer = null;
            file = null;
            result = null;
            source = null;
            writer.close();
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        factory = null;
    }
}

