/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import smart_gs.util.StringUtils;

public class GSStandardPath {
    public static String normalizeSeparators(String string) {
        String copy = new String(string);
        String ans = copy.replaceAll("[\\x2f\\x5c]+", "/");
        return ans;
    }

    public static String win2unix(String dir) {
        String ans = GSStandardPath.normalizeSeparators(dir);
        ans = StringUtils.replaceString(ans, "\\", "/");
        return ans;
    }

    public static String unix2win(String dir) {
        String ans = GSStandardPath.normalizeSeparators(dir);
        ans = StringUtils.replaceString(ans, "/", "\\");
        return ans;
    }

    public static String win2mac(String dir) {
        return GSStandardPath.win2unix(dir);
    }

    public static String mac2win(String dir) {
        return GSStandardPath.unix2win(dir);
    }

    public static String unix2mac(String dir) {
        return GSStandardPath.normalizeSeparators(dir);
    }

    public static String mac2unix(String dir) {
        return GSStandardPath.normalizeSeparators(dir);
    }

    public static String toStandardOnCurrentOS(String string) {
        if (GSStandardPath.isGenuineWinPath(string = GSStandardPath.normalizeSeparators(string))) {
            return GSStandardPath.win2standard(string);
        }
        return string;
    }

    private static boolean isGenuineWinPath(String string) {
        if (string.indexOf(92) != -1) {
            return true;
        }
        return string.indexOf(58) != -1;
    }

    public static String toStandardOnPathGrammar(String string) {
        return GSStandardPath.win2unix(string);
    }

    public static String addSeparatorToEnd(String pathString) {
        char lastChar = pathString.charAt(pathString.length() - 1);
        if (lastChar == '/') {
            return pathString;
        }
        return String.valueOf(pathString) + '/';
    }

    public static String addSeparatorToBeginning(String pathString) {
        if (pathString.length() == 0) {
            return new String();
        }
        char firstChar = pathString.charAt(0);
        if (firstChar == '/') {
            return pathString;
        }
        return String.valueOf('/') + pathString;
    }

    public static String concStandardPaths(String fst, String snd) {
        System.out.println(fst);
        System.out.println(snd);
        if (fst.length() == 0 || snd.length() == 0) {
            return null;
        }
        if (snd.charAt(0) != '/') {
            snd = snd.substring(1, snd.length());
        }
        return String.valueOf(GSStandardPath.addSeparatorToEnd(fst)) + snd;
    }

    public static String win2standard(String dir) {
        return GSStandardPath.win2unix(dir);
    }

    public static String standardizeFileName(String string) {
        return GSStandardPath.win2unix(string);
    }

    public static String standardizeDirName(String string) {
        String tmp = GSStandardPath.win2unix(string);
        return GSStandardPath.addSeparatorToEnd(tmp);
    }
}

