/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.text_search.swingui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import smart_gs.logical.IDAT;
import smart_gs.logical.Spread;
import smart_gs.logical.URISolver;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.text_search.logical.SearchResult;
import smart_gs.text_search.swingui.ResultPanel;

public class ResultListPanel
extends JPanel {
    private int sizeOfResults;
    private int sizeToDisplay;
    private int count = 0;
    String query;
    ArrayList<SearchResult> results;

    public ResultListPanel(String query, int sizeToDisplay, int sizeOfResults, ArrayList<SearchResult> results) {
        super(new GridLayout(sizeToDisplay, 1));
        this.sizeOfResults = sizeOfResults;
        this.sizeToDisplay = sizeToDisplay;
        this.setPreferredSize(new Dimension(250, 700));
        this.results = results;
        this.query = query;
        this.showResults();
    }

    private void showResults() {
        this.removeAll();
        int begin = this.count * this.sizeToDisplay;
        int end = Math.min((this.count + 1) * this.sizeToDisplay - 1, this.sizeOfResults - 1);
        WorkspaceWindow win = WorkspaceWindow.getInstance();
        boolean currentSpreadIsUndefined = win.getSpread() == null;
        int i = begin;
        while (i <= end) {
            SearchResult result = this.results.get(i);
            if (currentSpreadIsUndefined && result.isInAnIDAT()) {
                IDAT idat = (IDAT)URISolver.getResource(result.getDocumentURL());
                Spread spread = idat.getSpread();
                if (spread != null) {
                    win.setSpread(spread);
                    win.repaint();
                }
                currentSpreadIsUndefined = false;
            }
            ResultPanel panel = ResultPanel.getInstance(result.getTextToShow(), result.getDocumentURL(), result.getindex());
            this.add(panel);
            panel.setPreferredSize(new Dimension(380, 40));
            ++i;
        }
        this.setBorder(new TitledBorder("Results " + (begin + 1) + " - " + (end + 1) + " of " + this.sizeOfResults + " for \"" + this.query + "\""));
    }

    public void back() {
        if (this.count <= 0) {
            this.count = 0;
            this.showResults();
        } else {
            --this.count;
            this.showResults();
        }
    }

    public void next() {
        if ((this.count + 1) * this.sizeToDisplay >= this.sizeOfResults) {
            this.showResults();
        } else {
            ++this.count;
            this.showResults();
        }
    }
}

