/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.spread_selection;

import java.util.Date;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import smart_gs.spread_selection.TableMap;

class TableSorter
extends TableMap
implements TableModelListener {
    int[] indexes = new int[0];
    Vector sortingColumns = new Vector();
    boolean ascending = true;

    public TableSorter() {
    }

    public TableSorter(TableModel model) {
        this.setModel(model);
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
        this.sortByColumn(0);
        this.fireTableDataChanged();
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class type = this.getColumnClass(column);
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)data.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = data.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        int level = 0;
        int n = this.sortingColumns.size();
        while (level < n) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.ascending ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            this.indexes[row] = row;
            ++row;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.reallocateIndexes();
        this.sortByColumn(0);
        this.fireTableStructureChanged();
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    public void sort() {
        this.checkModel();
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        this.fireTableDataChanged();
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        int i = low;
        while (i < high) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            ++i;
        }
    }

    private void swap(int first, int second) {
        int temp = this.indexes[first];
        this.indexes[first] = this.indexes[second];
        this.indexes[second] = temp;
    }

    @Override
    public Object getValueAt(int row, int column) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[row], column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[row], column);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort();
        super.tableChanged(new TableModelEvent(this));
    }
}

