/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.spread_selection;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import smart_gs.spread_selection.CheckBoxNode;
import smart_gs.spread_selection.CheckBoxNodeRenderer;

class CheckBoxNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
    ChangeEvent changeEvent = null;
    JTree tree;

    public CheckBoxNodeEditor(JTree tree) {
        this.tree = tree;
    }

    @Override
    public Object getCellEditorValue() {
        JCheckBox checkbox = this.renderer.getLeafRenderer();
        CheckBoxNode checkBoxNode = new CheckBoxNode(checkbox.getText(), checkbox.isSelected(), Integer.valueOf(checkbox.getText().split(":", 2)[0]));
        return checkBoxNode;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        Object node;
        MouseEvent mouseEvent;
        TreePath path;
        boolean returnValue = false;
        if (event instanceof MouseEvent && (path = this.tree.getPathForLocation((mouseEvent = (MouseEvent)event).getX(), mouseEvent.getY())) != null && (node = path.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            Object userObject = treeNode.getUserObject();
            returnValue = treeNode.isLeaf() && userObject instanceof CheckBoxNode;
        }
        return returnValue;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CheckBoxNodeEditor.this.stopCellEditing()) {
                    CheckBoxNodeEditor.this.fireEditingStopped();
                }
            }
        };
        if (editor instanceof JCheckBox) {
            ((JCheckBox)editor).addItemListener(itemListener);
        }
        return editor;
    }
}

