/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import com.hexidec.ekit.GSHTMLEditorFoucsActionListner;
import com.hexidec.ekit.GSHTMLEditorSearchActionListner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.GSTabbedPaneManager;
import smart_gs.swingui.IDATNameInGSTabbedPaneManager;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.SearchToolBar;
import smart_gs.swingui.toolbar.UtilityToolBar;
import sml_editor.swingui.EditorTextPane;

public class GSEditor
extends AbstractGSWindow {
    public GSTabbedPane tabbedPane;
    private String url;
    protected int open = 0;
    protected AtomicLong id;
    private MoveTreeToolBar moveTreeToolBar;
    private Mode mode;
    private GSTabbedPaneWindowAdapter gsTabbedPaneWindowAdapter;

    public GSEditor(Spread spread) {
        super("Editor: " + spread.getName());
        MoveTreeToolBar moveTreeToolBar;
        this.url = spread.getURI();
        this.tabbedPane = this.createTabbedPane(spread);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        JPanel gsEditorToolBarPanel = new JPanel(new GridLayout(2, 1));
        JPanel panel1 = new JPanel(new FlowLayout(0));
        ImageToolBar imageToolBar = new ImageToolBar(this);
        panel1.add(imageToolBar);
        imageToolBar.enableIcons();
        panel1.add(new SearchToolBar(this));
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(new UtilityToolBar(this));
        panel2.add(new HistoryToolBar(this));
        this.moveTreeToolBar = moveTreeToolBar = new MoveTreeToolBar(this);
        panel2.add(moveTreeToolBar);
        this.updateMoveToolBar();
        gsEditorToolBarPanel.add(panel1);
        gsEditorToolBarPanel.add(panel2);
        this.add((Component)gsEditorToolBarPanel, "North");
        this.setSize(900, 700);
        this.id = GSTabbedPaneManager.getControlID();
        this.gsTabbedPaneWindowAdapter = new GSTabbedPaneWindowAdapter(this.url, String.valueOf(this.id), this.getSMLTabbedPane(), this);
        this.addWindowListener(this.gsTabbedPaneWindowAdapter);
    }

    public GSEditor(Spread spread, Rectangle2D rect) {
        this(spread);
        RectangleView view = new RectangleView(rect);
        view.setIsEmphasized(true);
        Point point = new Point((int)rect.getX(), (int)rect.getY());
        this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
        this.tabbedPane.getSpreadCanvas().addTempView(view);
    }

    public GSEditor(List<SearchResult> results) {
        this(results.get(0).getSpread());
        int i = 0;
        while (i < results.size()) {
            Rectangle rect = results.get(i).getRectangle();
            RectangleView view = new RectangleView(rect);
            view.setIsEmphasized(true);
            this.tabbedPane.getSpreadCanvas().addTempView(view);
            ++i;
        }
        Point point = results.get(0).getRectangle().getLocation();
        this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
    }

    public GSEditor(Region region) {
        this(region.getSpread());
        View view = region.getView();
        view.setIsEmphasized(true);
        Rectangle2D rect = view.getRectangle2D();
        Point point = new Point((int)rect.getX(), (int)rect.getY());
        this.tabbedPane.getSpreadCanvas().setCenterLocation(point);
        this.tabbedPane.getSpreadCanvas().addTempView(view);
    }

    public GSEditor(TextSegment segment) {
        super("Editor");
    }

    @Override
    public void setEditorTextPane(EditorTextPane textPane) {
        textPane.setSearchAction(new SearchAction(this.getGSEditorToolBar()));
        textPane.setFocusAction(new FoucsAction(this, this.getGSEditorToolBar()));
        this.tabbedPane.getGSEditorToolBar().setTextPane(textPane);
    }

    @Override
    public void setEditorToolBar(JToolBar toolbar) {
    }

    @Override
    public Spread getSpread() {
        return this.tabbedPane.getSpread();
    }

    public GSTabbedPane getSMLTabbedPane() {
        return this.tabbedPane;
    }

    public void updateMoveToolBar() {
        if (this.tabbedPane.getSpread() != null) {
            this.moveTreeToolBar.setPathCount(this.tabbedPane.getSpread().getPageViewIndex());
        }
    }

    @Override
    public void updateGUI(Spread spread) {
        this.validate();
    }

    @Override
    public SpreadCanvas getSpreadCanvas() {
        return this.tabbedPane.canvas;
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public GSTabbedPane createTabbedPane(Spread spread) {
        return new GSTabbedPane(this, spread);
    }

    public void emphasize(String id) {
        this.tabbedPane.emphasize(id);
    }

    public void updateText() {
        this.tabbedPane.updateText();
    }

    public String getURL() {
        return this.url;
    }

    public AtomicLong getControlID() {
        return this.id;
    }

    public GSEditorToolBar getGSEditorToolBar() {
        return this.tabbedPane.getGSEditorToolBar();
    }

    public void setCaret(int index) {
        this.getSMLTabbedPane().setCaret(index);
    }

    public void updateWindowListener() {
        this.removeWindowListener(this.gsTabbedPaneWindowAdapter);
        this.id = GSTabbedPaneManager.getControlID();
        this.gsTabbedPaneWindowAdapter = new GSTabbedPaneWindowAdapter(this.url, String.valueOf(this.id), this.getSMLTabbedPane(), this);
        this.addWindowListener(this.gsTabbedPaneWindowAdapter);
    }

    public int isOpened() {
        return this.open;
    }

    @Override
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setURL(String url) {
        this.url = url;
    }

    private class FoucsAction
    implements GSHTMLEditorFoucsActionListner {
        protected GSEditorToolBar gsEditorToolBar;
        protected GSEditor gsEditor;

        public FoucsAction(GSEditor gsEditor, GSEditorToolBar gsEditorToolBar) {
            this.gsEditor = gsEditor;
            this.gsEditorToolBar = gsEditorToolBar;
        }

        @Override
        public void focusGained() {
            SearchAllDialogManager.setEditor(this.gsEditor, this.gsEditorToolBar);
            SearchDialogManager.setGSEditorToolBar(this.gsEditorToolBar);
        }

        @Override
        public void focusLost() {
        }
    }

    class GSTabbedPaneWindowAdapter
    extends WindowAdapter {
        protected String key;
        protected String id;
        protected GSTabbedPane gsTabbedPane;
        private AbstractGSWindow parent;

        public GSTabbedPaneWindowAdapter(String key, String id, GSTabbedPane gsTabbedPane, AbstractGSWindow parent) {
            this.key = key;
            this.id = id;
            this.gsTabbedPane = gsTabbedPane;
            this.parent = parent;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            IDATNameInGSTabbedPaneManager.unregistorGSEditorTabbedPane(this.gsTabbedPane);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SearchDialogManager.setGSEditorToolBar(GSEditor.this.getGSEditorToolBar());
            GSTabbedPane newTabbedPane = GSTabbedPaneManager.getGSTabbedPane(this.key);
            if (newTabbedPane != null) {
                String windowid = GSTabbedPaneManager.getWindowsID(this.key);
                if (windowid == null) {
                    return;
                }
                if (windowid.equals(String.valueOf(this.key) + this.id)) {
                    return;
                }
                newTabbedPane.save();
                String fstidatSource = newTabbedPane.getFirstIDATSource();
                this.gsTabbedPane.updateFirstIDAT(fstidatSource);
                String sndidatSource = newTabbedPane.getSecondIDATSource();
                this.gsTabbedPane.updateSecondIDAT(sndidatSource);
                String thrdidatSource = newTabbedPane.getThirdIDATSource();
                this.gsTabbedPane.updateThirdIDAT(thrdidatSource);
                this.gsTabbedPane.updateText();
                this.gsTabbedPane.save();
                GSTabbedPaneManager.removeGSTabbedPane(this.key);
            }
            GSEditor.this.open = 1;
            Mode mode = ((GSEditor)this.parent).getMode();
            if (mode != null) {
                DefaultState.getInstance().setMode(mode);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.gsTabbedPane.save();
            GSTabbedPaneManager.setGSTabbedPane(this.key, String.valueOf(this.key) + this.id, this.gsTabbedPane);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            GSEditor.this.open = 2;
            GSTabbedPaneManager.close(String.valueOf(this.key) + this.id);
        }
    }

    private class SearchAction
    implements GSHTMLEditorSearchActionListner {
        protected GSEditorToolBar gsEditorToolBar;

        public SearchAction(GSEditorToolBar gsEditorToolBar) {
            this.gsEditorToolBar = gsEditorToolBar;
        }

        @Override
        public void actionPerformed() {
            SearchDialogManager.setGSEditorToolBar(this.gsEditorToolBar);
            SearchDialogManager.visible();
        }
    }
}

