/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.menu.action;

import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import smart_gs.logical.Preference;
import smart_gs.menu.DirectorySettingWindow;
import smart_gs.menu.action.SetDirectoryPathAction;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSImageFileUtils;

public class SetRWBackgroundFilePathAction
extends SetDirectoryPathAction
implements ActionListener {
    public SetRWBackgroundFilePathAction() {
        this.chooser.setDialogTitle("RW background file");
        this.chooser.setFileSelectionMode(2);
        this.chooser.setFileFilter(new ImageFileFilter());
    }

    @Override
    protected String getOldPath() {
        return Preference.getInstance().getRWBackgroundFilePathString();
    }

    @Override
    protected void validateNewPath(String newPath) {
        DirectorySettingWindow.getInstance().setRWBackgroundFileField(newPath);
    }

    public class ImageFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File pathname) {
            String name = CanonicalPathString.get(pathname);
            if (GSImageFileUtils.isAcceptable(pathname.getName())) {
                return true;
            }
            return pathname.isDirectory();
        }

        @Override
        public String getDescription() {
            return GSImageFileUtils.getDescription();
        }
    }
}

