/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.URIObject;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteTree;
import smart_gs.reasoning_web.logical.ExpNoteManager;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

public class URISolver {
    private static final String HEADER = "smart://";

    public static Region getRegion(String uri) {
        Region region = null;
        Spread spread = SpreadTree.getInstance().getSpreadByResourceURI(uri);
        if (spread == null) {
            return null;
        }
        region = spread.getRegionByURI(uri);
        return region;
    }

    public static GSResource getUsersNote(String uri) {
        UsersNote usersNote = UsersNoteTree.getInstance().getUsersNoteByURI(uri);
        return usersNote;
    }

    public static GSResource getSpreadResource(String uri) {
        Spread spread = SpreadTree.getInstance().getSpreadByResourceURI(uri);
        if (spread == null) {
            return null;
        }
        GSResource resource = spread.getResource(uri);
        if (resource == null) {
            return null;
        }
        return resource;
    }

    public static GSResource getTextSegmentFromUsersNote(String uri) {
        UsersNote usersNote = UsersNoteTree.getInstance().getUsersNoteByTextSegmentURI(uri);
        if (usersNote == null) {
            return null;
        }
        GSResource textSegment = usersNote.getTextSegmentByURI(uri);
        return textSegment;
    }

    public static Spread getSpread(String uri) {
        Spread spread = SpreadTree.getInstance().getSpreadByURI(uri);
        return spread;
    }

    public static Spread getSpreadByDocumentURI(String documentURI) {
        Spread spread = SpreadTree.getInstance().getSpreadByResourceURI(documentURI);
        return spread;
    }

    public static GSResource getResource(String uri) {
        Object resource = null;
        resource = uri.contains("smart://usersNote/") ? URISolver.getUsersNote(uri) : (uri.contains("smart://explanatory/") && !URISolver.isATextSegmentFromExplanatoryNote(uri) ? ExpNoteManager.getInstance().getResource(uri) : (uri.contains("smart://package/") ? null : (uri.contains("smart://document/") && !URISolver.isATextSegmentFromStandardTextDocument(uri) ? ReasoningWebFrame.getInstance().getDesktopPanel().getResource(uri) : (URISolver.isATextSegmentFromExplanatoryNote(uri) ? URISolver.getTextSegmentFromExplanatoryNote(uri) : (URISolver.isATextSegmentFromUsersNote(uri) ? URISolver.getTextSegmentFromUsersNote(uri) : URISolver.getSpreadResource(uri))))));
        return resource;
    }

    private static boolean isATextSegmentFromUsersNote(String uri) {
        return URISolver.isATextSegmentURI(uri) && URIObject.getTypeFrom(URIObject.getContainerURIFrom(uri)).equals("usersNote");
    }

    private static GSResource getTextSegmentFromExplanatoryNote(String uri) {
        GSExplanatoryNote expNote = ExpNoteManager.getInstance().getExplanatoryNoteByTextSegmentURI(uri);
        GSResource textSegment = expNote.getTextSegmentByURI(uri);
        return textSegment;
    }

    public static boolean isATextSegmentURI(String uri) {
        return uri.startsWith("smart://segment");
    }

    private static boolean isATextSegmentFromStandardTextDocument(String uri) {
        return uri.startsWith("smart://segment") && uri.contains("document") || uri.startsWith("smart://document") && uri.substring(HEADER.length()).contains("//");
    }

    public static boolean isATextSegmentFromFirstIDAT(String uri) {
        return URISolver.isATextSegmentURI(uri) && uri.contains("^firstIdat") && !uri.contains("^explanatory");
    }

    public static boolean isATextSegmentFromSecondIDAT(String uri) {
        return URISolver.isATextSegmentURI(uri) && uri.contains("^secondIdat") && !uri.contains("^explanatory");
    }

    public static boolean isATextSegmentFromThirdIDAT(String uri) {
        return URISolver.isATextSegmentURI(uri) && uri.contains("^thirdIdat") && !uri.contains("^explanatory");
    }

    public static boolean isATextSegmentFromExplanatoryNote(String uri) {
        return URISolver.isATextSegmentURI(uri) && uri.contains("^explanatory");
    }

    public static boolean isASmartDocumentURI(String uri) {
        return uri.startsWith("smart://document") || uri.startsWith("smart://firstIdat") || uri.startsWith("smart://secondIdat") || uri.startsWith("smart://thirdIdat") || uri.startsWith("smart://explanatory") || uri.startsWith("smart://usersNote");
    }

    public static int countSeparatorInURI(String uri) {
        String sep = "/";
        int count = 0;
        int i = 0;
        while (i < uri.length()) {
            if (uri.substring(i, i + 1).equals(sep)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String chopIdFromOldVersionURI(String uri) {
        int i = uri.length();
        while (i >= 0) {
            if (uri.substring(i - 1, i).equals("/")) {
                return uri.substring(0, i - 1);
            }
            --i;
        }
        return null;
    }
}

