/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.RWPackage;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.logical.AnchorTextSegment;
import smart_gs.logical.IDAT;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.TextSegment;
import smart_gs.logical.URIObject;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteDirectory;
import smart_gs.logical.Zombie;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GS_RWPackage;

public class URICreator {
    private static final String ANONYMOUS_USER = "AnonymousUser";
    private static String LAST_CREATED_TIME;
    private static int ADDITIONAL_EXTENSION;
    public static final String HEADER = "smart://";
    public static final String SEP1 = "/";
    public static final String SEP2 = "^";
    public static final String SEP3 = "#";
    public static final String SEP4 = "@";
    public static final String SPREAD_DIRECTORY = "directory";
    public static final String SPREAD = "spread";
    public static final String REGION = "region";
    public static final String LINE_SEGMENT = "linesegment";
    public static final String BOOKMARK = "bookmark";
    public static final String POLYGON = "polygon";
    public static final String RECTANGLE = "rect";
    public static final String MARKER = "marker";
    public static final String LINE = "line";
    public static final String MEMOPAD = "memopad";
    public static final String STANDARD_TEXT_DOCUMENT = "document";
    public static final String IDAT = "Idat";
    public static final String FIRST_IDAT = "firstIdat";
    public static final String SECOND_IDAT = "secondIdat";
    public static final String THIRD_IDAT = "thirdIdat";
    public static final String USERS_NOTE = "usersNote";
    public static final String EXPLANATORY_NOTE = "explanatory";
    public static final String TEXT_SEGMENT = "segment";
    public static final String CONNECTION = "connection";
    public static final String RWPACKAGE = "package";
    public static final String GS_RWPACKAGE = "gsRWPackage";
    public static final String GSQUERY = "query";
    public static final String SHORTCUT = "shortcut";
    public static final String BUCKET = "bucket";
    public static final String DESKTOP_FOLDER = "desktopFolder";
    public static final String USERS_NOTE_DIRECTORY = "usersNoteDirectory";
    public static final String ZOMBIE = "zombie";
    public static final String ANCHOR = "anchor";
    public static final String ANCHOR_TEXT_SEGMENT = "anchorTextSegment";
    public static final String RESOURCE_BASKET = "resourceBasket";

    public static String createURI(RWElement elm) {
        String type = elm.getTypeString();
        String uri = new String();
        if (type.equals(SPREAD_DIRECTORY)) {
            SpreadDirectory directory = (SpreadDirectory)elm;
            uri = directory.getParent() == null ? HEADER + type + SEP1 + "root" + SEP1 + URICreator.getURIExtension() : HEADER + URICreator.getURIWithoutHeaderNorUserNameDatePart(directory.getParent()) + URICreator.modifyName(directory.getName()) + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(USERS_NOTE_DIRECTORY)) {
            UsersNoteDirectory directory = (UsersNoteDirectory)elm;
            uri = directory.getParent() == null ? HEADER + type + SEP1 + "root" + SEP1 + URICreator.getURIExtension() : HEADER + URICreator.getURIWithoutHeaderNorUserNameDatePart(directory.getParent()) + URICreator.modifyName(directory.getName()) + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(SPREAD)) {
            Spread spread = (Spread)elm;
            String fileName = Spread.getFileNameWithoutExtension(spread.getFile());
            String dirURIWithoutHeader = spread.getSpreadDirParent().getURI().substring(HEADER.length());
            uri = HEADER + type + SEP1 + URICreator.modifyName(fileName) + SEP1 + URICreator.getURIExtension() + SEP2 + dirURIWithoutHeader;
        } else if (URICreator.isARegion(type)) {
            Region region = (Region)elm;
            uri = HEADER + type + SEP1 + URICreator.getURIExtension() + SEP2 + URICreator.getURIWithoutHeader(region.spread);
        } else if (URICreator.isAnIDAT(type)) {
            IDAT idat = (IDAT)elm;
            uri = HEADER + type + SEP1 + URICreator.getURIExtension() + SEP2 + URICreator.getURIWithoutHeader(idat.spread);
        } else if (type.equals(USERS_NOTE)) {
            UsersNote usersNote = (UsersNote)elm;
            String dir = usersNote.getUsersNoteDirParent() != null ? URICreator.getURIWithoutHeader(usersNote.getUsersNoteDirParent()) : "UNKNOWN_DIRECTORY";
            uri = HEADER + type + SEP1 + URICreator.modifyName(usersNote.name) + SEP1 + URICreator.getURIExtension() + SEP2 + dir;
        } else if (type.equals(EXPLANATORY_NOTE)) {
            ExplanatoryNote note = (ExplanatoryNote)elm;
            String name = note.getName();
            uri = HEADER + type + SEP1 + URICreator.modifyName(name) + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(TEXT_SEGMENT)) {
            TextSegment segment = (TextSegment)elm;
            uri = HEADER + type + SEP1 + URICreator.getURIExtension();
            if (segment.getDocument() != null) {
                uri = String.valueOf(uri) + SEP2 + URICreator.getURIWithoutHeader(segment.getDocument());
            }
        } else if (type.equals(ANCHOR_TEXT_SEGMENT)) {
            AnchorTextSegment segment = (AnchorTextSegment)elm;
            uri = HEADER + type + SEP1 + URICreator.getURIExtension();
            if (segment.getDocument() != null) {
                uri = String.valueOf(uri) + SEP2 + URICreator.getURIWithoutHeader(segment.getDocument());
            }
        } else if (type.equals(CONNECTION)) {
            GSConnection connection = (GSConnection)elm;
            String sourceURI = URICreator.getURIWithoutHeader(connection.getSourceRWElement());
            String targetURI = URICreator.getURIWithoutHeader(connection.getTargetRWElement());
            uri = HEADER + type + SEP1 + URICreator.modifyName(connection.getName()) + SEP1 + URICreator.getURIExtension() + SEP3 + sourceURI + SEP4 + targetURI;
        } else if (type.equals(STANDARD_TEXT_DOCUMENT)) {
            uri = HEADER + type + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(RWPACKAGE)) {
            RWPackage pack = (RWPackage)elm;
            uri = HEADER + type + SEP1 + URICreator.modifyName(pack.getName()) + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(GS_RWPACKAGE)) {
            GS_RWPackage pack = (GS_RWPackage)elm;
            uri = HEADER + type + SEP1 + URICreator.modifyName(pack.getName()) + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(BUCKET)) {
            uri = HEADER + type + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(GSQUERY)) {
            GSQuery query = (GSQuery)elm;
            String ext = "";
            if (query.hasSpread()) {
                ext = SEP2 + URICreator.getURIWithoutHeader(query.getSpread());
            }
            uri = HEADER + type + SEP1 + URICreator.modifyName(query.getName()) + SEP1 + URICreator.getURIExtension() + ext;
        } else if (type.equals(SHORTCUT)) {
            uri = HEADER + type + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(DESKTOP_FOLDER)) {
            DeskTopFolder folder = (DeskTopFolder)elm;
            uri = folder.getParent() == null ? HEADER + type + SEP1 + "root" + SEP1 + URICreator.getURIExtension() : String.valueOf(URIObject.chopLast(folder.getParent().getURI())) + URICreator.modifyName(folder.getName()) + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(RESOURCE_BASKET)) {
            ResourceBasket resourceBasket = (ResourceBasket)elm;
            uri = HEADER + type + SEP1 + URICreator.modifyName(resourceBasket.getName()) + SEP1 + URICreator.getURIExtension();
        } else if (type.equals(ZOMBIE)) {
            Zombie zombie = (Zombie)elm;
            uri = HEADER + type + SEP1 + URICreator.getURIExtension() + SEP2 + zombie.getDeadURI().substring(HEADER.length());
        } else {
            uri = "UNKNOWN_URI";
        }
        return uri;
    }

    private static String getURIWithoutHeaderNorUserNameDatePart(SpreadDirectory elem) {
        return URICreator.auxiliaryMethod01(elem);
    }

    private static String getURIWithoutHeaderNorUserNameDatePart(UsersNoteDirectory elem) {
        return URICreator.auxiliaryMethod01(elem);
    }

    private static String auxiliaryMethod01(RWElement elem) {
        int lastIndex;
        String bodyPart = URICreator.getURIWithoutHeader(elem);
        if (bodyPart.charAt(lastIndex = bodyPart.length() - 1) == '/') {
            --lastIndex;
        }
        int answer = lastIndex;
        int i = lastIndex;
        while (i >= 0) {
            if (bodyPart.charAt(i) == '/') {
                answer = i;
                break;
            }
            --i;
        }
        i = answer - 1;
        while (i >= 0) {
            if (bodyPart.charAt(i) == '/') {
                answer = i;
                break;
            }
            --i;
        }
        return String.valueOf(bodyPart.substring(0, answer)) + SEP1;
    }

    public static String getURIExtension() {
        String date = URIObject.getDate();
        String add_ext = URICreator.additionalExtension(date);
        LAST_CREATED_TIME = date;
        String name = Preference.getInstance().getUserName();
        if (name == null || name == "") {
            return "AnonymousUser/" + date + add_ext + SEP1;
        }
        return String.valueOf(URICreator.modifyName(name)) + SEP1 + date + add_ext + SEP1;
    }

    private static String additionalExtension(String created_date) {
        String s = "";
        if (created_date.equals(LAST_CREATED_TIME)) {
            s = "(" + Integer.toString(++ADDITIONAL_EXTENSION) + ")";
        } else {
            ADDITIONAL_EXTENSION = 0;
        }
        return s;
    }

    public static final String modifyName(String name) {
        if (name.equals("")) {
            return "UNNAMED";
        }
        return name;
    }

    public static final String getURIWithoutHeader(RWElement elm) {
        return elm.getURI().substring(HEADER.length());
    }

    public static Object getOriginalURIWithoutHeader(URIBearer ub) {
        return ub.getOriginalURI().substring(HEADER.length());
    }

    public static final boolean isARegion(String type) {
        return type.equals(RECTANGLE) || type.equals(MARKER) || type.equals(POLYGON) || type.equals(MEMOPAD) || type.equals(BOOKMARK) || type.equals(LINE) || type.endsWith(ANCHOR);
    }

    public static final boolean isAnIDAT(String type) {
        return type.equals(FIRST_IDAT) || type.equals(SECOND_IDAT) || type.equals(THIRD_IDAT);
    }

    public static void setURIs(URIBearer ub, String uri, String originalURI) {
        ub.setURI(uri);
        ub.setOriginalURI(originalURI);
    }
}

