/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.logical.SpreadSelectionList;
import smart_gs.spread_selection.IndexChangeTable;
import smart_gs.spread_selection.NormalizedSelectionListInString;
import smart_gs.swingui.WorkspaceWindow;

public final class SpreadSelectionListManager {
    private ArrayList<SpreadSelectionList> selection_lists = new ArrayList();
    private static final SpreadSelectionListManager unique_instance = new SpreadSelectionListManager();

    private SpreadSelectionListManager() {
    }

    public static SpreadSelectionListManager getInstance() {
        return unique_instance;
    }

    public ArrayList<SpreadSelectionList> getSpreadSelectionLists() {
        return this.selection_lists;
    }

    public void cleraSpreadSlectionLists() {
        this.selection_lists.clear();
    }

    public void addSpreadSelectionList(String name, String selectionList) {
        SpreadSelectionList ssl = this.getSpreadSelectionList(name);
        if (ssl != null) {
            int answer = JOptionPane.showConfirmDialog(null, String.valueOf(name) + " exists. Overwrite?", "dummy string", 0);
            if (answer == 0) {
                ssl.setSpreadSelectionListSpec(selectionList);
            }
        } else {
            this.selection_lists.add(new SpreadSelectionList(name, selectionList));
        }
        WorkspaceWindow.setUpdated(true);
    }

    public void deleteSpreadSelectionList(String name) {
        SpreadSelectionList ssl = this.getSpreadSelectionList(name);
        if (ssl == null) {
            JOptionPane.showMessageDialog(null, String.valueOf(name) + " does not exist");
            return;
        }
        this.selection_lists.remove(ssl);
        WorkspaceWindow.setUpdated(true);
    }

    public String getSpreadSelectionListString(String SpreadSelectionListName) {
        SpreadSelectionList result = this.getSpreadSelectionList(SpreadSelectionListName);
        if (result != null) {
            return result.getSpreadSelectionListSpec();
        }
        return null;
    }

    public SpreadSelectionList getSpreadSelectionList(String SpreadSelectionListName) {
        Integer size = this.selection_lists.size();
        SpreadSelectionList result = null;
        int i = 0;
        while (i < size) {
            if (SpreadSelectionListName != null && SpreadSelectionListName.equals(this.selection_lists.get(i).getName())) {
                result = this.selection_lists.get(i);
                break;
            }
            ++i;
        }
        return result;
    }

    public void adjustSpreadSelctionLists(IndexChangeTable ict) {
        Enumeration<SpreadSelectionList> enm = Collections.enumeration(SpreadSelectionListManager.getInstance().getSpreadSelectionLists());
        while (enm.hasMoreElements()) {
            SpreadSelectionList next = enm.nextElement();
            next.setSpreadSelectionListSpec(this.adjustSpreadSelectionList(next.getSpreadSelectionListSpec(), ict));
        }
        WorkspaceWindow.setUpdated(true);
    }

    public String adjustSpreadSelectionList(String oldSpreadSelectionList, IndexChangeTable ict) {
        if (oldSpreadSelectionList == "") {
            return "";
        }
        ArrayList<Integer> newSelectionList = new ArrayList<Integer>();
        String[] stringInterval_list = oldSpreadSelectionList.split(",");
        int size = stringInterval_list.length;
        int i = 0;
        while (i < size) {
            String[] tmp = stringInterval_list[i].split("-");
            if (tmp.length == 1) {
                newSelectionList.add(ict.get(Integer.parseInt(tmp[0].trim())));
            } else {
                int start = Integer.parseInt(tmp[0].trim());
                int end = Integer.parseInt(tmp[1].trim());
                int j = start;
                while (j <= end) {
                    int tmp_index = ict.get(j);
                    if (tmp_index != -1) {
                        newSelectionList.add(tmp_index);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return NormalizedSelectionListInString.convert(newSelectionList);
    }

    public void save(Document document, Element parent) {
        Element element = document.createElement("spreadSelectionLists");
        int i = 0;
        while (i < this.selection_lists.size()) {
            element.appendChild(this.selection_lists.get(i).createXMLElement(document));
            ++i;
        }
        parent.appendChild(element);
    }

    public void restore(Element SpreadSlectionListsElement) {
        this.cleraSpreadSlectionLists();
        NodeList elements = SpreadSlectionListsElement.getElementsByTagName("spreadSelectionList");
        int i = 0;
        while (i < elements.getLength()) {
            Element currentElement = (Element)elements.item(i);
            String name = currentElement.getAttribute("name");
            String spec = currentElement.getAttribute("spec");
            this.addSpreadSelectionList(name, spec);
            ++i;
        }
    }
}

