/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.logical.TextType;
import smart_gs.util.GSUserNameGrammarChecker;

public class Preference {
    private static Preference singleton = new Preference();
    private String userName;
    private String gsFolderPathString;
    private String imageFolderPathString;
    private String dscFolderPathString;
    private String smart_exportFolderPathString;
    private String defaultGsFilePathString;
    private String nameCorrespondenceFilePathString;
    private String RWBackgroundFilePathString;
    private boolean shouldLoadAll = false;
    private int filemode = 0;
    private String webdavServerPathString;
    private String webdavUserName;
    private String webdavPassword;
    private String browser;
    private String webdavunlock;
    private String editor;
    private String searchImageDictionaryLogic;
    private String proxyAddress;
    private String proxyPort;
    private static String preferenceFile = "preference.xml";
    private static String preferenceDefaultFile = "preference-default.xml";
    private String firstIDATName;
    private String secondIDATName;
    private String thirdIDATName;
    private String markupMovability = "false";
    private String memoPadColor = "green";
    private String markerColor = "yellow";
    private String markerBreadth = "15";
    private String bookmarkSize = "1.0";
    private String resourceBasketSaveOption = "false";

    public static Preference getInstance() {
        return singleton;
    }

    public boolean shouldLoadAll() {
        return this.shouldLoadAll;
    }

    public void setShouldLoadAll(boolean shouldLoadAll) {
        this.shouldLoadAll = shouldLoadAll;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName0) {
        if (GSUserNameGrammarChecker.checks(userName0)) {
            this.userName = userName0;
        } else {
            JOptionPane.showMessageDialog(null, "Error: a username must be a non-empty string of digits, alphabets, and -._@\nof at least 3 chars starting with an alphabet", "message", 1);
        }
    }

    public String getFirstIDATName() {
        return this.firstIDATName;
    }

    public void setFirstIDATName(String name) {
        this.firstIDATName = name;
    }

    public String getSecondIDATName() {
        return this.secondIDATName;
    }

    public void setSecondIDATName(String name) {
        this.secondIDATName = name;
    }

    public String getThirdIDATName() {
        return this.thirdIDATName;
    }

    public void setThirdIDATName(String name) {
        this.thirdIDATName = name;
    }

    public int load() {
        Properties properties;
        block26: {
            properties = new Properties();
            File file = new File(preferenceFile);
            if (!file.exists()) {
                File defaultFile = new File(preferenceDefaultFile);
                FileUtils.copyFile(defaultFile, file);
            }
            FileInputStream inStream = new FileInputStream(file);
            properties.loadFromXML(inStream);
            this.userName = properties.getProperty("userName");
            if (this.userName.equals("")) {
                this.userName = JOptionPane.showInputDialog("Enter user name: a string of digits, alphabets, and -._@\nof at least 3 chars starting with an alphabet");
            }
            if (this.userName == null) {
                this.userName = "";
            }
            Object[] options = new Object[]{"Input username", "Abort SMART-GS"};
            boolean nameCheck = false;
            boolean abortByUser = false;
            do {
                if (GSUserNameGrammarChecker.checks(this.userName)) {
                    Preference.getInstance().setUserName(this.userName);
                    nameCheck = true;
                    continue;
                }
                nameCheck = false;
                String oldUserName = this.userName;
                int answer = JOptionPane.showOptionDialog(null, "\"" + this.userName + "\"" + " invalid username\nUsername must be a string of digits, alphabets, and -._@\nof at least 3 chars starting with an alphabet", "user name request", 0, 3, null, options, options[0]);
                if (answer == 0) {
                    oldUserName = this.userName;
                    this.userName = JOptionPane.showInputDialog("Enter user name");
                    if (this.userName != null) continue;
                    this.userName = oldUserName;
                    continue;
                }
                abortByUser = true;
                break;
            } while (!nameCheck);
            if (!abortByUser) break block26;
            return 1;
        }
        try {
            String resourceBasketSaveOptionString;
            String bookmarkSizeString;
            int searchEngine;
            int max = new Integer(properties.getProperty("search_max"));
            GSSearchEngine.getInstance().setMaxFound(max);
            String searchEngineString = properties.getProperty("image_seatch_engine");
            int n = searchEngine = searchEngineString == null ? 0 : new Integer(searchEngineString);
            if (searchEngine == 0) {
                GSSearchEngine.getInstance().setUseExternalEngine(true);
            } else {
                GSSearchEngine.getInstance().setUseExternalEngine(false);
            }
            int searchType = new Integer(properties.getProperty("search_type"));
            GSSearchEngine.getInstance().setSearchType(searchType);
            int textType = new Integer(properties.getProperty("text_type"));
            TextType.setTextType(textType);
            this.gsFolderPathString = properties.getProperty("gsFolderPath");
            if (this.gsFolderPathString == null || this.gsFolderPathString.equals("")) {
                this.gsFolderPathString = "./smart_gs/gs/";
            }
            this.imageFolderPathString = properties.getProperty("imageFolderPath");
            if (this.imageFolderPathString == null || this.imageFolderPathString.equals("")) {
                this.imageFolderPathString = "./smart_gs/images/";
            }
            this.dscFolderPathString = properties.getProperty("dscFolderPath");
            if (this.dscFolderPathString == null || this.dscFolderPathString.equals("")) {
                this.dscFolderPathString = "./smart_gs/images/";
            }
            this.smart_exportFolderPathString = properties.getProperty("smart_exportFolderPath");
            this.defaultGsFilePathString = properties.getProperty("defaultGsFilePath");
            this.RWBackgroundFilePathString = properties.getProperty("RWBackgroundFilePath");
            try {
                this.filemode = Integer.parseInt(properties.getProperty("file_mode"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.webdavServerPathString = properties.getProperty("WebDavServerPath");
            this.webdavUserName = properties.getProperty("WebDavUserName");
            this.webdavPassword = properties.getProperty("WebDavPassword");
            this.browser = properties.getProperty("browser");
            this.editor = properties.getProperty("editor");
            this.webdavunlock = properties.getProperty("WebDavUnlock");
            if (this.webdavunlock == null) {
                this.webdavunlock = "1";
            }
            this.searchImageDictionaryLogic = properties.getProperty("SearchLogic");
            if (this.searchImageDictionaryLogic == null) {
                this.searchImageDictionaryLogic = "0";
            }
            this.firstIDATName = properties.getProperty("firstIDATName");
            if (this.firstIDATName == null) {
                this.firstIDATName = "Note1";
            }
            this.secondIDATName = properties.getProperty("secondIDATName");
            if (this.secondIDATName == null) {
                this.secondIDATName = "Note2";
            }
            this.thirdIDATName = properties.getProperty("thirdIDATName");
            if (this.thirdIDATName == null) {
                this.thirdIDATName = "Note3";
            }
            this.proxyAddress = properties.getProperty("ProxyAddress");
            this.proxyPort = properties.getProperty("ProxyPort");
            String movabilityString = properties.getProperty("markupMovability");
            if (movabilityString == null) {
                this.markupMovability = "false";
            } else {
                this.markupMovability = properties.getProperty("markupMovability");
                boolean markupMovable = new Boolean(this.markupMovability);
                UniSelectedState.getInstance().setMarkupMovability(markupMovable);
            }
            String memoPadColorString = properties.getProperty("memoPadColor");
            this.memoPadColor = memoPadColorString == null ? "green" : memoPadColorString;
            String markerColorString = properties.getProperty("markerColor");
            this.markerColor = markerColorString == null ? "yellow" : markerColorString;
            String makerBreadthString = properties.getProperty("markerBreadth");
            this.markerBreadth = makerBreadthString == null ? "15" : properties.getProperty("markerBreadth");
            if (new Integer(this.markerBreadth) < 5) {
                this.markerBreadth = "15";
            }
            this.bookmarkSize = (bookmarkSizeString = properties.getProperty("bookmarkSize")) == null ? "1.0" : properties.getProperty("bookmarkSize");
            if (!BookmarkView.properSize(new Double(this.bookmarkSize))) {
                this.bookmarkSize = "1.0";
            }
            this.resourceBasketSaveOption = (resourceBasketSaveOptionString = properties.getProperty("resourceBasketSaveOption")) == null ? "false" : properties.getProperty("resourceBasketSaveOption");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void save() {
        Properties properties = new Properties();
        properties.put("userName", this.userName);
        int max = GSSearchEngine.getInstance().getMaxFound();
        properties.put("search_max", String.valueOf(max));
        if (GSSearchEngine.getInstance().isUseExternalEngine()) {
            properties.put("image_seatch_engine", "0");
        } else {
            properties.put("image_seatch_engine", "1");
        }
        int searchType = GSSearchEngine.getInstance().getSearchType();
        properties.put("search_type", String.valueOf(searchType));
        int textType = TextType.getTextType();
        properties.put("text_type", String.valueOf(textType));
        if (this.gsFolderPathString != null) {
            properties.put("gsFolderPath", this.gsFolderPathString);
        }
        if (this.imageFolderPathString != null) {
            properties.put("imageFolderPath", this.imageFolderPathString);
        }
        if (this.dscFolderPathString != null) {
            properties.put("dscFolderPath", this.dscFolderPathString);
        }
        if (this.defaultGsFilePathString != null) {
            properties.put("defaultGsFilePath", this.defaultGsFilePathString);
        }
        if (this.RWBackgroundFilePathString != null) {
            properties.put("RWBackgroundFilePath", this.RWBackgroundFilePathString);
        }
        properties.put("file_mode", String.valueOf(this.filemode));
        if (this.webdavServerPathString != null) {
            properties.put("WebDavServerPath", this.webdavServerPathString);
        }
        if (this.webdavUserName != null) {
            properties.put("WebDavUserName", this.webdavUserName);
        }
        if (this.webdavPassword != null) {
            properties.put("WebDavPassword", this.webdavPassword);
        }
        if (this.browser != null) {
            properties.put("browser", this.browser);
        }
        if (this.editor != null) {
            properties.put("editor", this.editor);
        }
        if (this.webdavunlock != null) {
            properties.put("WebDavUnlock", this.webdavunlock);
        }
        if (this.searchImageDictionaryLogic != null) {
            properties.put("SearchLogic", this.searchImageDictionaryLogic);
        }
        if (this.proxyAddress != null) {
            properties.put("ProxyAddress", this.proxyAddress);
        }
        if (this.proxyPort != null) {
            properties.put("ProxyPort", this.proxyPort);
        }
        if (this.firstIDATName != null) {
            properties.put("firstIDATName", this.firstIDATName);
        }
        if (this.secondIDATName != null) {
            properties.put("secondIDATName", this.secondIDATName);
        }
        if (this.thirdIDATName != null) {
            properties.put("thirdIDATName", this.thirdIDATName);
        }
        if (this.markupMovability != null) {
            properties.put("markupMovability", this.markupMovability);
        }
        if (this.memoPadColor != null) {
            properties.put("memoPadColor", this.memoPadColor);
        }
        if (this.markerColor != null) {
            properties.put("markerColor", this.markerColor);
        }
        if (this.markerBreadth != null) {
            properties.put("markerBreadth", this.markerBreadth);
        }
        if (this.bookmarkSize != null) {
            properties.put("bookmarkSize", this.bookmarkSize);
        }
        if (this.resourceBasketSaveOption != null) {
            properties.put("resourceBasketSaveOption", this.resourceBasketSaveOption);
        }
        try {
            FileOutputStream outStream = new FileOutputStream(new File(preferenceFile));
            properties.storeToXML(outStream, "no comment");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getGsFolderPathString() {
        return this.gsFolderPathString;
    }

    public void setGsFolderPathString(String gsFolderPathString) {
        this.gsFolderPathString = gsFolderPathString;
    }

    public String getSmart_exportFolderPathString() {
        return this.smart_exportFolderPathString;
    }

    public void setSmart_exportFolderPathString(String smart_exportFolderPathString) {
        this.smart_exportFolderPathString = smart_exportFolderPathString;
    }

    public String getImageFolderPathString() {
        return this.imageFolderPathString;
    }

    public String getImageFolderPathStringInRaw() {
        return this.imageFolderPathString;
    }

    public void setImageFolderPathString(String imageFolderPathString) {
        if (imageFolderPathString != null) {
            this.imageFolderPathString = imageFolderPathString;
        }
    }

    public void setDscFolderPathString(String dscFolderPathString) {
        if (dscFolderPathString != null) {
            this.dscFolderPathString = dscFolderPathString;
        }
    }

    public String getDscFolderPathString() {
        return this.dscFolderPathString;
    }

    public String getLineFolderPathString() {
        return this.imageFolderPathString;
    }

    public void setNameCorrespondencePathString(String nameCorrespondencePathString) {
        this.nameCorrespondenceFilePathString = nameCorrespondencePathString;
    }

    public String getNameCorrespondencePath() {
        return this.nameCorrespondenceFilePathString;
    }

    public String getDefaultGsFilePathString() {
        return this.defaultGsFilePathString;
    }

    public void setDefaultGsFilePath(String defaultGsFolePathString) {
        this.defaultGsFilePathString = defaultGsFolePathString;
    }

    public String getRWBackgroundFilePathString() {
        return this.RWBackgroundFilePathString;
    }

    public void setRWBackgroundFilePathString(String backgroundFilePathString) {
        this.RWBackgroundFilePathString = backgroundFilePathString;
    }

    public int getFilemode() {
        return this.filemode;
    }

    public void setFilemode(int filemode) {
        this.filemode = filemode;
    }

    public String getWebdavPassword() {
        return this.webdavPassword;
    }

    public void setWebdavPassword(String webdavPassword) {
        this.webdavPassword = webdavPassword;
    }

    public String getWebdavServerPathString() {
        return this.webdavServerPathString;
    }

    public void setWebdavServerPathString(String webdavServerPathString) {
        this.webdavServerPathString = webdavServerPathString;
    }

    public String getWebdavUserName() {
        return this.webdavUserName;
    }

    public void setWebdavUserName(String webdavUserName) {
        this.webdavUserName = webdavUserName;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public static String getPreferenceFile() {
        return preferenceFile;
    }

    public static void setPreferenceFile(String preferenceFile) {
        Preference.preferenceFile = preferenceFile;
    }

    public String getWebdavunlock() {
        return this.webdavunlock;
    }

    public String getSearchImageDictionaryLogic() {
        return this.searchImageDictionaryLogic;
    }

    public void setSearchImageDictionaryLogic(String searchImageDictionaryLogic) {
        this.searchImageDictionaryLogic = searchImageDictionaryLogic;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setMarkupMovability(String movability) {
        this.markupMovability = movability;
    }

    public String getMarkupMovability() {
        return this.markupMovability;
    }

    public void setMemoPadColor(String memoPadColor) {
        this.memoPadColor = memoPadColor;
    }

    public String getMemoPadColor() {
        return this.memoPadColor;
    }

    public void setMarkerBreadth(String markerBreadth) {
        this.markerBreadth = markerBreadth;
    }

    public String getMarkerBreadth() {
        return this.markerBreadth;
    }

    public void setMarkerColor(String markerColor) {
        this.markerColor = markerColor;
    }

    public String getMarkerColor() {
        return this.markerColor;
    }

    public void setBookmarkSize(String bookmarkSize) {
        this.bookmarkSize = bookmarkSize;
    }

    public String getBookmarkSize() {
        return this.bookmarkSize;
    }

    public void setResourceBasketSaveOption(String resourceBasketSaveOption) {
        this.resourceBasketSaveOption = resourceBasketSaveOption;
    }

    public String getResourceBasketSaveOption() {
        return this.resourceBasketSaveOption;
    }
}

