/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;
import smart_gs.image_search.normal.swingui.AbstractSearchResultPanel;
import smart_gs.image_search.normal.swingui.LabelMouseListener;
import smart_gs.image_search.normal.swingui.ResultPopupWindow;
import smart_gs.image_search.normal.swingui.SearchResultViewer;
import smart_gs.logical.Spread;
import smart_gs.util.ImageCropper;

public class SearchResultPanelSegmentMode
extends AbstractSearchResultPanel {
    private int row = 5;
    private int column = 6;
    private int width;
    private int height;
    private int widthCorrectionHmode = 50;
    private int heightCorrectionHmode = 0;
    private int widthCorrectionVmode = 0;
    private int heightCorrectionVmode = 50;
    private double magnification = 0.7;

    public SearchResultPanelSegmentMode(SearchResultViewer parent, List<SearchResult> results, Image queryImage) {
        super(parent, results, queryImage);
        this.SIZE_TO_DISPLAY = this.row * this.column;
        this.setLayout(new FlowLayout());
        this.nextCount = this.count + 1;
        this.createNextResults(this.count);
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    @Override
    protected JLabel createImageLabel(SearchResult result, Image queryImage) {
        Spread spread = result.getSpread();
        Rectangle rect = result.getRectangle();
        int width = queryImage.getWidth(null);
        int height = queryImage.getHeight(null);
        if (TextType.isHorizontal()) {
            this.width = width + this.widthCorrectionHmode;
            this.height = height + this.heightCorrectionHmode;
        } else {
            this.width = width + this.widthCorrectionVmode;
            this.height = height + this.heightCorrectionVmode;
        }
        width = (int)((double)width * this.magnification);
        height = (int)((double)height * this.magnification);
        Image image = new ImageCropper(spread, (Rectangle2D)rect).crop(width, height);
        JLabel label = new JLabel(new ImageIcon(image));
        ResultPopupWindow window = new ResultPopupWindow(result);
        label.addMouseListener(new LabelMouseListener(label, window, spread, rect));
        return label;
    }
}

