/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.normal.swingui.CheckAction;
import smart_gs.image_search.normal.swingui.RemoveAction;
import smart_gs.image_search.normal.swingui.SearchResultPanelSegmentMode;
import smart_gs.image_search.normal.swingui.SearchResultViewer;
import smart_gs.logical.Spread;

public abstract class AbstractSearchResultPanel
extends JPanel {
    protected List<SearchResult> results;
    protected List<JPanel> previousResults;
    protected List<JPanel> nextResults;
    protected List<JPanel> currentResults;
    protected int SIZE_TO_DISPLAY = 20;
    protected int count = 0;
    protected int nextCount;
    protected boolean isFirst = true;
    protected Thread nextThread = null;
    protected SearchResultViewer parent;
    protected Image queryImage;

    public AbstractSearchResultPanel(SearchResultViewer parent, List<SearchResult> results, Image queryImage) {
        this.parent = parent;
        this.results = results;
        this.previousResults = new ArrayList<JPanel>();
        this.nextResults = new ArrayList<JPanel>();
        this.currentResults = new ArrayList<JPanel>();
        this.queryImage = queryImage;
    }

    public void showResult(List<JPanel> list) {
        this.removeAll();
        if (this.nextThread.isAlive()) {
            try {
                this.nextThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < list.size()) {
            this.add(list.get(i));
            ++i;
        }
        this.currentResults.clear();
        this.currentResults.addAll(this.nextResults);
    }

    public void next() {
        ++this.count;
        this.nextCount = this.count + 1;
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    public void back() {
        --this.count;
        this.nextCount = this.count + 1;
        if (this.nextThread.isAlive()) {
            this.nextThread.interrupt();
        }
        this.createNextResults(this.count);
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    public synchronized void createNextResults(final int count) {
        this.nextThread = new Thread(){

            @Override
            public void run() {
                super.run();
                int beginIndex = count * AbstractSearchResultPanel.this.SIZE_TO_DISPLAY;
                AbstractSearchResultPanel.this.nextResults.clear();
                int i = beginIndex;
                while (i < beginIndex + AbstractSearchResultPanel.this.SIZE_TO_DISPLAY && i < AbstractSearchResultPanel.this.results.size()) {
                    JPanel labelPanel = new JPanel();
                    JPanel checkBoxPanel = new JPanel(new GridLayout(2, 1));
                    ButtonGroup g = new ButtonGroup();
                    JCheckBox checkBox = new JCheckBox("Yes");
                    JCheckBox removeBox = new JCheckBox("No");
                    g.add(checkBox);
                    g.add(removeBox);
                    JLabel newLabel = new JLabel("");
                    if (AbstractSearchResultPanel.this.results.get(i).isInBucket()) {
                        newLabel.setIcon(new ImageIcon("./icons/copy.gif"));
                    } else if (!AbstractSearchResultPanel.this.results.get(i).wasShown()) {
                        newLabel.setIcon(new ImageIcon("./icons/new.gif"));
                    }
                    checkBox.addItemListener(new CheckAction(AbstractSearchResultPanel.this.parent, AbstractSearchResultPanel.this.results.get(i)));
                    removeBox.addItemListener(new RemoveAction(AbstractSearchResultPanel.this.parent, AbstractSearchResultPanel.this.results.get(i)));
                    checkBoxPanel.add(newLabel);
                    checkBoxPanel.add(checkBox);
                    checkBoxPanel.add(removeBox);
                    labelPanel.setLayout(new FlowLayout(0));
                    labelPanel.add(checkBoxPanel);
                    JLabel label = AbstractSearchResultPanel.this.createImageLabel(AbstractSearchResultPanel.this.results.get(i), AbstractSearchResultPanel.this.queryImage);
                    Spread spread = AbstractSearchResultPanel.this.results.get(i).getSpread();
                    if (AbstractSearchResultPanel.this instanceof SearchResultPanelSegmentMode) {
                        labelPanel.setBorder(new LineBorder(Color.BLACK));
                    } else {
                        labelPanel.setBorder(new TitledBorder(spread.getURI()));
                    }
                    labelPanel.add(label);
                    AbstractSearchResultPanel.this.nextResults.add(labelPanel);
                    spread.release();
                    ++i;
                }
            }
        };
        this.nextThread.start();
    }

    protected abstract JLabel createImageLabel(SearchResult var1, Image var2);

    public void updateBucket() {
        int beginIndex = this.count * this.SIZE_TO_DISPLAY;
        int i = 0;
        while (i < this.SIZE_TO_DISPLAY - 1) {
            JPanel panel = this.currentResults.get(i);
            JLabel label = (JLabel)((JPanel)panel.getComponent(0)).getComponent(0);
            if (this.results.get(beginIndex + i).isInBucket()) {
                label.setIcon(new ImageIcon("./icons/copy.gif"));
            }
            ++i;
        }
        this.parent.validate();
        this.repaint();
        this.validate();
    }
}

