/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import smart_gs.image_search.SearchAction;
import smart_gs.image_search.SearchQueryAction;
import smart_gs.image_search.SortCompellator;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Spread;

public class MultiSearchAction
extends SearchAction {
    private List<SearchAction> searchActions;
    private int beginCount = 0;

    public MultiSearchAction(QueryBucket bucket, List<Spread> spreadsToSearch) {
        super(spreadsToSearch);
        this.searchActions = new ArrayList<SearchAction>();
        int i = 0;
        while (i < bucket.size()) {
            this.searchActions.add(new SearchQueryAction(bucket.get(i), spreadsToSearch));
            ++i;
        }
    }

    public MultiSearchAction(List<Spread> spreadsToSearch) {
        super(spreadsToSearch);
        this.searchActions = new ArrayList<SearchAction>();
    }

    public MultiSearchAction(List<SearchAction> actions, List<Spread> spreadsToSearch) {
        super(spreadsToSearch);
        this.searchActions = actions;
    }

    public void setPreviousResults(List<SearchResult> results, int size) {
        this.results.addAll(results);
        this.beginCount = size;
    }

    public void add(GSQuery query) {
        SearchQueryAction action = new SearchQueryAction(query, this.spreadsToSearch);
        this.searchActions.add(action);
    }

    @Override
    public void execute() {
        int i = this.beginCount;
        while (i < this.searchActions.size()) {
            this.searchActions.get(i).execute();
            this.results.addAll(this.searchActions.get(i).getResults());
            ++i;
        }
        this.sorting();
    }

    private void sorting() {
        SearchResult[] arrays = this.results.toArray(new SearchResult[0]);
        Arrays.sort(arrays, new SortCompellator());
        this.results = Arrays.asList(arrays);
    }

    public static List<SearchResult> sorting(List<SearchResult> results) {
        SearchResult[] arrays = results.toArray(new SearchResult[0]);
        Arrays.sort(arrays, new SortCompellator());
        return Arrays.asList(arrays);
    }

    @Override
    public List<SearchResult> getResults() {
        return this.results;
    }
}

