/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.drawing_tool.view.View;

public class PolygonView
extends View {
    private List<LineView> lines = new ArrayList<LineView>();

    public PolygonView() {
        this.defaultColor = Color.BLUE;
        this.selectionColor = Color.red;
    }

    public PolygonView(List<ExLine2D> exLines) {
        int i = 0;
        while (i < exLines.size()) {
            this.lines.add(new LineView(exLines.get(i)));
            ++i;
        }
        this.lines.add(new LineView(new ExLine2D(exLines.get(exLines.size() - 1).getP2(), exLines.get(0).getP1())));
        this.defaultColor = Color.BLUE;
        this.selectionColor = Color.red;
    }

    public PolygonView(List<ExLine2D> lines, boolean isSelected, boolean isEmphasized, boolean isProtected) {
        this(lines);
        this.isSelected = isSelected;
        this.isEmphasized = isEmphasized;
        this.isProtected = isProtected;
    }

    @Override
    public boolean contains(Point2D point) {
        int[] xpoints = new int[this.lines.size()];
        int[] ypoints = new int[this.lines.size()];
        int i = 0;
        while (i < this.lines.size()) {
            xpoints[i] = (int)this.lines.get(i).getLine().getP1().getX();
            ypoints[i] = (int)this.lines.get(i).getLine().getP1().getY();
            ++i;
        }
        Polygon polygon = new Polygon(xpoints, ypoints, this.lines.size());
        return polygon.contains(point);
    }

    public void addLineView(LineView line) {
        this.lines.add(line);
    }

    @Override
    public void drawShape(Graphics2D g) {
        int i = 0;
        while (i < this.lines.size()) {
            this.lines.get(i).drawShape(g);
            ++i;
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void moveBy(Point2D d) {
        int i = 0;
        while (i < this.lines.size()) {
            this.lines.get(i).moveBy(d);
            ++i;
        }
    }

    @Override
    public View enlargedView(double ratio, double gapX, double gapY) {
        ArrayList<ExLine2D> newLines = new ArrayList<ExLine2D>();
        int i = 0;
        while (i < this.lines.size()) {
            LineView line = this.lines.get(i);
            line = (LineView)line.enlargedView(ratio, gapX, gapY);
            newLines.add(line.getLine());
            ++i;
        }
        return new PolygonView(newLines, this.isSelected, this.isEmphasized, this.isProtected);
    }

    @Override
    public Rectangle2D getRectangle2D() {
        LineView line1 = this.lines.get(0);
        double minX = line1.getMinX();
        double minY = line1.getMinY();
        double maxX = line1.getMaxX();
        double maxY = line1.getMaxY();
        int i = 0;
        while (i < this.lines.size()) {
            LineView line = this.lines.get(i);
            if (minX > line.getMinX() || minX == -1.0) {
                minX = line.getMinX();
            }
            if (minY > line.getMinY() || minX == -1.0) {
                minY = line.getMinY();
            }
            if (maxX < line.getMaxX() || minX == -1.0) {
                maxX = line.getMaxX();
            }
            if (maxY < line.getMaxY() || minX == -1.0) {
                maxY = line.getMaxY();
            }
            ++i;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public String getTypeString() {
        return "polygon";
    }

    @Override
    public void drawLinkedShape(Graphics2D g) {
        if (this.isSelected) {
            this.draw(g);
            return;
        }
        int i = 0;
        while (i < this.lines.size()) {
            this.lines.get(i).drawLinkedShape(g);
            ++i;
        }
    }

    @Override
    public Element createXMLElement(Document document) {
        Element element = document.createElement("view");
        element.setAttribute("type", "polygon");
        int i = 0;
        while (i < this.lines.size()) {
            element.appendChild(this.lines.get(i).createXMLElement(document));
            ++i;
        }
        return element;
    }

    public static PolygonView restore(Element element) {
        PolygonView view = new PolygonView();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element elem;
            String tagname;
            if (nodes.item(i).getNodeType() == 1 && (tagname = (elem = (Element)nodes.item(i)).getNodeName()).equals("view")) {
                LineView line = LineView.restore(elem);
                view.addLineView(line);
            }
            ++i;
        }
        return view;
    }

    @Override
    public Point getCenterPoint() {
        return new Point((int)this.getRectangle2D().getCenterX(), (int)this.getRectangle2D().getCenterY());
    }

    @Override
    public String getTypeStringForDisplay() {
        return "Polygon";
    }
}

