/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.view;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.drawing_tool.view.View;

public class LineSegmentsView
extends View {
    Color LineSegmentDefaultColor = new Color(0, 0, 80, 80);
    private List<LineView> lines = new ArrayList<LineView>();
    private int index;
    private IndexView indexView;

    public LineSegmentsView(int index) {
        this.defaultColor = this.LineSegmentDefaultColor;
        this.selectionColor = Color.red;
        this.index = index;
    }

    public LineSegmentsView(List<ExLine2D> exLines, int index) {
        int i = 0;
        while (i < exLines.size()) {
            this.lines.add(new LineView(exLines.get(i)));
            ++i;
        }
        this.lines.add(new LineView(new ExLine2D(exLines.get(exLines.size() - 1).getP2(), exLines.get(0).getP1())));
        this.defaultColor = this.LineSegmentDefaultColor;
        this.selectionColor = Color.red;
        this.index = index;
        if (this.lines.size() != 0) {
            this.createIndexView(index);
        }
    }

    public LineSegmentsView(List<ExLine2D> lines, boolean isSelected, boolean isEmphasized, boolean isProtected, int index) {
        this(lines, index);
        this.isSelected = isSelected;
        this.isEmphasized = isEmphasized;
        this.isProtected = isProtected;
    }

    public LineSegmentsView(List<ExLine2D> exLines) {
        int i = 0;
        while (i < exLines.size()) {
            this.lines.add(new LineView(exLines.get(i)));
            ++i;
        }
        this.lines.add(new LineView(new ExLine2D(exLines.get(exLines.size() - 1).getP2(), exLines.get(0).getP1())));
        this.defaultColor = this.LineSegmentDefaultColor;
        this.selectionColor = Color.red;
    }

    @Override
    public boolean contains(Point2D point) {
        int[] xpoints = new int[this.lines.size()];
        int[] ypoints = new int[this.lines.size()];
        int i = 0;
        while (i < this.lines.size()) {
            xpoints[i] = (int)this.lines.get(i).getLine().getP1().getX();
            ypoints[i] = (int)this.lines.get(i).getLine().getP1().getY();
            ++i;
        }
        Polygon polygon = new Polygon(xpoints, ypoints, this.lines.size());
        return polygon.contains(point);
    }

    public void addLineView(LineView line) {
        this.lines.add(line);
    }

    @Override
    public void drawShape(Graphics2D g) {
        int i = 0;
        while (i < this.lines.size()) {
            this.lines.get(i).drawShape(g);
            ++i;
        }
    }

    public void drawShape(Graphics2D g, ImageLabel.Show mode) {
        if (mode == ImageLabel.Show.LINE_AND_INDEX) {
            this.drawShape(g);
            this.indexView.drawShape(g);
        } else if (mode == ImageLabel.Show.LINE) {
            this.drawShape(g);
        } else if (mode == ImageLabel.Show.INDEX) {
            this.indexView.drawShape(g);
        }
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getTypeString() {
        return "linesegment";
    }

    @Override
    public void moveBy(Point2D d) {
        int i = 0;
        while (i < this.lines.size()) {
            this.lines.get(i).moveBy(d);
            ++i;
        }
    }

    @Override
    public View enlargedView(double ratio, double gapX, double gapY) {
        ArrayList<ExLine2D> newLines = new ArrayList<ExLine2D>();
        int i = 0;
        while (i < this.lines.size()) {
            LineView line = this.lines.get(i);
            line = (LineView)line.enlargedView(ratio, gapX, gapY);
            newLines.add(line.getLine());
            ++i;
        }
        return new LineSegmentsView(newLines, this.isSelected, this.isEmphasized, this.isProtected, this.index);
    }

    @Override
    public Rectangle2D getRectangle2D() {
        LineView line1 = this.lines.get(0);
        double minX = line1.getMinX();
        double minY = line1.getMinY();
        double maxX = line1.getMaxX();
        double maxY = line1.getMaxY();
        int i = 0;
        while (i < this.lines.size()) {
            LineView line = this.lines.get(i);
            if (minX > line.getMinX() || minX == -1.0) {
                minX = line.getMinX();
            }
            if (minY > line.getMinY() || minX == -1.0) {
                minY = line.getMinY();
            }
            if (maxX < line.getMaxX() || minX == -1.0) {
                maxX = line.getMaxX();
            }
            if (maxY < line.getMaxY() || minX == -1.0) {
                maxY = line.getMaxY();
            }
            ++i;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public void drawLinkedShape(Graphics2D g) {
        if (this.isSelected) {
            this.draw(g);
            return;
        }
        int i = 0;
        while (i < this.lines.size()) {
            this.lines.get(i).drawLinkedShape(g);
            ++i;
        }
    }

    @Override
    public Element createXMLElement(Document document) {
        Element element = document.createElement("view");
        element.setAttribute("type", "linesegment");
        int i = 0;
        while (i < this.lines.size()) {
            element.appendChild(this.lines.get(i).createXMLElement(document));
            ++i;
        }
        return element;
    }

    public static LineSegmentsView restore(Element element, int index) {
        LineSegmentsView view = new LineSegmentsView(index);
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element elem;
            String tagname;
            if (nodes.item(i).getNodeType() == 1 && (tagname = (elem = (Element)nodes.item(i)).getNodeName()).equals("view")) {
                LineView line = LineView.restore(elem);
                view.addLineView(line);
            }
            ++i;
        }
        return view;
    }

    @Override
    public Point getCenterPoint() {
        return new Point((int)this.getRectangle2D().getCenterX(), (int)this.getRectangle2D().getCenterY());
    }

    @Override
    public String getTypeStringForDisplay() {
        return "LineSegment";
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    private void createIndexView(int index) {
        this.indexView = new IndexView(index, this.getMinX(), this.getMinY());
    }

    private int getMinY() {
        int minY = (int)this.lines.get(0).getMinY();
        int i = 0;
        while (i < this.lines.size()) {
            if (minY > (int)this.lines.get(i).getMinY()) {
                minY = (int)this.lines.get(i).getMinY();
            }
            ++i;
        }
        return minY;
    }

    private int getMinX() {
        int minX = (int)this.lines.get(0).getMinX();
        int i = 0;
        while (i < this.lines.size()) {
            if (minX > (int)this.lines.get(i).getMinX()) {
                minX = (int)this.lines.get(i).getMinX();
            }
            ++i;
        }
        return minX;
    }

    private class IndexView {
        private int index;
        private int x;
        private int y;

        public IndexView(int index, int x, int y) {
            this.index = index;
            this.x = x;
            this.y = y;
        }

        protected void drawShape(Graphics2D g) {
            FontMetrics fm = g.getFontMetrics();
            int h = fm.getHeight();
            int ast = fm.getAscent();
            int w = fm.stringWidth(String.valueOf(this.index));
            int xx = this.x - w / 2;
            int yy = this.y - h / 2;
            Rectangle2D.Double rectangle = new Rectangle2D.Double(xx, yy, w + 10, h);
            g.setColor(new Color(204, 255, 255));
            g.fill(rectangle);
            g.setColor(Color.BLACK);
            g.draw(rectangle);
            g.drawString(String.valueOf(this.index), xx + 5, yy + ast);
        }
    }
}

