/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.state;

import java.util.ArrayList;
import java.util.List;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.RegionNotify;
import smart_gs.logical.Region;
import smart_gs.swingui.GSMouseEvent;

public class RegionSelectionState
extends DefaultState {
    private static DefaultState singleton = new RegionSelectionState();
    private List<RegionNotify> elements = new ArrayList<RegionNotify>();

    public static DefaultState getInstance() {
        return singleton;
    }

    public void addNotifyElement(RegionNotify element) {
        this.elements.add(element);
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        List<Region> regions = canvas.getSpread().getRegions();
        int i = 0;
        while (i < regions.size()) {
            if (regions.get(i).contains(e.getPoint2D())) {
                this.notifySelectedRegion(regions.get(i));
                return;
            }
            ++i;
        }
        super.mousePressed(e, canvas);
    }

    @Override
    public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
        super.mouseClicked(e, canvas);
    }

    private void notifySelectedRegion(Region region) {
        int i = 0;
        while (i < this.elements.size()) {
            this.elements.get(i).notifyRegionSelection(region);
            ++i;
        }
    }
}

