/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DrawingModeAdapter;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.logical.region.PolygonRegion;
import smart_gs.swingui.GSMouseEvent;

public class PolygonMode
extends DrawingModeAdapter {
    private static Mode singleton = new PolygonMode();
    private Point2D start;
    private Point2D end;
    private List<Point2D> points;
    private Point2D tempStart;
    private Point2D tempEnd;
    private List<Point2D> tempPoints;
    private List<ExLine2D> lines = new ArrayList<ExLine2D>();

    private PolygonMode() {
        this.points = new ArrayList<Point2D>();
        this.tempPoints = new ArrayList<Point2D>();
    }

    public static Mode getInstance() {
        return singleton;
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        super.mousePressed(e, canvas);
        if (e.getButton() != 1) {
            this.cancel();
            return;
        }
        if (this.start == null) {
            this.start = e.getPoint();
            this.tempStart = e.getOriginalPoint();
            this.points.add(this.start);
            this.tempPoints.add(this.tempStart);
            return;
        }
        this.end = e.getPoint();
        this.tempEnd = e.getOriginalPoint();
        this.lines.add(new ExLine2D(this.start, this.end));
        this.points.add(this.end);
        this.tempPoints.add(this.tempEnd);
        this.start = this.end;
        this.tempStart = this.tempEnd;
    }

    @Override
    public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
        if (e.getButton() != 1) {
            this.cancel();
            return;
        }
        super.mouseClicked(e, canvas);
        if (e.getClickCount() == 2) {
            canvas.getSpread().addRegion(new PolygonRegion(canvas.getSpread(), this.points));
            this.lines = new ArrayList<ExLine2D>();
            this.points = new ArrayList<Point2D>();
            this.tempPoints = new ArrayList<Point2D>();
            this.start = null;
            this.end = null;
            this.tempStart = null;
            this.tempEnd = null;
            DefaultState.getInstance().setMode(PolygonMode.getInstance());
            return;
        }
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        super.mouseMoved(e, canvas);
        this.end = e.getPoint();
        this.tempEnd = e.getOriginalPoint();
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
        super.paint(g, canvas);
        if (this.start == null || this.end == null) {
            return;
        }
        double ratio = canvas.getImageLabel().getRatio();
        double gapX = canvas.getImageLabel().getGapWidth();
        double gapY = canvas.getImageLabel().getGapHeight();
        int i = 0;
        while (i < this.lines.size()) {
            ExLine2D line = this.lines.get(i);
            new LineView(line).enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
            ++i;
        }
        new LineView(new ExLine2D(this.start, this.end)).enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
    }

    @Override
    public void cancel() {
        this.lines = new ArrayList<ExLine2D>();
        this.points = new ArrayList<Point2D>();
        this.tempPoints = new ArrayList<Point2D>();
        this.start = null;
        this.end = null;
        this.tempStart = null;
        this.tempEnd = null;
    }
}

