/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.geom.Rectangle2D;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.DrawingModeAdapter;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.AnchorView;
import smart_gs.logical.AnchorTextSegment;
import smart_gs.logical.URIObject;
import smart_gs.logical.region.AnchorRegion;
import smart_gs.swingui.GSMouseEvent;

public class AnchorMode
extends DrawingModeAdapter {
    private static Mode singleton = new AnchorMode();
    private static AnchorTextSegment anchorTextSegment;

    public static Mode getInstance() {
        return singleton;
    }

    public static void setAnchorTextSegment(AnchorTextSegment anchorTextSegment) {
        AnchorMode.anchorTextSegment = anchorTextSegment;
    }

    @Override
    public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
        int x = (int)e.getPoint().getX();
        int y = (int)e.getPoint().getY();
        int w = (int)AnchorView.WIDTH;
        int h = (int)AnchorView.HEIGHT;
        Rectangle2D.Double rectangle = new Rectangle2D.Double(x, y, w, h);
        AnchorRegion region = new AnchorRegion(canvas.getSpread(), rectangle);
        canvas.addRegion(region);
        anchorTextSegment.setAnchorRegion(region);
        anchorTextSegment.extendURIBy("@" + URIObject.chopHeader(region.getURI()));
        region.setAnchorTextSegment(anchorTextSegment);
        DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
    }
}

