/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.dictionary;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import smart_gs.dictionary.Dictionary;
import smart_gs.dictionary.DictionaryRegion;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.GSStandardPath;

public class DictionaryXML {
    protected static DictionaryXML singleton;
    protected TreeMap<String, Dictionary> dictionaryMap = new TreeMap();
    protected List<Spread> loadSpreads = new ArrayList<Spread>();
    private String dictionaryString;
    protected static boolean warning;

    static {
        warning = false;
    }

    protected DictionaryXML() {
    }

    public static DictionaryXML getInstance() {
        if (singleton == null) {
            singleton = new DictionaryXML();
        }
        return singleton;
    }

    public void setWarning(boolean flg) {
        warning = flg;
    }

    public void load() {
        this.load(WorkspaceWindow.getInstance().getCurrentFile());
    }

    public void load(File file) {
        this.loadSpreads.clear();
        this.dictionaryMap.clear();
        HashMap<String, Spread> spreadMap = new HashMap<String, Spread>();
        List<Spread> spreadlist = SpreadTree.getInstance().getSpreads();
        int i = 0;
        while (i < spreadlist.size()) {
            Spread spread = spreadlist.get(i);
            spreadMap.put(spread.getURI(), spread);
            ++i;
        }
        try {
            if (file == null) {
                return;
            }
            ZipFile gsxFile = new ZipFile(file);
            ZipEntry gsxDictionary = gsxFile.getEntry("dictionary/default.xml");
            if (gsxDictionary == null || gsxDictionary.getSize() <= 0L) {
                return;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(gsxFile.getInputStream(gsxDictionary));
            Element rootElement = document.getDocumentElement();
            NodeList list = rootElement.getElementsByTagName("index");
            int i2 = 0;
            while (i2 < list.getLength()) {
                Element element = (Element)list.item(i2);
                String word = element.getAttribute("word");
                NodeList spreadList = element.getElementsByTagName("spread");
                Dictionary dictionary = new Dictionary();
                dictionary.setWord(word);
                int j = 0;
                while (j < spreadList.getLength()) {
                    Element spreadElement = (Element)spreadList.item(j);
                    String uri = spreadElement.getAttribute("uri");
                    Spread spread = (Spread)spreadMap.get(uri);
                    if (spread != null) {
                        if (!this.loadSpreads.contains(spread)) {
                            this.loadSpreads.add(spread);
                        }
                        NodeList regionList = spreadElement.getElementsByTagName("region");
                        Element regionElement = (Element)regionList.item(0);
                        Region region = XML2ResourceConverter.getRegion(spread, regionElement);
                        DictionaryRegion dictionaryRegion = new DictionaryRegion();
                        dictionaryRegion.setImageFile("C:/a");
                        dictionaryRegion.setRegion(region);
                        dictionary.addDictionaryRegionList(dictionaryRegion);
                    } else if (!warning) {
                        JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(), "A part of image is not able to be displayed because the image file did not exist", "Waring", 2);
                        warning = true;
                    }
                    ++j;
                }
                this.dictionaryMap.put(word, dictionary);
                ++i2;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Spread> getLoadSpreads() {
        return this.loadSpreads;
    }

    public TreeMap<String, Dictionary> getDictionaryMap() {
        return this.dictionaryMap;
    }

    public TreeMap<String, Dictionary> getDictionaryMap(String filter) {
        TreeMap<String, Dictionary> resultMap = new TreeMap<String, Dictionary>();
        for (String word : this.dictionaryMap.keySet()) {
            if (!word.startsWith(filter)) continue;
            resultMap.put(word, this.dictionaryMap.get(word));
        }
        return resultMap;
    }

    public TreeMap<String, Dictionary> getDictionaryMapByregularExpressions(String filter) {
        TreeMap<String, Dictionary> resultMap = new TreeMap<String, Dictionary>();
        Iterator<String> itr = this.dictionaryMap.keySet().iterator();
        Pattern p = Pattern.compile(filter);
        while (itr.hasNext()) {
            String word = itr.next();
            Matcher m = p.matcher(word);
            while (m.find()) {
                resultMap.put(word, this.dictionaryMap.get(word));
            }
        }
        return resultMap;
    }

    public ArrayList<String> getWordList(String matchstr) {
        if (this.dictionaryMap.size() == 0) {
            return null;
        }
        ArrayList<String> wordList = new ArrayList<String>();
        for (String word : this.dictionaryMap.keySet()) {
            if (!word.startsWith(matchstr)) continue;
            wordList.add(word);
        }
        return wordList;
    }

    public void add(String word, Region region) {
        WorkspaceWindow.setUpdated(true);
        if (this.dictionaryMap.containsKey(word)) {
            Dictionary dictionary = this.dictionaryMap.get(word);
            DictionaryRegion dictionaryRegion = new DictionaryRegion();
            dictionaryRegion.setImageFile("C:/a");
            dictionaryRegion.setRegion(region);
            dictionary.addDictionaryRegionList(dictionaryRegion);
        } else {
            Dictionary dictionary = new Dictionary();
            dictionary.setWord(word);
            DictionaryRegion dictionaryRegion = new DictionaryRegion();
            dictionaryRegion.setImageFile("C:/a");
            dictionaryRegion.setRegion(region);
            dictionary.addDictionaryRegionList(dictionaryRegion);
            this.dictionaryMap.put(word, dictionary);
        }
    }

    public void add(String word, Dictionary newDictionary) {
        WorkspaceWindow.setUpdated(true);
        if (this.dictionaryMap.containsKey(word)) {
            Dictionary dictionary = this.dictionaryMap.get(word);
            ArrayList<DictionaryRegion> list = newDictionary.getDictionaryRegionList();
            int i = 0;
            while (i < list.size()) {
                dictionary.addDictionaryRegionList(list.get(i));
                ++i;
            }
        } else {
            this.dictionaryMap.put(word, newDictionary);
        }
    }

    public void deleteRegion(String word, int index) {
        if (this.dictionaryMap.containsKey(word)) {
            Dictionary dictionary = this.dictionaryMap.get(word);
            dictionary.deleteDictionaryRegionList(index);
            ArrayList<DictionaryRegion> list = dictionary.getDictionaryRegionList();
            if (list.size() == 0) {
                this.dictionaryMap.remove(word);
            }
        }
    }

    public void delete(String word) {
        if (this.dictionaryMap.containsKey(word)) {
            this.dictionaryMap.remove(word);
        }
    }

    public Dictionary getDictionary(String word) {
        if (this.dictionaryMap.containsKey(word)) {
            return this.dictionaryMap.get(word);
        }
        return null;
    }

    public synchronized void write() throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element rootElement = document.createElement("dictionary");
        document.appendChild(rootElement);
        for (String word : this.dictionaryMap.keySet()) {
            Element indexElement = document.createElement("index");
            indexElement.setAttribute("word", word);
            Dictionary dictionary = this.dictionaryMap.get(word);
            ArrayList<DictionaryRegion> dictionaryRegionList = dictionary.getDictionaryRegionList();
            int i = 0;
            while (i < dictionaryRegionList.size()) {
                DictionaryRegion dictionaryRegion = dictionaryRegionList.get(i);
                Region region = dictionaryRegion.getRegion();
                Spread spread = region.getSpread();
                Element spreadElement = document.createElement("spread");
                spreadElement.setAttribute("name", spread.getName());
                spreadElement.setAttribute("uri", spread.getURI());
                spreadElement.setAttribute("originalURI", spread.getOriginalURI());
                String filepath = spread.getFile().getPath();
                spreadElement.setAttribute("filename", GSStandardPath.standardizeFileName(filepath));
                Element element = document.createElement("region");
                element.setAttribute("name", region.getName());
                element.setAttribute("uri", region.getURI());
                element.setAttribute("originalURI", region.getOriginalURI());
                element.setAttribute("protection", region.isProtected());
                element.appendChild(region.getView().createXMLElement(document));
                spreadElement.appendChild(element);
                indexElement.appendChild(spreadElement);
                ++i;
            }
            rootElement.appendChild(indexElement);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StringWriter output = new StringWriter();
            transformer.transform(source, new StreamResult(output));
            this.dictionaryString = output.toString();
            transformer = null;
            source = null;
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        factory = null;
    }

    public String getDictionaryString() {
        return this.dictionaryString;
    }

    public void init() {
        this.dictionaryMap.clear();
        try {
            this.write();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

