/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.dictionary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.xml.parsers.ParserConfigurationException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.dictionary.DictionaryXML;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAndDscCompileAction;

public class DictionaryRegisterDialog
extends JDialog {
    private JPanel jContentPane = null;
    protected Region region;
    private JDialog myJDialog;
    protected TextField wordTextFiled;
    protected JLabel suggestLabel;

    public DictionaryRegisterDialog(Frame owner, String title, boolean modal, Region region) {
        super(owner, title, modal);
        this.region = region;
        this.initialize();
        this.myJDialog = this;
    }

    private void initialize() {
        this.setSize(400, 250);
        this.setLocationRelativeTo(null);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            JPanel wordPanel = new JPanel();
            wordPanel.setLayout(new BorderLayout());
            JPanel wordSelectPanel = new JPanel();
            this.wordTextFiled = new TextField(20);
            this.wordTextFiled.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    DictionaryRegisterDialog.this.suggestLabel.setText("");
                    if (!DictionaryRegisterDialog.this.wordTextFiled.getText().equals("")) {
                        int i;
                        DictionaryXML dictionaryXML = DictionaryXML.getInstance();
                        ArrayList<String> list = dictionaryXML.getWordList(DictionaryRegisterDialog.this.wordTextFiled.getText());
                        if (list == null) {
                            return;
                        }
                        if (list.size() != 0 && (i = 0) < list.size()) {
                            DictionaryRegisterDialog.this.suggestLabel.setText(list.get(i));
                        }
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            JLabel wordLabel = new JLabel("Word:");
            wordSelectPanel.add(wordLabel);
            wordSelectPanel.add(this.wordTextFiled);
            JButton dic = new JButton("open dictionary");
            dic.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DictionaryDialog dictionaryDialog = new DictionaryDialog((Frame)WorkspaceWindow.getInstance(), "Dictionary", true, 1);
                    dictionaryDialog.setVisible(true);
                    if (!dictionaryDialog.isCancel()) {
                        String word = dictionaryDialog.getCchoiceWord();
                        DictionaryRegisterDialog.this.wordTextFiled.setText(word);
                        DictionaryRegisterDialog.this.suggestLabel.setText(word);
                    }
                }
            });
            wordSelectPanel.add(dic);
            wordPanel.add((Component)wordSelectPanel, "North");
            this.suggestLabel = new JLabel("");
            this.suggestLabel.setHorizontalAlignment(0);
            wordPanel.add((Component)this.suggestLabel, "South");
            this.jContentPane.add((Component)wordPanel, "North");
            try {
                this.region.setCentermode(true);
                JPanel regionPanel = this.region.createElementViewPanel();
                this.jContentPane.add((Component)regionPanel, "Center");
            }
            catch (NoWayToShowException e) {
                e.printStackTrace();
            }
            JPanel buttonPanel = new JPanel();
            final JCheckBox check = new JCheckBox("Add Line Segment");
            buttonPanel.add(check);
            JButton regist = new JButton("Register");
            regist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        String word = DictionaryRegisterDialog.this.suggestLabel.getText();
                        if (word.equals("") && (word = DictionaryRegisterDialog.this.wordTextFiled.getText()).equals("")) {
                            JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(), "Don't be not able to register dictionary because word is blank", "Warning", 2);
                            return;
                        }
                        DictionaryXML dictionaryXML = DictionaryXML.getInstance();
                        dictionaryXML.add(word, DictionaryRegisterDialog.this.region);
                        try {
                            dictionaryXML.write();
                        }
                        catch (ParserConfigurationException e) {
                            e.printStackTrace();
                        }
                        if (check.isSelected()) {
                            Spread spread = DictionaryRegisterDialog.this.region.getSpread();
                            List<Point2D> points = DictionaryRegisterDialog.this.region.getPoints();
                            LineSegment line = new LineSegment(spread, points);
                            spread.addLineSegment(line);
                            SaveLineSegmentsAndDscCompileAction action = new SaveLineSegmentsAndDscCompileAction(spread);
                            action.dscCompile();
                        }
                    }
                    finally {
                        DictionaryRegisterDialog.this.myJDialog.setVisible(false);
                    }
                }
            });
            buttonPanel.add(regist);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DictionaryRegisterDialog.this.myJDialog.setVisible(false);
                }
            });
            buttonPanel.add(cancel);
            this.jContentPane.add((Component)buttonPanel, "South");
        }
        return this.jContentPane;
    }

    private static class WidePopupMenuListener
    implements PopupMenuListener {
        private static final int POPUP_MIN_WIDTH = 300;
        private boolean adjusting = false;

        private WidePopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JComboBox combo = (JComboBox)e.getSource();
            Dimension size = combo.getSize();
            if (size.width >= 300) {
                return;
            }
            if (!this.adjusting) {
                this.adjusting = true;
                combo.setSize(300, size.height);
                combo.showPopup();
            }
            combo.setSize(size);
            this.adjusting = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

