/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;

public class ExtendedHTMLReader
extends Reader {
    protected Reader base = null;

    public ExtendedHTMLReader(Reader org, boolean removeHeader) {
        if (removeHeader) {
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[4096];
            try {
                int len;
                while ((len = org.read(buffer)) > 0) {
                    sb.append(buffer, 0, len);
                }
            }
            catch (IOException len) {
                // empty catch block
            }
            String source = sb.toString();
            source = source.replaceAll("\\<head\\>(?s).*\\</head\\>", "");
            this.base = new StringReader(source);
        } else {
            this.base = org;
        }
    }

    public ExtendedHTMLReader(Reader base) {
        this.base = base;
    }

    @Override
    public void close() throws IOException {
        this.base.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = 0;
        int i = 0;
        while (i < len) {
            int rtn = this.read();
            if (rtn == -1) {
                return count;
            }
            cbuf[off + i] = (char)rtn;
            ++count;
            ++i;
        }
        return count;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.base.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.base.markSupported();
    }

    @Override
    public int read() throws IOException {
        int rtn = 0;
        while ((rtn = this.base.read()) == 10 || rtn == 13) {
        }
        return rtn;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        throw new IOException();
    }

    @Override
    public boolean ready() throws IOException {
        return this.base.ready();
    }

    @Override
    public void reset() throws IOException {
        this.base.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.base.skip(n);
    }
}

