/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;

public class GSHTMLRuntimeEditor
implements ActionListener {
    protected JTextArea jtpSource;
    protected AtomicLong counter = new AtomicLong();
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");

    public GSHTMLRuntimeEditor(JTextArea jtpSource) {
        this.jtpSource = jtpSource;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.counter.incrementAndGet();
        Thread thread = new Thread(new EditThread());
        thread.start();
    }

    class EditThread
    implements Runnable {
        protected File tempFile;

        EditThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File fileCurrent = new File(".");
            DecimalFormat df = new DecimalFormat("0000000");
            Calendar cal = Calendar.getInstance();
            this.tempFile = new File(String.valueOf(fileCurrent.getAbsolutePath()) + "/temp/" + GSHTMLRuntimeEditor.this.sdf.format(cal.getTime()) + df.format(GSHTMLRuntimeEditor.this.counter.longValue()) + ".html");
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(this.tempFile.getAbsolutePath());
                    JTextArea jTextArea = GSHTMLRuntimeEditor.this.jtpSource;
                    synchronized (jTextArea) {
                        fos.write(GSHTMLRuntimeEditor.this.jtpSource.getText().getBytes());
                    }
                    fos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    return;
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            String editor = Preference.getInstance().getEditor();
            if (editor == null) {
                JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(), "The editor is not settting. ", "Error", 0);
                return;
            }
            ProcessBuilder pb = new ProcessBuilder(editor, this.tempFile.getAbsolutePath());
            try {
                try {
                    long modified = this.tempFile.lastModified();
                    Process p = pb.start();
                    int ret = p.waitFor();
                    JTextArea jTextArea = GSHTMLRuntimeEditor.this.jtpSource;
                    synchronized (jTextArea) {
                        if (modified != this.tempFile.lastModified()) {
                            int rsize;
                            FileInputStream in = new FileInputStream(this.tempFile.getAbsolutePath());
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] buffer = new byte[8192];
                            while ((rsize = in.read(buffer)) != -1) {
                                baos.write(buffer, 0, rsize);
                            }
                            int yesno = JOptionPane.showConfirmDialog(WorkspaceWindow.getInstance(), "The file was modefied by the external editor that you invoked.\r\nDo you like to reload the file edited on the disk?", "Reload confirmation", 0);
                            if (yesno == 0) {
                                GSHTMLRuntimeEditor.this.jtpSource.setText(new String(baos.toByteArray()));
                            }
                            in.close();
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.tempFile.delete();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    this.tempFile.delete();
                }
            }
            finally {
                this.tempFile.delete();
            }
        }
    }
}

