<?php
/*
 * SlWebTunnel
 * 	Manage data functions for File
 * $Id: slwtdatamanfile.php 6 2007-12-03 10:26:21Z cattaka $
 * Created on 2007/11/10
 *
 */

	require_once 'slwebtunnel.ini.php';


class DbTable
{
	var $rowSequence;
	var $labels;
	var $values;
	var $uniqueKeys;
	var $narrowKeys;
	var $updateFlag;

	var $fileName;
	var $lock;
	var $fp;
	var $openFlag;
	
	function DbTable($fileName, $lock)
	{
		$this->fileName = $fileName;
		$this->lock = $lock;
		$this->openFlag = false;
	}

	function loadFile($uniqueKeys, $narrowKeys, $labels)
	{
		$this->rowSequence = 0;
		$this->labels = array();
		$this->values = array();
		$this->uniqueKeys = array();
		$this->narrowKeys = array();
		
		foreach($uniqueKeys as $uk) {
			$this->uniqueKeys[$uk] = array();
		}
		foreach($narrowKeys as $nk) {
			$this->narrowKeys[$nk] = array();
		}
		
		if ($this->lock) {
			$this->fp = fopen($this->fileName, 'r+');
			$goflag = flock($this->fp, LOCK_EX);
		} else {
			$this->fp = fopen($this->fileName, 'r');
			$goflag = flock($this->fp, LOCK_SH);
		}
		
		if ($goflag)
		{
			$lt = fgetArray($this->fp);
			if ($lt !== FALSE)
			{
				//check key exsitence
				foreach($this->uniqueKeys as $uk => $v) {
					if (array_search($uk, $lt) === null) {
						//die("LabeldTable->load : uniqueKey '".$uk."' does not exist.");
						fclose($this->fp);
						return false;
					}
				}
				foreach($this->uniqueKeys as $nk => $v) {
					if (array_search($nk, $lt) === null) {
						//die("LabeldTable->load : narrowKey '".$nk."' does not exist.");
						fclose($this->fp);
						return false;
					}
				}
				
				$this->labels = $lt;
				$this->addLabels($labels);
				
				while(($data = fgetArray($this->fp)) !== FALSE)
				{
					$row = array();
					foreach($this->labels as $n => $l) {
						$row[$l] = $data[$n];
					}
					
					$this->insert($row);
				}
			}
			else
			{
				$this->labels = array_merge($uniqueKeys, $narrowKeys,$labels);
			}
			if (!$this->lock) {
				flock($this->fp, LOCK_UN);
				fclose($this->fp);
			}
			$this->openFlag = true;
			$this->updateFlag = false;
			return TRUE;
		}
		else
		{
			die("Could not lock ".$this->fileName.".");
		}
	}
	function saveFile()
	{
		if (!$this->updateFlag) {
			if ($this->lock) {
				flock($this->fp, LOCK_UN);
				fclose($this->fp);
			}
			return TRUE;
		}
		
		if ($this->lock) {
			$goflag = ftruncate ($this->fp, 0) && rewind($this->fp);
		} else {
			$this->fp = fopen($this->fileName, 'w');
			$goflag = flock($this->fp, LOCK_EX);
		}
		
		if ($goflag)
		{
			fputArray($this->fp, $this->labels);
			$label_num = count($this->labels);
			foreach($this->values as $info)
			{
				$data = array();
				for ($i=0;$i<$label_num;$i++)
				{
					$data[$i] = $info[$this->labels[$i]];
				}
				fputArray($this->fp, $data);
			}
			flock($this->fp, LOCK_UN);
			fclose($this->fp);
			$this->openFlag = false;
			return TRUE;
		}
		else
		{
			//die("Could not lock ".$this->fileName." file");
			return false;
		}
	}
	function addLabels(array $lbs)
	{
		foreach($lbs as $l)
		{
			if (!in_array($l, $this->labels))
			{
				$this->labels[] = $l;
			}
		}
	}
	function getRow($n) {
		$v = $this->values[$n];
		if (is_array($v)) {
			return $v;
		} else {
			return null;
		}
	}
	function getRowAll() {
		return $this->values;
	}
	function getRows($ns) {
		$result = array();
		foreach($ns as $n) {
			$v = $this->values[$n];
			if (is_array($v)) {
				$result[$n] = $v;
			}
		}
		return $result;
	}
	function getRowByUniqueKey($uniqueKey, $keyValue) {
		return $this->getRow($this->selectByUniqueKey($uniqueKey, $keyValue));
	}
	
	function getRowsByNarrowKey($narrowKey, $keyValue) {
		return $this->getRows($this->selectByNarrowKey($narrowKey, $keyValue));
	}
		
	function selectByUniqueKey($uniqueKey, $keyValue) {
		$rowNum = $this->uniqueKeys[$uniqueKey][$keyValue];
		if ($rowNum !== null) {
			return $rowNum;
		} else {
			return -1;
		}
	}
	function selectByNarrowKey($narrowKey, $keyValue) {
		$ns = $this->narrowKeys[$narrowKey][$keyValue];
		if (is_array($ns)) {
			return $ns;
		} else {
			return array();
		}
	}

	/**
	 * insert row.
	 * if uniqueKey is blank, Row will not be inserted.
	 * return number of effected row(0 or 1)
	 */
	function insert($row) {
		//check duplication
		foreach($this->uniqueKeys as $uk => $ukn) {
			if ($row[$uk] === null) {
				//die("UniqueKey is null : ".$uk);
				return 0;
			}
				
			if ($ukn[$row[$uk]] !== null) {
				//die("Duplicated UniqueKey : ".$uk." => ".$row[$uk].".");
				return 0;
			}
		}

		//exec insert
		foreach($this->uniqueKeys as $uk => $ukn) {
			$this->uniqueKeys[$uk][$row[$uk]] = $this->rowSequence;
		}
		foreach($this->narrowKeys as $nk => $nkns) {
			if ($row[$nk] !== null) {
				$this->narrowKeys[$nk][$row[$nk]][] = $this->rowSequence;
			}
		}

		$this->updateFlag = true;
		$this->values[$this->rowSequence] = $row;
		$this->rowSequence++;

		return 1;
	}
	
	/**
	 * update row.
	 * if uniqueKey is blank or collide with other, Row will not be updated.
	 * return number of effected row(0 or 1)
	 */
	function update($rowNum, $values) {
		$updateUK = array_intersect_key($values, $this->uniqueKeys);
		$updateNK = array_intersect_key($values, $this->narrowKeys);
		
		//check duplication, and update uniqueKey
		if (count($updateUK > 0)) {
			foreach($updateUK as $label => $value) {
				$c = $this->uniqueKeys[$label][$value];
				if ($c !== null && $rowNum != $c) {
					return 0;
				}
			}
			foreach($updateUK as $label => $value) {
				$currentValue = $this->values[$rowNum][$label];
				unset($this->uniqueKeys[$label][$currentValue]);
				$this->uniqueKeys[$label][$value] = $rowNum;
			}
		}
		//update narrowKey
		if (count($updateNK > 0)) {
			foreach($updateNK as $label => $value) {
				$currentValue = $this->values[$rowNum][$label];
				$n = array_search($rowNum, $this->narrowKeys[$label][$currentValue]);
				unset($this->narrowKeys[$label][$currentValue][$n]);
				$this->narrowKeys[$label][$value][] = $rowNum;
			}
		}
		
		foreach($values as $label => $value) {
			$this->updateFlag = true;
			$this->values[$rowNum][$label] = $value;
		}
		return 1;
	}
	
	/**
	 * update row by uniqueKey.
	 * if uniqueKey is blank or collide with other, Row will be not updated.
	 * return number of effected row(0 or 1)
	 */
	function updateByUniqueKey($uniqueKey, $keyValue, $values) {
		$rowNum = $this->uniqueKeys[$uniqueKey][$keyValue];
		if ($rowNum !== null) {
			return $this->update($rowNum, $values);
		}
		return 0;
	}
	
	/*
	 * delete row.
	 * return number of effected row(0 or 1)
	 */
	function delete($rowNum) {
		$row = $this->values[$rowNum];
		if ($row) {
			foreach($this->uniqueKeys as $uk => $ukn) {
				unset($this->uniqueKeys[$uk][$row[$uk]]);
			}
	
			foreach($this->narrowKeys as $nk => $nkns) {
				$n = array_search($rowNum, $this->narrowKeys[$nk][$row[$nk]]);
				unset($this->narrowKeys[$nk][$row[$nk]][$n]);
			}
			$this->updateFlag = true;
			unset($this->values[$rowNum]);
			return 1;
		}
		return 0;
	}
	
	function deleteByUniqueKey($uniqueKey, $keyValue) {
		$rowNum = $this->uniqueKeys[$uniqueKey][$keyValue];
		if ($rowNum === null) {
			return $this->delete($rowNum);
		} else {
			return 0;
		}
	}
	function deleteByNarrowKey($narrowKey, $keyValue) {
		$ns = $this->narrowKeys[$narrowKey][$keyValue];
		if (is_array($ns)) {
			$result = 0;
			foreach($ns as $n) {
				$result += $this->delete($n);
			}
			return $result;
		} else {
			return 0;
		}
	}
	
	function deleteAll() {
		$num = count($this->values);
		foreach($this->uniqueKeys as $uk => $ukn) {
			$this->uniqueKeys[$uk] = array();
		}
	
		foreach($this->narrowKeys as $nk => $nkns) {
			$this->narrowKeys[$nk] = array();
		}
		$this->values = array();
		$this->updateFlag = true;
		return $num;
	}
	
	function getFileName() {
		return $this->fileName;
	}
	function getOpenFlag() {
		return $this->openFlag;
	}
}


function fgetArray($fp)
{
	$line = fgets($fp);
	
	if ($line === FALSE) {
		return FALSE;
	}
	$line = str_replace("\n", '', $line);
	$result = explode(',,', $line);
	foreach($result as $k => $v) {
		$result[$k] = str_replace('\\,\\', ',', $v);
	} 

	return $result;
}

function fputArray($fp, $values)
{
	$ary = array();
	foreach($values as $k => $v) {
		$t = str_replace(',', '\\,\\', $v);
		$t = str_replace("\n", " " ,$t);
		$ary[] = $t;
	}
	$str = implode(',,', $ary)."\n";

	return fwrite($fp,$str);
}

	class SlwtDataManager {
		var $tblSlwebtunnelSystem;
		var $tblUserInfo;
		var $tblChannelInfo;
		var $tblTransmitQueue;
		var $tblSlAgent;
		var $tblLoginList;
		var $tblAgentList;
		var $tblMessageLog;

		var $initializedTime;
		var $initializedDate;
		
		function SlwtDataManager() {
			global $tblPrefix;
			$dataFileDir = DATA_SOURCE_DIR;
			$this->tblSlwebtunnelSystem	 = new DbTable($dataFileDir."/".$tblPrefix . "SlWebTunnelSystem.txt",	true);
			$this->tblUserInfo			 = new DbTable($dataFileDir."/".$tblPrefix . "UserInfo.txt",			false);
			$this->tblChannelInfo		 = new DbTable($dataFileDir."/".$tblPrefix . "ChannelInfo.txt",			false);
			$this->tblTransmitQueue		 = new DbTable($dataFileDir."/".$tblPrefix . "TransmitQueue.txt",		false);
			$this->tblSlAgent			 = new DbTable($dataFileDir."/".$tblPrefix . "SlAgent.txt", 			false);
			$this->tblLoginList			 = new DbTable($dataFileDir."/".$tblPrefix . "LoginList.txt", 			false);
			$this->tblAgentList			 = new DbTable($dataFileDir."/".$tblPrefix . "AgentList.txt", 			false);
			$this->tblMessageLog		 = new DbTable($dataFileDir."/".$tblPrefix . "MessageLog.txt", 			false);
			
			$this->initializedTime = time();
			$this->initializedDate = date("Y/m/d H:i:s", $this->initializedTime);
		}
		
		function initialize() {
			$this->tblSlwebtunnelSystem->loadFile(array(), array(), array("LAST_LOGDUMP", "USER_NUMBER", "SEQ_USER_INFO", "SEQ_CHANNEL_INFO", "SEQ_TRANSMIT_QUEUE", "SEQ_MESSAGE_LOG"));
			$this->tblChannelInfo->loadFile(array("CHANNEL_NUMBER" , "OWNER_ID"), array(), array("CHANNEL_NAME", "LAST_UPDATE", "LAST_CLEANUP", "PASSWORD", "UUID"));
			$this->tblUserInfo->loadFile(array("USER_NUMBER", "USER_ID"), array(), array("USER_NAME", "PASSWORD"));
			$this->tblSlAgent->loadFile(array("AGENT_NAME"), array(), array());
			$this->tblLoginList->loadFile(array(), array("USER_NUMBER", "CHANNEL_NUMBER"), array("LAST_UPDATE"));
			$this->tblAgentList->loadFile(array(), array("AGENT_NAME", "CHANNEL_NUMBER"), array());
			$this->tblMessageLog->loadFile(array("NUMERICAL_ORDER"), array("CHANNEL_NUMBER","USER_NUMBER", "AGENT_NAME"), array( "INSERT_TIME", "MESSAGE"));
			$this->tblTransmitQueue->loadFile(array("QUEUE_NUMBER"), array("CHANNEL_NUMBER"), array("NEXT_QUEUE_NUMBER", "BODY", "INSERT_DATE"));
			return true;
		}
		
		function dispose () {
			$this->tblChannelInfo->saveFile();
			$this->tblUserInfo->saveFile();
			$this->tblSlAgent->saveFile();
			$this->tblLoginList->saveFile();
			$this->tblAgentList->saveFile();
			$this->tblMessageLog->saveFile();
			$this->tblTransmitQueue->saveFile();

			//tblSlwebtunnelSystem has to close last of tbls.
			$this->tblSlwebtunnelSystem->saveFile();
			
		}

		function beginTransaction() {
		}

		function commit() {
		}

		/**
		 * Search UserName from Channel.
		 * 
		 * return Exists->TRUE, otherwise->FALSE
		 */
		function checkUserNameExistence($channelId, $userName) {
			$loginList = $this->tblLoginList->getRows($this->tblLoginList->selectByNarrowKey("CHANNEL_NUMBER", $channelId));
			foreach($loginList as $user) {
				$existUser = $this->tblUserInfo->getRow($this->tblUserInfo->selectByUniqueKey("USER_NUMBER" , $user['USER_NUMBER']));
				if (is_array($existUser) && $existUser['USER_NAME'] == $userName) {
					return true;
				}
			}
			return false;
		}
		
		/**
		 * Create new user account. This function insert to USER_INFO table.
		 * 
		 * return Success->array of userinfo, otherwise->FALSE
		 */
		function createUser($userId, $username, $password) {
			if (strlen($username) > MAX_USERNAME_LENGTH
				|| strlen($password) > MAX_PASSWORD_LENGTH) {
					return FALSE;
			}
			
			$userNumber = $this->getNextSeqUserInfo();
			// exec insert
			$this->tblUserInfo->insert(array("USER_NUMBER"=>$userNumber, "USER_ID"=>$userId, "USER_NAME"=>$username, "PASSWORD"=>$password));
			return true;
        }

		/**
		 * Insert user to LOGIN_LIST and LOGIN_LOG
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function loginUser($channelNumber, $userId, $remoteAddress) {
			$userinfo = null;
			$row = $this->tblUserInfo->getRowByUniqueKey("USER_ID", $userId);
			if ($row) {
				$userinfo = array(
					USERINFO_USER_NUMBER => $row["USER_NUMBER"] ,
					USERINFO_USER_ID => $row["USER_ID"] ,
					USERINFO_USER_NAME => $row["USER_NAME"] ,
				);
			}
			
			if ($userinfo) {
				$userNumber = $userinfo["USER_NUMBER"];
				$this->tblLoginList->insert(array("USER_NUMBER"=>$userNumber, "CHANNEL_NUMBER"=>$channelNumber, "LAST_UPDATE"=>$this->initializedDate));
				outputLog($channelNumber, array($this->initializedDate, "Login", CODE_WEB, $userinfo[USERINFO_USER_NAME], $remoteAddress));
				return $userinfo;
			}
			return false;
		}

		/**
		 * Delete user from LOGIN_LIST
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function logoutUser($channelNumber, $userNumber) {
			$rows = $this->tblLoginList->getRowsByNarrowKey("USER_NUMBER", $userNumber);
			$rowNumber = -1;
			foreach($rows as $n => $row) {
				if ($row["CHANNEL_NUMBER"] == $channelNumber) {
					$rowNumber = $n;
					break;
				}
			}
			$this->tblLoginList->delete($rowNumber);
		}
		
		/**
		 * Update LOGIN_LIST.LAST_UPDATE of user by NOW().
		 * If user was auto logouted, FALSE is returned.
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function updateUserLoginState($channelNumber, $userNumber) {
			$rows = $this->tblLoginList->getRowsByNarrowKey("USER_NUMBER", $userNumber);
			$rowNumber = -1;
			foreach($rows as $n => $row) {
				if ($row["CHANNEL_NUMBER"] == $channelNumber) {
					$rowNumber = $n;
					break;
				}
			}
			if ($rowNumber == -1) {
				return false;
			}
			$this->tblLoginList->update($rowNumber, array("LAST_UPDATE" => $this->initializedDate));
			return true;
		}
		
		/**
		 * Get log data for Web
		 * return array of (INSERT_DATE, CODE, NAME, MESSAGE)
		 */
		function getWebLogData($channelNumber, $limitRowNum) {
			$rows = $this->tblMessageLog->getRowsByNarrowKey("CHANNEL_NUMBER", $channelNumber);
			$result = array();
			foreach($rows as $row) {
				$userNumber = $row["USER_NUMBER"];
				if (!isBlank($userNumber)) {
					$userInfo = $this->tblUserInfo->getRowByUniqueKey("USER_NUMBER", $userNumber);
					$result[] = array(
						$row["INSERT_TIME"],
						CODE_WEB,
						$userInfo["USER_NAME"],
						$row["MESSAGE"]);
				} else {
					$result[] = array(
						$row["INSERT_TIME"],
						CODE_SL,
						$row["AGENT_NAME"],
						$row["MESSAGE"]);
				}
			}
			$result = array_slice($result, - $limitRowNum);
			$result = array_reverse($result);
			return $result;
		}

		/**
		 * Get log data for Web, there were inserted after CHANNEL_INFO.LAST.UPDATE.
		 * return array of (INSERT_DATE, NAME, MESSAGE)
		 */
		function getSlLogData($channelNumber, $targetDate) {
			$rows = $this->tblMessageLog->getRowsByNarrowKey("CHANNEL_NUMBER", $channelNumber);
			$result = array();
			
			$targetTime = strDateToTime($targetDate);

			foreach($rows as $row) {
				$userNumber = $row["USER_NUMBER"];
				
				$insertTime = strDateToTime($row["INSERT_TIME"]);
				
				if (!isBlank($userNumber) && $targetTime <= $insertTime) {
					$userInfo = $this->tblUserInfo->getRowByUniqueKey("USER_NUMBER", $userNumber);
					$result[] = array(
						$row["INSERT_TIME"],
						$userInfo["USER_NAME"],
						$row["MESSAGE"]);
				}
			}
			return $result;
		}
		
		/**
		 * Insert message into MESSAGE_LOG for SL.
		 * If length of message is more than MAX_MESSAGE_LENGTH, message will be cut.
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function insertSlMessage($channelNumber, $agentName, $message) {
			if (strlen($message) > MAX_MESSAGE_LENGTH) {
				$message = substr($message, 0, MAX_MESSAGE_LENGTH);
			}
			
			$this->tblMessageLog->insert(array(
												"NUMERICAL_ORDER" => $this->getNextSeqMessageLog(),
												"AGENT_NAME" => $agentName,
												"CHANNEL_NUMBER" => $channelNumber,
												"INSERT_TIME" => $this->initializedDate,
												"MESSAGE" => $message
											));
			outputLog($channelNumber, array($this->initializedDate, "Msg", "SL", $agentName, $message));
		}
		
		/**
		 * Insert message into MESSAGE_LOG for Web.
		 * If length of message is more than MAX_MESSAGE_LENGTH, message will be cut.
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function insertWebMessage($channelNumber, $userNumber, $userName, $message) {
			if (strlen($message) > MAX_MESSAGE_LENGTH) {
				$message = substr($message, 0, MAX_MESSAGE_LENGTH);
			}

			$this->tblMessageLog->insert(array(
												"NUMERICAL_ORDER" => $this->getNextSeqMessageLog(),
												"USER_NUMBER" => $userNumber,
												"CHANNEL_NUMBER" => $channelNumber,
												"INSERT_TIME" => $this->initializedDate,
												"MESSAGE" => $message
											));
			outputLog($channelNumber, array($this->initializedDate, "Msg", "Web", $userName, $message));
		}

		/**
		 * Delete AGENT_LIST.
		 */
		function deleteAgentList($channelNumber) {
			$this->tblAgentList->deleteByNarrowKey("CHANNEL_NUMBER", $channelNumber);
		}
		
		/**
		 * insert agent to AGENT_LIST.
		 */
		function insertAgentList($channelNumber, $agentName) {
			$this->tblSlAgent->insert(array("AGENT_NAME" => $agentName));
			$this->tblAgentList->insert(array("AGENT_NAME" => $agentName, "CHANNEL_NUMBER" => $channelNumber));

			return TRUE;
		}

		/**
		 * Getting username list FROM USER_LIST.
		 * return array of username
		 */
		function getLoginedUserList($channelNumber) {
			$loginList = $this->tblLoginList->getRowsByNarrowKey(CHANNEL_NUMBER, $channelNumber);
			$result = array();
			foreach($loginList as $user) {
				$row = $this->tblUserInfo->getRowByUniqueKey('USER_NUMBER', $user['USER_NUMBER']);
				if (is_array($row)) {
					$result[] = $row["USER_NAME"];
				}
			}
			return $result;
		}

		/**
		 * Getting agentname list FROM AGENT_LIST.
		 * return array of agentname
		 */
		function getLoginedAgentList($channelNumber) {
			$agentList = $this->tblAgentList->getRowsByNarrowKey(CHANNEL_NUMBER, $channelNumber);
			$result = array();
			foreach($agentList as $agent) {
				$result[] = $agent["AGENT_NAME"];
			}
			return $result;
		}
		
		/**
		 * Getting ChannelList and Infomation.
		 * return array of (ChannelNumber, ChannelName, UserNum, AgentNum) 
		 */
		function getChannelList() {
			$channelInfo = $this->tblChannelInfo->getRowAll();
			$result = array();
			foreach($channelInfo as $channel) {
				$channelNumber = $channel["CHANNEL_NUMBER"];
				$channelName = $channel["CHANNEL_NAME"];
				$userNum = count($this->tblLoginList->selectByNarrowKey("CHANNEL_NUMBER", $channelNumber));
				$agentNum = count($this->tblAgentList->selectByNarrowKey("CHANNEL_NUMBER", $channelNumber));
				$result[] = array(
					$channelNumber,
					$channelName,
					$userNum,
					$agentNum);
			}
			return $result;
		}

		function getChannelNumber($ownerId) {
			$channelInfo = $this->tblChannelInfo->getRowByUniqueKey("OWNER_ID", $ownerId);
			return $channelInfo["CHANNEL_NUMBER"];
		}

		/**
		 * Get CHANNEL_INFO.LAST_UPDATE
		 * return succedd->LAST_UPDATE, otherwise->FALSE
		 */
		function getChannelInfoLastUpdate($channelNumber) {
			$channelInfo = $this->tblChannelInfo->getRowByUniqueKey("CHANNEL_NUMBER", $channelNumber);
			return $channelInfo["LAST_UPDATE"];
		}

		/**
		 * Updating CHANNEL_INFO.LAST_UPDATE
		 * return succeed->previous LAST_UPDATE, otherwise->FALSE
		 */
		function updateChannel($channelNumber) {
			$rowNum = $this->tblChannelInfo->selectByUniqueKey("CHANNEL_NUMBER", $channelNumber);
			$row = $this->tblChannelInfo->getRow($rowNum);
			$result = $row["LAST_UPDATE"];
			$this->tblChannelInfo->update($rowNum, array("LAST_UPDATE" => $this->initializedDate));
			
			return $result;
		}
		
		/**
		 * Setup tunnel.
		 * return succeed->TRUE, otherwise->FALSE
		 */
		function setupTunnel($ownerId, $uuid, $password, $channelName) {
			$rowNum = $this->tblChannelInfo->selectByUniqueKey("OWNER_ID", $ownerId);
			$row = $this->tblChannelInfo->getRow($rowNum);
			if ($row["PASSWORD"] != $password) {
				return false;
			}
			$this->tblChannelInfo->update($rowNum, array("UUID" => $uuid, "LAST_UPDATE"=>$this->initializedDate, "CHANNEL_NAME"=>$channelName));
			return true;
		}
		
		/**
		 * Check whether tunnel is available.
		 * return available->CHANNEL_NUMBER, otherwise->FALSE
		 */
		function checkTunnelAvailable($ownerId, $uuid, $password) {
			$rowNum = $this->tblChannelInfo->selectByUniqueKey("OWNER_ID", $ownerId);
			$row = $this->tblChannelInfo->getRow($rowNum);
			if ($row["UUID"] != $uuid || $row["PASSWORD"] != $password) {
				return false;
			}
			return $row["CHANNEL_NUMBER"];
		}
		
		function isTimeToCleanup($channelNumber) {
			$rowNum = $this->tblChannelInfo->selectByUniqueKey("CHANNEL_NUMBER", $channelNumber);
			$row = $this->tblChannelInfo->getRow($rowNum);
			if ($row == null) {
				return false;
			}
			$lastCleanupSec = strDateToTime($row["LAST_CLEANUP"]);
			return ($lastCleanupSec < ($this->initializedTime - CLEAN_UP_INTERVAL));
		}

		function execCleanup($channelNumber){
			$rowNum = $this->tblChannelInfo->selectByUniqueKey("CHANNEL_NUMBER", $channelNumber);
			if ($rowNum == -1) {
				return false;
			}
			$this->tblChannelInfo->update($rowNum, array("LAST_CLEANUP" => $this->initializedDate));

			$loginList = $this->tblLoginList->selectByNarrowKey("CHANNEL_NUMBER", $channelNumber);
			foreach($loginList as $n) {
				$row = $this->tblLoginList->getRow($n);
				if ($row) {
					$lastCleanupSec = strDateToTime($row["LAST_UPDATE"]);
					if ($lastCleanupSec < ($this->initializedTime - AUTO_LOGOUT_INTERVAL)) {
						$this->tblLoginList->delete($n);
					}
				}
			}
			return TRUE;
		}
		
		function isTimeToLogDump(){
			global $logDumpInterval;
			$row = $this->tblSlwebtunnelSystem->getRow(0);
			if ($row == null) {
				return false;
			}
			$lastLogdumpSec = strDateToTime($row["LAST_LOGDUMP"]);
			
			return ($lastLogdumpSec < ($this->initializedTime - $logDumpInterval * 60));
		}
		
		function execLogDump() {
			global $logDumpInterval;
			$messageLog = $this->tblMessageLog->getRowAll();
			if ($messageLog) {
				foreach ($messageLog as $n => $row) {
					$insertTimeSec = strDateToTime($row["INSERT_TIME"]);
					if ($insertTimeSec < $this->initializedTime - $logDumpInterval * 60) {
						$this->tblMessageLog->delete($n);
					}
				}
			}
			
			$userInfo = $this->tblUserInfo->getRowAll();
			if ($userInfo) {
				foreach ($userInfo as $n => $row) {
					if (count($this->tblLoginList->selectByNarrowKey("USER_NUMBER", $row["USER_NUMBER"])) == 0
							&& count($this->tblMessageLog->selectByNarrowKey("USER_NUMBER", $row["USER_NUMBER"])) == 0) {
						
						$this->tblUserInfo->delete($n);
					}
				}
			}
			
			$slAgent = $this->tblSlAgent->getRowAll();
			if ($slAgent) {
				foreach ($slAgent as $n => $row) {
					if (count($this->tblAgentList->selectByNarrowKey("AGENT_NAME", $row["AGENT_NAME"])) == 0
							&& count($this->tblChannelInfo->selectByNarrowKey("AGENT_NAME", $row["AGENT_NAME"])) == 0) {

						$this->tblSlAgent->delete($n);
					}
				}
			}

			$this->tblSlwebtunnelSystem->update(0, array("LAST_LOGDUMP" => $this->initializedDate));
		}
		
		function insertTransmitQueue($channelNumber, $queueNumber, $nextQueueNumber, $body) {
			$n = $this->tblTransmitQueue->insert(array("CHANNEL_NUMBER" => $channelNumber, "QUEUE_NUMBER" => $queueNumber, "NEXT_QUEUE_NUMBER" => $nextQueueNumber, "BODY" => $body, "INSERT_DATE" => $this->initializedDate));
			return ($n > 0);
		}

		/**
		 * Delete all TransmitQueue of channel
		 */
		function deleteTransmitQueue($channelNumber) {
			$this->tblTransmitQueue->deleteByNarrowKey("CHANNEL_NUMBER", $channelNumber);
		}

		/**
		 * Get NEXT_QUEUE_NUMBER and BODY
		 */
		function getTransmitQueue($channelNumber, $queueNumber) {
			$row = $this->tblTransmitQueue->getRowByUniqueKey("QUEUE_NUMBER", $queueNumber);
			if ($row) {
				if ($row["CHANNEL_NUMBER"] == $channelNumber) {
					return array($row["NEXT_QUEUE_NUMBER"], $row["BODY"]); 
				}
			} else {
				return false;
			}
		}
		
		/**
		 * get Sequence for UserId
		 */
		function getNextUserNumber() {
        	$row = $this->tblSlwebtunnelSystem->getRow(0);
        	$n = (int)($row["USER_NUMBER"]) + 1;
        	$this->tblSlwebtunnelSystem->update(0, array("USER_NUMBER" => (string)$n));
        	
        	return $n;
		}

		/**
		 * get Sequence for TransmitQueue
		 */
		function getNextSeqTransmitQueue() {
        	$row = $this->tblSlwebtunnelSystem->getRow(0);
        	$n = (int)($row["SEQ_TRANSMIT_QUEUE"]) + 1;
        	$this->tblSlwebtunnelSystem->update(0, array("SEQ_TRANSMIT_QUEUE" => (string)$n));
        	
        	return $n;
		}
		        
		/**
		 * get Sequence for UserInfo
		 */
        function getNextSeqUserInfo() {
        	$row = $this->tblSlwebtunnelSystem->getRow(0);
        	$n = (int)($row["SEQ_USER_INFO"]) + 1;
        	$this->tblSlwebtunnelSystem->update(0, array("SEQ_USER_INFO" => (string)$n));
        	
        	return $n;
        }

		/**
		 * get Sequence for ChannelInfo
		 */
        function getNextSeqChannelInfo() {
        	$row = $this->tblSlwebtunnelSystem->getRow(0);
        	$n = (int)($row["SEQ_CHANNEL_INFO"]) + 1;
        	$this->tblSlwebtunnelSystem->update(0, array("SEQ_CHANNEL_INFO" => (string)$n));
        	
        	return $n;
        }

		/**
		 * get Sequence for UserInfo
		 */
        function getNextSeqMessageLog() {
        	$row = $this->tblSlwebtunnelSystem->getRow(0);
        	$n = (int)($row["SEQ_MESSAGE_LOG"]) + 1;
        	$this->tblSlwebtunnelSystem->update(0, array("SEQ_MESSAGE_LOG" => (string)$n));
        	
        	return $n;
        }


		/**
		 * Initialize Database.
		 * return array of (condition, successFlag, rouCount)
		 */
		function initializeDatabase() {
			$result[] = array($this->tblSlwebtunnelSystem->getFileName(), true, $this->tblSlwebtunnelSystem->deleteAll());
			$this->tblSlwebtunnelSystem->insert(array("LAST_LOGDUMP" => $this->initializedDate, "USER_NUMBER" => 1, "SEQ_CHANNEL_INFO" => 1, "SEQ_USER_INFO" => 1, "SEQ_MESSAGE_LOG" => 1, "SEQ_TRANSMIT_QUEUE" => 1));
			$result[] = array($this->tblUserInfo->getFileName(), true, $this->tblUserInfo->deleteAll());
			$result[] = array($this->tblChannelInfo->getFileName(), true, $this->tblChannelInfo->deleteAll());
			$result[] = array($this->tblTransmitQueue->getFileName(), true, $this->tblTransmitQueue->deleteAll());
			$result[] = array($this->tblSlAgent->getFileName(), true, $this->tblSlAgent->deleteAll());
			$result[] = array($this->tblLoginList->getFileName(), true, $this->tblLoginList->deleteAll());
			$result[] = array($this->tblAgentList->getFileName(), true, $this->tblAgentList->deleteAll());
			$result[] = array($this->tblMessageLog->getFileName(), true, $this->tblMessageLog->deleteAll());
			
			return $result;
		}
		
		/**
		 * check Database.
		 * reuturn array of (condition, successFlag)
		 */
		function checkDatabase() {
			$fileNames = array(
				$this->tblSlwebtunnelSystem->getFileName(),
				$this->tblUserInfo->getFileName(),
				$this->tblChannelInfo->getFileName(),
				$this->tblTransmitQueue->getFileName(),
				$this->tblSlAgent->getFileName(),
				$this->tblLoginList->getFileName(),
				$this->tblAgentList->getFileName(),
				$this->tblMessageLog->getFileName()
			);

			$result = array();
			foreach($fileNames as $fileName) {
				$result[] = array(ADMMSG_DATAFILE_EXISTS.$fileName, file_exists($fileName));
				$result[] = array(ADMMSG_DATAFILE_WRITABLE.$fileName, is_writable($fileName));
			}
			
			return $result;
		}
		
		/**
		 * Get CHANNEL_INFO
		 * return succedd->array of [CHANNEL_NUMBER, OWNER_ID, LAST_UPDATE], otherwise->FALSE
		 */
		function getChannelInfoForAdmin() {
			$rows = $this->tblChannelInfo->getRowAll();
			$result = array();
			if ($rows) {
				foreach($rows as $row) {
					$result[] = array($row["CHANNEL_NUMBER"], $row["OWNER_ID"], $row["LAST_UPDATE"]);
				}
			}
			return $result;
		}
		
		function updateChannelInfoForAdmin($channelNumber, $ownerId, $passKey) {
			$rowNum = $this->tblChannelInfo->selectByUniqueKey("CHANNEL_NUMBER", $channelNumber);
			if (isBlank($passKey)) {
				return $this->tblChannelInfo->update($rowNum, array("OWNER_ID"=>$ownerId));
			} else {
				return $this->tblChannelInfo->update($rowNum, array("OWNER_ID"=>$ownerId,"PASSWORD"=>$passKey));
			}
		}
		
		function insertChannelInfoForAdmin($ownerId, $passKey) {
			return $this->tblChannelInfo->insert(array("CHANNEL_NUMBER" => $this->getNextSeqChannelInfo(),"OWNER_ID"=>$ownerId,"PASSWORD"=>$passKey,"LAST_UPDATE"=>$this->initializedDate));
		}
		function deleteChannelInfoForAdmin($channelNumber) {
			$rowNum = $this->tblChannelInfo->selectByUniqueKey("CHANNEL_NUMBER", $channelNumber);
			return $this->tblChannelInfo->delete($rowNum);
		}
	}
?>
