/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.mainboard;

import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;
import jp.sourceforge.slotsimulator.mainboard.MainBoardListener;

public abstract class AbstractMainBoard
implements MainBoardInterface {
    protected static final int BIG = 3;
    protected static final int REG = 4;
    public static final int FLAG_NOFLAG = 0;
    public static final int FLAG_REPLAY = 1;
    public static final int FLAG_BIG = 2;
    public static final int FLAG_REG = 3;
    public static final int FLAG_BIG_NOFLAG = 0;
    public static final int FLAG_BIG_JACIN = 1;
    public static final int FLAG_JAC_NOFLAG = 0;
    public static final int FLAG_JAC_HIT = 1;
    private boolean hazusi = true;
    protected int totalGameCount = 0;
    protected int maxGameCount = 1000000;
    protected int maxDayCount = 1;
    protected boolean cancel = false;
    protected int wait = 0;
    protected int settei = -1;
    protected List listeners = null;
    protected int currentFlag = -1;
    protected boolean stateBig = false;
    protected boolean stateBigReg = false;
    protected boolean stateReg = false;
    protected boolean isReplay = false;
    protected boolean isBonus = false;
    private boolean isJacIn;
    private boolean isJacHit;
    protected int koyakuCounter = 0;

    public void setHazusi(boolean b) {
        this.hazusi = b;
    }

    public boolean isHazusi() {
        return this.hazusi;
    }

    public int getRandomMax() {
        return 65536;
    }

    public final int getTotalGameCount() {
        return this.totalGameCount;
    }

    public final void setMaxGameCount(int count) {
        this.maxGameCount = count;
    }

    public final void setMaxDayCount(int daycount) {
        this.maxDayCount = daycount;
        if (this.maxDayCount < 1) {
            this.maxDayCount = 1;
        }
    }

    public final void cancel() {
        this.cancel = true;
    }

    public final void setPriority(int i) {
        this.wait = 5000 * i * 4;
    }

    public final void setSettei(int settei) {
        this.settei = settei;
    }

    public final void addListener(MainBoardListener l) {
        this.listeners.add(l);
    }

    public final void removeListener(MainBoardListener l) {
        this.listeners.remove(l);
    }

    public final int getCurrentFlag() {
        return this.currentFlag;
    }

    public AbstractMainBoard() {
        this.initialize();
    }

    public void initialize() {
        this.listeners = new Vector();
    }

    protected void bonusGet() {
        this.isBonus = true;
    }

    protected void setJacIn() {
        this.isJacIn = true;
    }

    protected void setJacHit() {
        this.isJacHit = true;
    }

    public final int getProgress() {
        return this.totalGameCount * 100 / this.maxGameCount;
    }

    public final void run() {
        this.cancel = false;
        if (this.maxDayCount > 1) {
            this.fireEvent(10);
        }
        this.setup();
        int randomMax = this.getRandomMax();
        int nowDayCount = 0;
        while (!this.cancel && nowDayCount < this.maxDayCount) {
            ++nowDayCount;
            this.totalGameCount = 0;
            if (this.maxDayCount > 1) {
                this.fireEvent(8);
            } else {
                this.fireEvent(1);
            }
            this.reset();
            while (!this.cancel && this.totalGameCount < this.maxGameCount) {
                ++this.totalGameCount;
                if (this.totalGameCount % this.wait == 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
                this.currentFlag = this.koyakuCounter > 0 ? SimulatorLibrary.getTableIndex(this.getFlagTableLow()[this.settei - 1], randomMax) : SimulatorLibrary.getTableIndex(this.getFlagTableHigh()[this.settei - 1], randomMax);
                this.fireEventNormalGame();
                this.game(this.currentFlag);
                if (!this.isBonus) continue;
                this.fireEvent(4);
                int currentBonus = this.getCurrentBonus();
                if (currentBonus == 3) {
                    this.stateBig = true;
                    this.bigGameMain();
                    this.fireEvent(5);
                    this.stateBig = false;
                } else if (currentBonus == 4) {
                    this.stateReg = true;
                    this.jacGameMain();
                    this.fireEvent(5);
                    this.stateReg = false;
                } else {
                    throw new RuntimeException("Unknown Bonus");
                }
                this.reset();
            }
            if (this.maxDayCount > 1) {
                this.fireEvent(9);
                continue;
            }
            this.fireEvent(2);
        }
        if (this.maxDayCount > 1) {
            this.fireEvent(11);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void bigGameMain() {
        gameCount = 0;
        maxBigGameCount = this.getMaxBigGameCount();
        jacInCount = 0;
        maxJacInCount = this.getMaxJacInCount();
        flagTable = this.getFlagTableBigGame();
        randomMax = this.getRandomMax();
        if (flagTable != null) ** GOTO lbl17
        return;
lbl-1000:
        // 1 sources

        {
            this.currentFlag = SimulatorLibrary.getTableIndex(flagTable[this.settei - 1], randomMax);
            this.bigGame(this.currentFlag, ++gameCount, jacInCount);
            if (!this.isJacIn) continue;
            ++jacInCount;
            this.stateBigReg = true;
            this.jacGameMain();
            this.stateBigReg = false;
            this.isJacIn = false;
lbl17:
            // 3 sources

            ** while (gameCount < maxBigGameCount && jacInCount < maxJacInCount)
        }
lbl18:
        // 1 sources

        this.koyakuCounter = 0;
    }

    /*
     * Unable to fully structure code
     */
    protected final void jacGameMain() {
        gameCount = 0;
        maxGameCount = this.getMaxJacGameCount();
        jacHitCount = 0;
        maxJacHitCount = this.getMaxJacHitCount();
        flagTable = this.getFlagTableBonusGame();
        randomMax = this.getRandomMax();
        if (flagTable != null) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            this.currentFlag = SimulatorLibrary.getTableIndex(flagTable[this.settei - 1], randomMax);
            this.jacGame(this.currentFlag, ++gameCount);
            if (!this.isJacHit) continue;
            ++jacHitCount;
            this.isJacHit = false;
lbl14:
            // 3 sources

            ** while (gameCount < maxGameCount && jacHitCount < maxJacHitCount)
        }
lbl15:
        // 1 sources

    }

    public abstract void game(int var1);

    public abstract void bigGame(int var1, int var2, int var3);

    public int getMaxBigGameCount() {
        return 30;
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
                break;
            }
        }
    }

    public int getMaxJacInCount() {
        return 3;
    }

    public int getMaxJacGameCount() {
        return 12;
    }

    public int getMaxJacHitCount() {
        return 8;
    }

    public abstract int[][] getFlagTableHigh();

    public abstract int[][] getFlagTableBigGame();

    public abstract int[][] getFlagTableBonusGame();

    public abstract int[][] getFlagTableLow();

    public void setup() {
    }

    protected void reset() {
        this.isBonus = false;
        this.stateBig = false;
        this.stateReg = false;
    }

    protected void fireEventNormalGame() {
        ListIterator i = null;
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((MainBoardListener)i.next()).event(3);
            }
            Object var3_2 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            i = null;
            throw throwable;
        }
    }

    protected void fireCoinMinus(int count) {
        ListIterator i = null;
        if (!(this.stateBig || this.stateBigReg || this.stateReg)) {
            this.koyakuCounter -= this.genzanchi()[this.settei - 1] * count;
        }
        int state = -1;
        state = this.stateBig && !this.stateReg ? 1 : (this.stateReg ? 2 : 0);
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((MainBoardListener)i.next()).coinMinus(state, count);
            }
            Object var5_4 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            i = null;
            throw throwable;
        }
    }

    protected void fireCoinPlus(int count) {
        ListIterator i = null;
        if (!(this.stateBig || this.stateBigReg || this.stateReg)) {
            this.koyakuCounter += this.kasanchi()[this.settei - 1] * count;
        }
        int state = -1;
        state = this.stateBig && !this.stateReg ? 1 : (this.stateReg ? 2 : 0);
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((MainBoardListener)i.next()).coinPlus(state, count);
            }
            Object var5_4 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            i = null;
            throw throwable;
        }
    }

    protected void fireEvent(int eventId) {
        ListIterator i = null;
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((MainBoardListener)i.next()).event(eventId);
            }
            Object var4_3 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            i = null;
            throw throwable;
        }
    }

    public int getKoyakuCounter() {
        return this.koyakuCounter;
    }

    public abstract int[] kasanchi();

    public abstract int[] genzanchi();

    public abstract int getCurrentBonus();
}

