/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.datacounter;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface4Stock;
import jp.sourceforge.slotsimulator.mainboard.MainBoardListener;

public class ConsoleDataCounter
implements MainBoardListener {
    private boolean isResultOnly = true;
    private int initialStockCount = 10;
    private int settei = 1;
    private int maxGameCount = 7000;
    private String machineName = null;
    private String machineClassName = null;
    private MainBoardInterface simulator = null;
    private long totalGameCount = 0L;
    private long coin = 0L;
    private long inCoin = 0L;
    private long outCoin = 0L;
    private int currentGameCount = 0;
    private int bigCount = 0;
    private int regCount = 0;
    private long beforeBonusCoin = 0L;
    private long currentBonusCoin = 0L;
    private long totalTY = 0L;
    protected long startTimeMillis = 0L;
    protected long runTimeMillis = 0L;

    public static final void main(String[] args) {
        if (args != null && args.length < 3) {
            System.out.println("ex: ConsoleDataCounter JSR 6 1000000");
            System.exit(0);
        }
        ConsoleDataCounter main = null;
        try {
            block7: {
                try {
                    main = new ConsoleDataCounter();
                    main.setMachineName(args[0]);
                    if (Integer.parseInt(args[1]) != 0) {
                        main.setSettei(Integer.parseInt(args[1]));
                        main.setMaxGameCount(Integer.parseInt(args[2]));
                        main.start();
                        break block7;
                    }
                    main.setMaxGameCount(Integer.parseInt(args[2]));
                    int i = 1;
                    while (i <= 6) {
                        main.setSettei(i);
                        main.start();
                        ++i;
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    Object var4_5 = null;
                    main = null;
                }
            }
            Object var4_4 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            main = null;
            throw throwable;
        }
    }

    public void coinMinus(int state, int minus) {
        this.coin -= (long)minus;
        this.inCoin += (long)minus;
    }

    public void coinPlus(int state, int plus) {
        this.coin += (long)plus;
        this.outCoin += (long)plus;
    }

    public void event(int eventId) {
        switch (eventId) {
            case 3: {
                ++this.currentGameCount;
                ++this.totalGameCount;
                break;
            }
            case 4: {
                this.beforeBonusCoin = this.coin;
                break;
            }
            case 5: {
                this.currentBonusCoin = this.coin - this.beforeBonusCoin;
                if (this.simulator.getCurrentBonus() == 3) {
                    ++this.bigCount;
                    this.totalTY += this.currentBonusCoin;
                } else {
                    ++this.regCount;
                }
                if (!this.isResultOnly) {
                    this.appendLog(this.currentGameCount);
                    this.appendLog("\t");
                    if (this.simulator.getCurrentBonus() == 3) {
                        this.appendLog("BIG[" + this.currentBonusCoin + "]");
                    } else {
                        this.appendLog("REG[" + this.currentBonusCoin + "]");
                    }
                    this.appendLog("\t");
                    if (this.simulator instanceof AbstractMainBoard4Stock) {
                        this.appendLog("breakFactor:" + ((AbstractMainBoard4Stock)this.simulator).getBreakFactor());
                        this.appendLog(" mode:" + ((AbstractMainBoard4Stock)this.simulator).getCurrentMode());
                        this.appendLog("\t");
                    }
                    this.appendLog(this.coin);
                    this.appendLog("\n");
                }
                this.currentGameCount = 0;
                break;
            }
            case 1: {
                this.totalGameCount = 0L;
                this.coin = 0L;
                this.inCoin = 0L;
                this.outCoin = 0L;
                this.currentGameCount = 0;
                this.bigCount = 0;
                this.regCount = 0;
                this.totalTY = 0L;
                this.startTimeMillis = System.currentTimeMillis();
                this.appendLog("\n");
                this.appendLog(this.machineName);
                this.appendLog(" \u8a2d\u5b9a" + this.settei);
                this.appendLog(" " + this.maxGameCount + "G \u8a66\u884c");
                this.appendLog("\n\n");
                break;
            }
            case 2: {
                this.runTimeMillis = System.currentTimeMillis() - this.startTimeMillis;
                this.appendLogDenominator("BIG", this.bigCount, this.totalGameCount);
                this.appendLogDenominator("REG", this.regCount, this.totalGameCount);
                this.appendLogDenominator("\u5408\u6210", this.bigCount + this.regCount, this.totalGameCount);
                this.appendLogPayout();
                this.simulator = null;
            }
        }
    }

    public void start() throws Throwable {
        this.simulator = (MainBoardInterface)Class.forName(this.machineClassName).newInstance();
        this.simulator.setSettei(this.settei);
        if (this.simulator instanceof MainBoardInterface4Stock) {
            ((MainBoardInterface4Stock)this.simulator).stock(this.initialStockCount, ((MainBoardInterface4Stock)this.simulator).getStockType());
        }
        this.simulator.setHazusi(true);
        this.simulator.setMaxGameCount(this.maxGameCount);
        this.simulator.setMaxDayCount(1);
        this.simulator.setup();
        this.simulator.addListener(this);
        this.simulator.setPriority(5);
        this.simulator.run();
    }

    protected final void appendLog(String s) {
        System.out.print(s);
    }

    protected final void appendLog(int i) {
        System.out.print(String.valueOf(i));
    }

    protected final void appendLog(double d) {
        System.out.print(String.valueOf(d));
    }

    protected final void appendLogPayout() {
        double tyAverage = (double)this.totalTY / (double)this.bigCount;
        System.out.print("\u5e73\u5747BIG\u7372\u5f97:\t" + tyAverage);
        double pay = (double)this.outCoin / (double)this.inCoin * 100.0;
        System.out.print("\n");
        System.out.print("\nin: \t" + this.inCoin);
        System.out.print("\nout:\t" + this.outCoin);
        System.out.print("\n\u5dee\u679a:\t" + this.coin + "(" + pay + "%)");
        double time = (double)this.runTimeMillis / 1000.0;
        System.out.print("\n\n" + time + "[ms]");
        System.out.print("\tused:" + Runtime.getRuntime().freeMemory() / 1000L + "[kb]");
        System.out.print("/total:" + Runtime.getRuntime().totalMemory() / 1000L + "[kb]");
        System.out.print("\n");
    }

    protected final void appendLogCount(String title, int count) {
        System.out.print(title);
        System.out.print(":\t");
        System.out.print(String.valueOf(count));
        System.out.print("\n");
    }

    protected final void appendLogCount(String title, double count) {
        System.out.print(title);
        System.out.print(":\t");
        System.out.print(String.valueOf(count));
        System.out.print("\n");
    }

    protected final void appendLogPercent(String title, int count, int total) {
        System.out.print(title);
        System.out.print(":\t");
        System.out.print(String.valueOf(count));
        System.out.print("\t");
        System.out.print(SimulatorLibrary.getPercent(count, total));
        System.out.print("\n");
    }

    protected final void appendLogDenominator(String title, int count, long total) {
        System.out.print(title);
        System.out.print(":\t");
        System.out.print(String.valueOf(count));
        System.out.print("\t");
        System.out.print(SimulatorLibrary.getDenominator(count, total));
        System.out.print("\n");
    }

    public void setInitialStockCount(int i) {
        this.initialStockCount = i;
    }

    public void setResultOnly(boolean b) {
        this.isResultOnly = b;
    }

    public void setMachineName(String string) {
        this.machineName = string;
        this.machineClassName = "jp.sourceforge.slotsimulator.machines." + this.machineName + "." + this.machineName + "MainBoard";
    }

    public void setSettei(int i) {
        this.settei = i;
    }

    public void setMaxGameCount(int i) {
        this.maxGameCount = i;
    }
}

