/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.datacounter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import jp.sourceforge.slotsimulator.datacounter.DataCounterInterface;
import jp.sourceforge.slotsimulator.datacounter.DataCounterListener;
import jp.sourceforge.slotsimulator.datacounter.DefaultStrategyMonitor;
import jp.sourceforge.slotsimulator.datacounter.LogPanel;
import jp.sourceforge.slotsimulator.datacounter.SlumpPanel;
import jp.sourceforge.slotsimulator.datacounter.StrategyMonitorInterface;
import jp.sourceforge.slotsimulator.library.NumberDocument;
import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;
import jp.sourceforge.slotsimulator.mainboard.MainBoardListener;

public abstract class AbstractDataCounter
extends JFrame
implements DataCounterInterface,
MainBoardListener,
ActionListener,
Runnable {
    private JTextArea textArea = null;
    private JComboBox comboPriority = null;
    private JComboBox comboSettei = null;
    protected JTextField textMaxGameCount = null;
    protected JComboBox comboDayOrGame = null;
    protected JButton buttonRun = null;
    private JTabbedPane tab = null;
    private SlumpPanel slumpGraph = null;
    protected JMenuBar menuBar = null;
    protected JMenu menuFile = null;
    protected JMenuItem menuItemStrategy = null;
    protected JMenuItem menuItemExit = null;
    protected JMenu menuOption = null;
    protected JCheckBoxMenuItem menuItemResultOnly = null;
    protected JCheckBoxMenuItem menuItemSlumpGraph = null;
    protected JCheckBoxMenuItem menuItemHazusiEnable = null;
    protected MainBoardInterface simulator = null;
    protected boolean running = false;
    protected Thread runnable = null;
    private int bigCount = 0;
    private int regCount = 0;
    private int totalGameCount = 0;
    private int currentGameCount = 0;
    private int bigIntervalGameCount = 0;
    private int totalTY = 0;
    private long beforeBonusCoin = 0L;
    protected long currentBonusCoin = 0L;
    protected long maxBonusInterval = 0L;
    protected long maxBigInterval = 0L;
    protected List listeners = null;
    protected int coin = 0;
    protected int inCoin = 0;
    protected int outCoin = 0;
    private int lastOutCoin = 0;
    private int nDaysMinPayout = 0;
    private int nDaysMaxPayout = 0;
    private int nDaysPlusDayCount = 0;
    private int nDaysMinusDayCount = 0;
    private long nDaysTotalPayout = 0L;
    private int nDaysTotalMaxMinimus = 0;
    private int nDaysDayCount = 0;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_10000 = 0;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_9000_9999 = 1;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_8000_8999 = 2;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_7000_7999 = 3;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_6000_6999 = 4;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_5000_5999 = 5;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_4000_4999 = 6;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_3000_3999 = 7;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_2000_2999 = 8;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_1000_1999 = 9;
    public static final int NDAYS_PAYOUT_INDEX_MINUS_1_999 = 10;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_0_999 = 11;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_1000_1999 = 12;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_2000_2999 = 13;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_3000_3999 = 14;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_4000_4999 = 15;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_5000_5999 = 16;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_6000_6999 = 17;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_7000_7999 = 18;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_8000_8999 = 19;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_9000_9999 = 20;
    public static final int NDAYS_PAYOUT_INDEX_PLUS_10000 = 21;
    private int[] nDaysPayoutRange = new int[22];
    private int runMode = -1;
    protected int maxBigGame = 30;
    protected int maxJacGame = 12;
    protected int maxJacInCount = 8;
    protected long startTimeMillis = 0L;
    protected long runTimeMillis = 0L;
    private boolean isThreadRunning = false;

    public void addListener(DataCounterListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DataCounterListener l) {
        this.listeners.remove(l);
    }

    public AbstractDataCounter() {
        this.initialize();
    }

    public int getCoin() {
        return this.coin;
    }

    public int getInCoin() {
        return this.inCoin;
    }

    public int getOutCoin() {
        return this.outCoin;
    }

    public int getRunMode() {
        return this.runMode;
    }

    protected int getBigCount() {
        return this.bigCount;
    }

    protected int getRegCount() {
        return this.regCount;
    }

    protected int getTotalGameCount() {
        return this.totalGameCount;
    }

    protected int getCurrentGameCount() {
        return this.currentGameCount;
    }

    public int getCurrentBonus() {
        return this.simulator.getCurrentBonus();
    }

    public MainBoardInterface getSimulatorRef() {
        return this.simulator;
    }

    public void initialize() {
        this.setFont2All(new Font("Dialog", 0, 10));
        this.listeners = new Vector();
        if (this.isThreadRunning) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(3);
        }
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuFile = new JMenu("File");
        this.menuFile.setMnemonic('F');
        this.menuBar.add(this.menuFile);
        this.menuItemExit = new JMenuItem("Exit");
        this.menuItemExit.setMnemonic('X');
        this.menuItemExit.addActionListener(this);
        this.menuFile.add(this.menuItemExit);
        this.menuItemStrategy = new JMenuItem("\u7acb\u3061\u56de\u308a\u30d1\u30bf\u30fc\u30f3\u8ffd\u52a0");
        this.menuItemStrategy.addActionListener(this);
        this.menuFile.add(this.menuItemStrategy);
        this.menuOption = new JMenu("Option");
        this.menuOption.setMnemonic('O');
        this.menuBar.add(this.menuOption);
        this.menuItemResultOnly = new JCheckBoxMenuItem("\u7d50\u679c\u306e\u307f");
        this.menuItemResultOnly.setMnemonic('R');
        this.menuItemResultOnly.addActionListener(this);
        this.menuOption.add(this.menuItemResultOnly);
        this.menuItemSlumpGraph = new JCheckBoxMenuItem("\u30b9\u30e9\u30f3\u30d7\u30b0\u30e9\u30d5");
        this.menuItemSlumpGraph.setMnemonic('S');
        this.menuItemSlumpGraph.addActionListener(this);
        this.menuItemSlumpGraph.setSelected(true);
        this.menuOption.add(this.menuItemSlumpGraph);
        this.menuItemHazusiEnable = new JCheckBoxMenuItem("\u306f\u305a\u3057", true);
        this.menuOption.add(this.menuItemHazusiEnable);
        this.menuOption.add(new JSeparator());
        JPanel north = new JPanel(new FlowLayout());
        JPanel center = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane();
        this.tab = new JTabbedPane();
        this.textArea = new JTextArea();
        this.textArea.setAutoscrolls(true);
        scroll.getViewport().add(this.textArea);
        this.tab.add((Component)scroll, "\u5c65\u6b74");
        center.add(this.tab);
        this.comboPriority = new JComboBox();
        this.comboPriority.addItem("\u3082\u3045\u6b7b\u306c");
        this.comboPriority.addItem("\u5fc5\u6b7b");
        this.comboPriority.addItem("\u304c\u3093\u3070\u308b");
        this.comboPriority.addItem("\u30de\u30bf\u30fc\u30ea");
        this.comboPriority.addItem("\u3066\u304d\u3068\u3045");
        this.comboSettei = new JComboBox();
        this.comboSettei.addItem("1");
        this.comboSettei.addItem("2");
        this.comboSettei.addItem("3");
        this.comboSettei.addItem("4");
        this.comboSettei.addItem("5");
        this.comboSettei.addItem("6");
        this.textMaxGameCount = new JTextField();
        this.textMaxGameCount.setPreferredSize(new Dimension(60, 25));
        ((JTextComponent)this.textMaxGameCount).setDocument(new NumberDocument());
        this.textMaxGameCount.setText("7000");
        this.comboDayOrGame = new JComboBox();
        this.comboDayOrGame.addItem("G");
        this.comboDayOrGame.addItem("\u65e5");
        this.comboDayOrGame.setToolTipText("\u300c\u65e5\u300d\u3092\u9078\u3076\u3068\u3001\u6307\u5b9a\u3057\u305f\u65e5\u6570*7000G\u3067\u5b9f\u884c\u3057\u307e\u3059\u3002");
        this.buttonRun = new JButton("Run");
        this.buttonRun.setMnemonic('R');
        this.buttonRun.addActionListener(this);
        north.add(new JLabel("\u512a\u5148\u5ea6"));
        north.add(this.comboPriority);
        north.add(new JLabel("\u8a2d\u5b9a"));
        north.add(this.comboSettei);
        north.add(new JLabel("G\u6570"));
        north.add(this.textMaxGameCount);
        north.add(this.comboDayOrGame);
        this.initializeGui(north);
        north.add(this.buttonRun);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)north, "North");
        this.getContentPane().add((Component)center, "Center");
        ((Component)this).setSize(this.getFrameSize());
        this.setTitle(this.getFrameTitle());
    }

    public void setFont2All(Font font) {
        Enumeration e = null;
        try {
            String key = null;
            e = UIManager.getDefaults().keys();
            while (e.hasMoreElements()) {
                key = e.nextElement().toString();
                if (key.endsWith(".font")) {
                    UIManager.put(key, font);
                }
                key = null;
            }
            Object var5_4 = null;
            e = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            e = null;
            throw throwable;
        }
    }

    public int getMaxSimulateGame() {
        return Integer.parseInt(this.textMaxGameCount.getText());
    }

    protected void addOptionMenu(JMenuItem item) {
        this.menuOption.add(item);
    }

    protected void addLogPanel(String title, LogPanel panel) {
        this.tab.add(title, panel);
    }

    protected void removeLogPanel(LogPanel panel) {
        this.tab.remove(panel);
    }

    public void coinMinus(int state, int count) {
        this.coin -= count;
        this.inCoin += count;
        ListIterator i = null;
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((DataCounterListener)i.next()).coinMinus(state, count, this.currentGameCount, this.bigIntervalGameCount);
            }
            Object var5_4 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            i = null;
            throw throwable;
        }
    }

    public void coinPlus(int state, int count) {
        this.lastOutCoin = count;
        this.coin += count;
        this.outCoin += count;
        ListIterator i = null;
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((DataCounterListener)i.next()).coinPlus(state, count, this.currentGameCount, this.bigIntervalGameCount);
            }
            Object var5_4 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            i = null;
            throw throwable;
        }
    }

    public void event(int eventId) {
        switch (eventId) {
            case 3: {
                if (this.runMode != 1) break;
                ++this.totalGameCount;
                if (this.totalGameCount % 10000 == 0) {
                    this.setTitle(this.getFrameTitle() + "(" + this.simulator.getProgress() + "% end)");
                }
                ++this.currentGameCount;
                ++this.bigIntervalGameCount;
                this.fireEvent(eventId);
                this.eventStart();
                break;
            }
            case 4: {
                if (this.runMode == 1) {
                    this.beforeBonusCoin = this.coin;
                    this.fireEvent(eventId);
                    this.eventBonusStart();
                    break;
                }
                if (this.simulator.getCurrentBonus() == 3) {
                    ++this.bigCount;
                    break;
                }
                ++this.regCount;
                break;
            }
            case 5: {
                if (this.runMode != 1) break;
                this.currentBonusCoin = (long)this.coin - this.beforeBonusCoin;
                this.fireEvent(eventId);
                this.eventBonusEnd();
                this.currentGameCount = 0;
                if (this.simulator.getCurrentBonus() == 3) {
                    ++this.bigCount;
                    this.totalTY = (int)((long)this.totalTY + this.currentBonusCoin);
                    this.bigIntervalGameCount = 0;
                    break;
                }
                ++this.regCount;
                break;
            }
            case 8: {
                this.bigCount = 0;
                this.regCount = 0;
                this.totalGameCount = 0;
                this.currentGameCount = 0;
                this.coin = 0;
                this.inCoin = 0;
                this.outCoin = 0;
                this.totalTY = 0;
                ++this.nDaysDayCount;
                break;
            }
            case 9: {
                this.process1DayEnd();
                if (this.nDaysDayCount % 10 != 0) break;
                this.setTitle(this.getFrameTitle() + "(" + this.nDaysDayCount + "\u65e5 end)");
                break;
            }
            case 10: {
                this.nDaysMinPayout = 65536;
                this.nDaysMaxPayout = 0;
                this.nDaysPlusDayCount = 0;
                this.nDaysMinusDayCount = 0;
                this.nDaysDayCount = 0;
                this.nDaysTotalPayout = 0L;
                int i = 0;
                while (i < this.nDaysPayoutRange.length) {
                    this.nDaysPayoutRange[i] = 0;
                    ++i;
                }
            }
            case 1: {
                this.fireEvent(eventId);
                this.textMaxGameCount.setEditable(false);
                this.textArea.setText("");
                this.bigCount = 0;
                this.regCount = 0;
                this.running = true;
                this.totalGameCount = 0;
                this.currentGameCount = 0;
                this.coin = 0;
                this.inCoin = 0;
                this.outCoin = 0;
                this.totalTY = 0;
                this.startTimeMillis = System.currentTimeMillis();
                this.processEvent(eventId);
                this.eventSimulateStart();
                break;
            }
            case 11: {
                this.runTimeMillis = System.currentTimeMillis() - this.startTimeMillis;
                this.running = false;
                this.guiReset();
                this.processNDaysEnd();
                break;
            }
            case 2: {
                this.runTimeMillis = System.currentTimeMillis() - this.startTimeMillis;
                this.running = false;
                this.guiReset();
                this.fireEvent(eventId);
                this.processEvent(eventId);
                this.eventSimulateEnd();
                break;
            }
            default: {
                if (this.runMode != 1) break;
                this.processEvent(eventId);
            }
        }
    }

    protected void fireEvent(int eventId) {
        ListIterator i = null;
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((DataCounterListener)i.next()).event(eventId, this.currentGameCount, this.bigIntervalGameCount);
            }
            Object var4_3 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            i = null;
            throw throwable;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.buttonRun) {
            if (!this.running) {
                if (this.simulator != null) {
                    this.simulator = null;
                }
                this.simulator = this.getSimulator();
                this.simulator.setSettei(Integer.parseInt((String)this.comboSettei.getSelectedItem()));
                this.simulator.setHazusi(this.menuItemHazusiEnable.isSelected());
                this.simulator.setup();
                if (this.comboDayOrGame.getSelectedIndex() == 0) {
                    this.simulator.setMaxGameCount(Integer.parseInt(this.textMaxGameCount.getText()));
                    this.simulator.setMaxDayCount(1);
                    this.runMode = 1;
                } else {
                    this.simulator.setMaxGameCount(7000);
                    this.simulator.setMaxDayCount(Integer.parseInt(this.textMaxGameCount.getText()));
                    this.menuItemSlumpGraph.setSelected(false);
                    this.runMode = 2;
                }
                this.simulator.addListener(this);
                this.runnable = new Thread(this.simulator);
                this.simulator.setPriority(this.comboPriority.getItemCount() - this.comboPriority.getSelectedIndex());
                this.buttonRun.setText("Stop");
                this.buttonRun.setMnemonic('S');
                this.guiLock();
                if (this.menuItemSlumpGraph.isSelected()) {
                    if (this.slumpGraph == null) {
                        this.slumpGraph = new SlumpPanel();
                        this.slumpGraph.create(this, "\u30b9\u30e9\u30f3\u30d7\u30b0\u30e9\u30d5(\u30e1\u30a4\u30f3)");
                        ((Component)this.slumpGraph).setBounds(50, 50, 350, 300);
                    }
                } else if (this.slumpGraph != null) {
                    this.slumpGraph.dispose();
                    this.slumpGraph = null;
                }
                this.runnable.start();
            } else {
                this.simulator.cancel();
                this.buttonRun.setText("Run");
                this.buttonRun.setMnemonic('R');
                this.running = false;
                this.textMaxGameCount.setEditable(true);
            }
        } else if (source == this.menuItemExit) {
            this.dispose();
        } else {
            if (source == this.menuItemStrategy) {
                StrategyMonitorInterface monitor = null;
                try {
                    monitor = this.getStrategyMonitor();
                    monitor.create(this);
                    Object var5_5 = null;
                    monitor = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    monitor = null;
                    throw throwable;
                }
            }
            if (source == this.menuItemResultOnly) {
                int count = this.menuOption.getItemCount();
                boolean selected = this.menuItemResultOnly.isSelected();
                if (selected) {
                    JMenuItem item = null;
                    try {
                        int i = 0;
                        while (i < count) {
                            item = this.menuOption.getItem(i);
                            if (item instanceof JCheckBoxMenuItem && item != this.menuItemResultOnly && item != this.menuItemSlumpGraph) {
                                ((JCheckBoxMenuItem)item).setSelected(!selected);
                            }
                            ++i;
                        }
                        Object var8_11 = null;
                        item = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        item = null;
                        throw throwable;
                    }
                }
            }
        }
    }

    protected StrategyMonitorInterface getStrategyMonitor() {
        return new DefaultStrategyMonitor();
    }

    private void guiLock() {
    }

    private void guiReset() {
        this.buttonRun.setText("Run");
        this.buttonRun.setMnemonic('R');
        this.textMaxGameCount.setEditable(true);
        this.textArea.requestFocus();
        this.setTitle(this.getFrameTitle());
    }

    private void process1DayEnd() {
        int index = -1;
        if (this.coin < this.nDaysMinPayout) {
            this.nDaysMinPayout = this.coin;
        }
        if (this.nDaysMaxPayout < this.coin) {
            this.nDaysMaxPayout = this.coin;
        }
        this.nDaysTotalPayout += (long)this.coin;
        if (this.coin < 0) {
            ++this.nDaysMinusDayCount;
            index = this.coin < -10000 ? 0 : (this.coin <= -9000 ? 1 : (this.coin <= -8000 ? 2 : (this.coin <= -7000 ? 3 : (this.coin <= -6000 ? 4 : (this.coin <= -5000 ? 5 : (this.coin <= -4000 ? 6 : (this.coin <= -3000 ? 7 : (this.coin <= -2000 ? 8 : (this.coin <= -1000 ? 9 : 10)))))))));
        } else {
            ++this.nDaysPlusDayCount;
            index = this.coin > 10000 ? 21 : (this.coin >= 9000 ? 20 : (this.coin >= 8000 ? 19 : (this.coin >= 7000 ? 18 : (this.coin >= 6000 ? 17 : (this.coin >= 5000 ? 16 : (this.coin >= 4000 ? 15 : (this.coin >= 3000 ? 14 : (this.coin >= 2000 ? 13 : (this.coin >= 1000 ? 12 : 11)))))))));
        }
        int n = index;
        this.nDaysPayoutRange[n] = this.nDaysPayoutRange[n] + 1;
        if (!this.menuItemResultOnly.isSelected()) {
            this.appendLog(this.nDaysDayCount);
            this.appendLog("\u65e5\u76ee\t");
            this.appendLog(this.coin);
            this.appendLog("\u679a");
            this.appendLog("\t");
            this.appendLog(this.nDaysTotalPayout);
            this.appendLog("\tB");
            this.appendLog(this.bigCount);
            this.appendLog("R");
            this.appendLog(this.regCount);
            this.appendLog("\n");
        }
    }

    private void processNDaysEnd() {
        this.appendLog("\n");
        this.appendLog(this.nDaysDayCount);
        this.appendLog("\u65e5\u00d77000G\u5b9f\u884c\u7d50\u679c");
        this.appendLog("\n");
        this.appendLog("\n");
        if (this.nDaysDayCount < 1) {
            return;
        }
        this.appendLogPercent("\u52dd\u7387", this.nDaysPlusDayCount, this.nDaysDayCount);
        this.appendLogPercent("\u6557\u7387", this.nDaysMinusDayCount, this.nDaysDayCount);
        this.appendLog("\u6700\u9ad8\u5dee\u679a\u6570:\t");
        this.appendLog(this.nDaysMaxPayout);
        this.appendLog("\n");
        this.appendLog("\u6700\u4f4e\u5dee\u679a\u6570:\t");
        this.appendLog(this.nDaysMinPayout);
        this.appendLog("\n");
        this.appendLog("\u5e73\u5747\u5dee\u679a\u6570:\t");
        this.appendLog(this.nDaysTotalPayout / (long)this.nDaysDayCount);
        this.appendLog("\n");
        this.appendLog("\n");
        this.appendLogPercent("+10000\u679aover", this.nDaysPayoutRange[21], this.nDaysDayCount);
        this.appendLogPercent("+9000\u301c+9999", this.nDaysPayoutRange[20], this.nDaysDayCount);
        this.appendLogPercent("+8000\u301c+8999", this.nDaysPayoutRange[19], this.nDaysDayCount);
        this.appendLogPercent("+7000\u301c+7999", this.nDaysPayoutRange[18], this.nDaysDayCount);
        this.appendLogPercent("+6000\u301c+6999", this.nDaysPayoutRange[17], this.nDaysDayCount);
        this.appendLogPercent("+5000\u301c+5999", this.nDaysPayoutRange[16], this.nDaysDayCount);
        this.appendLogPercent("+4000\u301c+4999", this.nDaysPayoutRange[15], this.nDaysDayCount);
        this.appendLogPercent("+3000\u301c+3999", this.nDaysPayoutRange[14], this.nDaysDayCount);
        this.appendLogPercent("+2000\u301c+2999", this.nDaysPayoutRange[13], this.nDaysDayCount);
        this.appendLogPercent("+1000\u301c+1999", this.nDaysPayoutRange[12], this.nDaysDayCount);
        this.appendLogPercent("   0\u301c  +999", this.nDaysPayoutRange[11], this.nDaysDayCount);
        this.appendLogPercent("  -1\u301c  -999", this.nDaysPayoutRange[10], this.nDaysDayCount);
        this.appendLogPercent("-1000\u301c-1999", this.nDaysPayoutRange[9], this.nDaysDayCount);
        this.appendLogPercent("-2000\u301c-2999", this.nDaysPayoutRange[8], this.nDaysDayCount);
        this.appendLogPercent("-3000\u301c-3999", this.nDaysPayoutRange[7], this.nDaysDayCount);
        this.appendLogPercent("-4000\u301c-4999", this.nDaysPayoutRange[6], this.nDaysDayCount);
        this.appendLogPercent("-5000\u301c-5999", this.nDaysPayoutRange[5], this.nDaysDayCount);
        this.appendLogPercent("-6000\u301c-6999", this.nDaysPayoutRange[4], this.nDaysDayCount);
        this.appendLogPercent("-7000\u301c-7999", this.nDaysPayoutRange[3], this.nDaysDayCount);
        this.appendLogPercent("-8000\u301c-8999", this.nDaysPayoutRange[2], this.nDaysDayCount);
        this.appendLogPercent("-9000\u301c-9999", this.nDaysPayoutRange[1], this.nDaysDayCount);
        this.appendLogPercent("-10000\u679aover", this.nDaysPayoutRange[0], this.nDaysDayCount);
        double time = (double)this.runTimeMillis / 1000.0;
        this.textArea.append("\n\n" + time + "[ms]");
        this.textArea.append("\tused:" + Runtime.getRuntime().freeMemory() / 1000L + "[kb]");
        this.textArea.append("\ttotal" + Runtime.getRuntime().totalMemory() / 1000L + "[kb]");
        this.textArea.append("\n");
    }

    protected final void appendLog(String s) {
        this.textArea.append(s);
    }

    protected final void appendLog(int i) {
        this.textArea.append(String.valueOf(i));
    }

    protected final void appendLog(double d) {
        this.textArea.append(String.valueOf(d));
    }

    protected final void appendLogPayout() {
        double tyAverage = (double)this.totalTY / (double)this.bigCount;
        this.textArea.append("\u5e73\u5747BIG\u7372\u5f97:\t" + tyAverage);
        double pay = (double)this.getOutCoin() / (double)this.getInCoin() * 100.0;
        this.textArea.append("\n\nin:\t" + this.getInCoin());
        this.textArea.append("\nout:\t" + this.getOutCoin());
        this.textArea.append("\n\u5dee\u679a:\t" + this.getCoin() + "(" + pay + "%)");
        double time = (double)this.runTimeMillis / 1000.0;
        this.textArea.append("\n\n" + time + "[ms]");
        this.textArea.append("\tused:" + Runtime.getRuntime().freeMemory() / 1000L + "[kb]");
        this.textArea.append("\ttotal" + Runtime.getRuntime().totalMemory() / 1000L + "[kb]");
        this.textArea.append("\n");
    }

    protected final void appendLogStopGameAndTotalGame() {
        this.textArea.append(String.valueOf(this.getCurrentGameCount()));
        this.textArea.append("\t\u30e4\u30e1\ttotal");
        this.textArea.append(String.valueOf(this.getTotalGameCount()));
        this.textArea.append("\n\n");
    }

    protected final void appendLogCount(String title, int count) {
        this.textArea.append(title);
        this.textArea.append(":\t");
        this.textArea.append(String.valueOf(count));
        this.textArea.append("\n");
    }

    protected final void appendLogCount(String title, double count) {
        this.textArea.append(title);
        this.textArea.append(":\t");
        this.textArea.append(String.valueOf(count));
        this.textArea.append("\n");
    }

    protected final void appendLogPercent(String title, int count, int total) {
        this.textArea.append(title);
        this.textArea.append(":\t");
        this.textArea.append(String.valueOf(count));
        this.textArea.append("\t");
        this.textArea.append(SimulatorLibrary.getPercent(count, total));
        this.textArea.append("\n");
    }

    protected final void appendLogDenominator(String title, int count, int total) {
        this.textArea.append(title);
        this.textArea.append(":\t");
        this.textArea.append(String.valueOf(count));
        this.textArea.append("\t");
        this.textArea.append(SimulatorLibrary.getDenominator(count, total));
        this.textArea.append("\n");
    }

    protected abstract void initializeGui(JPanel var1);

    protected abstract String getFrameTitle();

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected abstract MainBoardInterface getSimulator();

    protected abstract void processEvent(int var1);

    protected abstract void processActionEvent(ActionEvent var1);

    protected abstract void eventBonusStart();

    protected abstract void eventBonusEnd();

    protected abstract void eventStart();

    protected abstract void eventSimulateStart();

    protected abstract void eventSimulateEnd();

    public final void run() {
        this.isThreadRunning = true;
        this.initialize();
        this.show();
    }
}

