/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.SuperHanaHana;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class SuperHanaHanaMainBoard
extends AbstractMainBoard4Stock {
    public static final int MODE_1 = 0;
    public static final int MODE_2 = 1;
    public static final int MODE_3 = 2;
    public static final int MODE_4 = 3;
    public static final int MODE_5 = 4;
    public static final int BREAK_NORMAL = 10;
    private int[][] breakRatioTable = new int[][]{{1092, 268, 3277, 3277, 3277}, {1092, 287, 3277, 3277, 3277}, {1092, 308, 3277, 3277, 3277}, {1092, 333, 3277, 3277, 3277}, {1092, 360, 3277, 3277, 3277}, {1092, 436, 3277, 3277, 3277}};
    private int[][] modeMoveTable = new int[][]{{28, 968, 24, 3, 1}, {28, 968, 24, 3, 1}, {508, 8, 504, 3, 1}, {1, 256, 0, 766, 1}, {128, 0, 0, 0, 896}};
    private int[][] bonusDistributionTable = new int[][]{{696, 328}, {700, 324}, {708, 316}, {712, 312}, {716, 308}, {640, 384}};
    private int[][] flagTable = new int[][]{{4, 8978, 272, 160, 256, 7306, 1024, 47536}, {4, 8978, 272, 164, 256, 7306, 1024, 47532}, {4, 8978, 272, 168, 256, 7306, 1024, 47528}, {4, 8978, 272, 172, 256, 7306, 1024, 47524}, {4, 8978, 272, 176, 256, 7306, 1024, 47520}, {4, 8978, 272, 180, 256, 7306, 1024, 47516}};
    private int[] payTable = new int[]{0, 0, 15, 15, 12, 8, 3, 0};
    public static final int FLAG_SUIKA = 4;
    public static final int FLAG_BELL = 5;
    public static final int FLAG_CHERRY = 6;
    public static final int FLAG_REPLAY_NOREPLAY = 7;
    private int[][] flagBigTable = new int[][]{{8671, 18004, 23240, 11620, 4001}, {8591, 18004, 23240, 11620, 4081}, {8511, 18004, 23240, 11620, 4161}, {8430, 18004, 23240, 11620, 4242}, {8352, 18004, 23240, 11620, 4320}, {8271, 18004, 23240, 11620, 4401}};
    private int[] payBigTable = new int[]{0, 3, 8, 12, 4};
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    private int[][] flagJacTable = new int[][]{{6553, 58983}, {6553, 58983}, {6553, 58983}, {6553, 58983}, {6553, 58983}, {6553, 58983}};

    protected void gameRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (!this.isBreak) {
            ++this.rtCounter;
            if (this.rtCounter >= this.rtFloor) {
                this.isBreak = true;
                this.breakFactor = -10;
            }
        }
        if (!this.isBreak && SimulatorLibrary.random((int)65536) < this.breakRatioTable[((AbstractMainBoard)this).settei - 1][this.currentMode]) {
            this.isBreak = true;
            this.breakFactor = 10;
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                this.isBreak = true;
                this.breakFactor = -11;
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.fireCoinPlus(this.payTable[flag]);
                break;
            }
            case 7: {
                if (!this.isBreak) break;
                this.fireCoinPlus(15);
                this.bonusGet();
            }
        }
    }

    protected void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                this.isBreak = true;
                this.breakFactor = -11;
                break;
            }
            case 2: {
                this.stock.add((Object)new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add((Object)new Integer(4));
                this.reset();
                break;
            }
            case 1: {
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.fireCoinPlus(this.payTable[flag]);
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 1: {
                if (this.isHazusi()) {
                    if (jacInCount >= 2 && game <= 23) break;
                    this.fireCoinPlus(this.payBigTable[flag]);
                    this.setJacIn();
                    break;
                }
                this.fireCoinPlus(this.payBigTable[flag]);
                this.setJacIn();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.fireCoinPlus(this.payBigTable[flag]);
            }
        }
    }

    public void setup() {
        System.out.println("setup");
        this.currentMode = -1;
    }

    public void reset() {
        super.reset();
        this.isBreak = false;
        this.currentMode = this.currentMode == -1 ? (SimulatorLibrary.random((int)1024) < 256 ? 0 : 1) : this._getNextMode();
        if (this.stock.size() > 0) {
            this.noStock = false;
            this.nextBonus = this._getNextBonus();
        } else {
            this.noStock = true;
            this.nextBonus = -1;
        }
        this.rtCounter = 0;
        this.rtFloor = this._getRtFloor();
    }

    private int _getNextBonus() {
        int next = -1;
        next = SimulatorLibrary.random((int)1024) < this.bonusDistributionTable[((AbstractMainBoard)this).settei - 1][0] ? 3 : 4;
        int index = 0;
        boolean exists = false;
        index = 0;
        while (index < this.stock.size()) {
            if ((Integer)this.stock.get(index) == next) {
                exists = true;
                break;
            }
            ++index;
        }
        if (exists) {
            this.stock.remove(index);
        } else {
            next = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
        }
        return next;
    }

    private int _getNextMode() {
        return SimulatorLibrary.getTableIndex((int[])this.modeMoveTable[this.currentMode], (int)1024);
    }

    private int _getRtFloor() {
        return SimulatorLibrary.getRandomPerRange((int)1024, (int)1150);
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagBigTable;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagJacTable;
    }
}

