/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Shake;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class ShakeMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_SHORT_RT_START = 20;
    public static final int BREAK_SHORT_RT_TABLE = 10;
    public static final int BREAK_1G = 11;
    private boolean isShortRt = false;
    private int currentShortRtFloor = -1;
    private int shiftCount = 0;
    private int jacInCount = 0;
    private boolean is1g = false;
    private static final int[][] rtTableAfterBig = new int[][]{{20, 22, 6, 24, 3, 3, 8, 2, 2, 3, 2, 2, 4, 31, 2, 122}, {34, 30, 8, 36, 2, 6, 12, 1, 1, 3, 1, 1, 4, 4, 2, 111}, {28, 28, 6, 28, 6, 7, 16, 3, 3, 3, 3, 3, 4, 23, 19, 76}, {45, 40, 8, 36, 2, 6, 20, 1, 1, 3, 1, 1, 4, 4, 17, 67}, {30, 30, 6, 28, 6, 8, 22, 3, 3, 3, 3, 3, 4, 20, 16, 71}, {66, 56, 12, 40, 2, 6, 24, 1, 1, 1, 1, 1, 4, 4, 6, 31}};
    private static final int[][] rtGameTableAfterBig = new int[][]{{0, 16, 32, 64, 96, 128, 192, 320, 448, 576, 704, 832, 960, 1437, 1937, 2437}, {15, 31, 63, 95, 127, 191, 255, 351, 479, 607, 735, 863, 1023, 1500, 2000, 2500}};
    private static final int[][] rtTableAfterReg = new int[][]{{50, 50, 8, 48, 6, 1, 1, 1, 1, 3, 1, 1, 27, 58}, {54, 64, 8, 53, 6, 6, 1, 1, 1, 3, 1, 1, 5, 52}, {50, 50, 8, 48, 6, 6, 1, 1, 1, 3, 1, 1, 27, 53}, {54, 64, 8, 53, 6, 6, 1, 1, 1, 3, 1, 1, 5, 52}, {50, 50, 8, 48, 6, 6, 1, 1, 1, 3, 1, 1, 27, 53}, {64, 64, 22, 53, 6, 6, 1, 1, 1, 3, 1, 1, 5, 28}};
    private static final int[][] rtGameTableAfterReg = new int[][]{{0, 16, 32, 64, 96, 128, 192, 320, 448, 576, 704, 832, 960, 1437}, {15, 31, 63, 95, 127, 191, 255, 351, 479, 607, 735, 863, 1023, 1500}};
    private static final int[][] shortRtTable = new int[][]{{13257, 919, 1380, 828}, {13946, 460, 1288, 690}, {13165, 460, 1840, 919}, {13992, 460, 1288, 644}, {13164, 460, 1380, 1380}, {13992, 460, 644, 1288}};
    private static final int[][] shortRtGameTable = new int[][]{{0, 1, 32, 64}, {0, 31, 63, 95}};
    public static final int FLAG_BELL = 4;
    public static final int FLAG_SUIKA = 5;
    public static final int FLAG_CHERRY = 6;
    private static final int[][] flagTable = new int[][]{{1, 57332, 275, 188, 5760, 900, 1080}, {1, 57324, 275, 196, 5760, 900, 1080}, {1, 57316, 275, 204, 5760, 900, 1080}, {1, 57308, 275, 212, 5760, 900, 1080}, {1, 57300, 275, 220, 5760, 900, 1080}, {1, 57292, 275, 228, 5760, 900, 1080}};
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_SUIKA = 3;
    public static final int FLAG_BIG_CHERRY = 4;
    private static final int[][] flagBigTable = new int[][]{{1, 14565, 50531, 427, 12}, {1, 14565, 50531, 427, 12}, {1, 14565, 50531, 427, 12}, {1, 14565, 50531, 427, 12}, {1, 14565, 50531, 427, 12}, {1, 14565, 50531, 427, 12}};
    private static final int[][] flagJacTable = new int[][]{{83, 65453}, {83, 65453}, {83, 65453}, {83, 65453}, {83, 65453}, {83, 65453}};

    protected void gameRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        ((AbstractMainBoard)this).isReplay = false;
        ++this.rtCounter;
        if (!this.isBreak && this.rtCounter >= this.rtFloor) {
            this.isBreak = true;
            this.breakFactor = this.isShortRt ? 10 : (this.is1g ? 11 : -10);
        }
        switch (flag) {
            case 0: {
                if (!this.isBreak) {
                    this.isBreak = true;
                    this.breakFactor = -11;
                    break;
                }
                this.bonusGet();
                break;
            }
            case 1: {
                if (SimulatorLibrary.random((int)4096) < 642) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isBreak) break;
                this.bonusGet();
                break;
            }
            case 2: {
                this.stock.add(3);
                this.processBonusFlag();
                break;
            }
            case 3: {
                this.stock.add(4);
                this.processBonusFlag();
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 5: {
                this.fireCoinPlus(5);
                break;
            }
            case 6: {
                this.fireCoinPlus(4);
            }
        }
    }

    protected void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            ((AbstractMainBoard)this).isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (SimulatorLibrary.random((int)4096) >= 642) break;
                ((AbstractMainBoard)this).isReplay = true;
                break;
            }
            case 2: {
                this.stock.add(3);
                this.reset();
                break;
            }
            case 3: {
                this.stock.add(4);
                this.reset();
                break;
            }
            case 4: {
                this.fireCoinPlus(10);
                break;
            }
            case 5: {
                this.fireCoinPlus(5);
                break;
            }
            case 6: {
                this.fireCoinPlus(4);
            }
        }
    }

    private void processBonusFlag() {
        if (this.isShortRt) {
            return;
        }
        int index = SimulatorLibrary.getTableIndex((int[])shortRtTable[((AbstractMainBoard)this).settei - 1], (int)16384);
        if (index > 0) {
            this.isShortRt = true;
            this.currentShortRtFloor = SimulatorLibrary.getRandomPerRange((int)shortRtGameTable[0][index], (int)shortRtGameTable[1][index]);
            this.rtFloor = this.rtCounter + this.currentShortRtFloor;
            this.fireEvent(20);
        }
    }

    public void bonusGet() {
        this.fireCoinPlus(15);
        this.shiftCount = 0;
        this.jacInCount = 0;
        this.is1g = false;
        super.bonusGet();
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 1: {
                if (game > 27) {
                    this.setJacIn();
                    ++jacInCount;
                    this.fireCoinPlus(15);
                    break;
                }
                ++this.shiftCount;
                this.fireCoinPlus(15);
                break;
            }
            case 2: {
                if (game > 27 && this.shiftCount > 0) {
                    this.setJacIn();
                    ++jacInCount;
                    --this.shiftCount;
                    this.fireCoinPlus(15);
                    break;
                }
                this.fireCoinPlus(15);
                break;
            }
            case 3: {
                this.is1g = true;
                if (game > 27 && this.shiftCount > 0) {
                    this.setJacIn();
                    ++jacInCount;
                    --this.shiftCount;
                    this.fireCoinPlus(15);
                    break;
                }
                this.fireCoinPlus(15);
                break;
            }
            case 4: {
                if (game > 27 && this.shiftCount > 0) {
                    this.setJacIn();
                    ++jacInCount;
                    --this.shiftCount;
                    this.fireCoinPlus(15);
                    break;
                }
                this.fireCoinPlus(4);
            }
        }
        if (game == 30 && jacInCount < 3) {
            this.is1g = true;
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
                break;
            }
            case 0: {
                this.is1g = true;
            }
        }
    }

    public void reset() {
        super.reset();
        this.rtCounter = 0;
        this.rtFloor = 0;
        this.isShortRt = false;
        this.breakFactor = -12;
        if (this.stock.size() > 0) {
            this.noStock = false;
            if (this.is1g) {
                this.rtFloor = 0;
                if (this.stock.getBigCount() > 0) {
                    this.nextBonus = 3;
                    this.stock.removeBig();
                } else {
                    this.nextBonus = 4;
                    this.stock.removeReg();
                }
                this.breakFactor = 11;
            } else {
                int previousBonus = this.nextBonus;
                this.rtFloor = this._getRtFloor(previousBonus);
                this.nextBonus = this._getNextBonus();
            }
        } else {
            this.is1g = false;
            this.noStock = true;
        }
        ((AbstractMainBoard)this).isBonus = false;
        this.isBreak = false;
        this.fireEvent(23);
    }

    private int _getRtFloor(int previousBonus) {
        int floor = 65536;
        if (previousBonus == 4) {
            int index = SimulatorLibrary.getTableIndex((int[])rtTableAfterReg[((AbstractMainBoard)this).settei - 1], (int)256);
            floor = SimulatorLibrary.getRandomPerRange((int)rtGameTableAfterReg[0][index], (int)rtGameTableAfterReg[1][index]);
        } else {
            int index = SimulatorLibrary.getTableIndex((int[])rtTableAfterBig[((AbstractMainBoard)this).settei - 1], (int)256);
            floor = SimulatorLibrary.getRandomPerRange((int)rtGameTableAfterBig[0][index], (int)rtGameTableAfterBig[1][index]);
        }
        return floor;
    }

    private int _getNextBonus() {
        int next = -1;
        if (this.stock.size() == 1) {
            next = (Integer)this.stock.get(0);
            this.stock.remove(0);
            return next;
        }
        int random128 = SimulatorLibrary.random((int)128);
        next = ((AbstractMainBoard)this).settei < 5 && random128 < 65 ? 3 : (((AbstractMainBoard)this).settei > 4 && random128 < 80 ? 3 : 4);
        if (next == 3 && this.stock.getBigCount() < 1) {
            next = 4;
            this.stock.removeReg();
        } else if (next == 4 && this.stock.getRegCount() < 1) {
            next = 3;
            this.stock.removeBig();
        }
        return next;
    }

    public int[][] getFlagTableHigh() {
        return flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return flagBigTable;
    }

    public int[][] getFlagTableBonusGame() {
        return flagJacTable;
    }

    public boolean isIs1g() {
        return this.is1g;
    }

    public boolean isShortRt() {
        return this.isShortRt;
    }

    public int getCurrentShortRtFloor() {
        return this.currentShortRtFloor;
    }
}

