/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Shake;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.Shake.ShakeMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class ShakeDataCounter
extends AbstractDataCounter4Stock {
    private JCheckBoxMenuItem menuItemShortRt = null;

    public ShakeDataCounter() {
        this.initialize();
    }

    protected String getFrameTitle() {
        return "\u30b7\u30a7\u30a4\u30af\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new ShakeMainBoard();
    }

    protected void processEvent(int event) {
        switch (event) {
            case 20: {
                this.eventShortRt(event);
            }
        }
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusStart() {
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + ((AbstractDataCounter)this).currentBonusCoin + "]");
        } else {
            this.appendLog("REG[" + ((AbstractDataCounter)this).currentBonusCoin + "]");
        }
        int breakFactor = this.getBreakFactor();
        this.appendLog("\t");
        switch (breakFactor) {
            case 11: {
                this.appendLog("1G\u9023");
                break;
            }
            case -11: {
                this.appendLog("\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            case -10: {
                this.appendLog("RT\u30c6\u30fc\u30d6\u30eb");
                break;
            }
            case 10: {
                this.appendLog("\u77edRT\u30c6\u30fc\u30d6\u30eb");
            }
        }
        this.appendLog("\t");
        this.appendLog(this.getCoin());
        this.appendLog("\t");
        this.appendLog(this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
    }

    protected void eventShortRt(int event) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.menuItemShortRt.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(this.getCurrentGameCount());
        this.appendLog("]\t\u77edRT\u79fb\u884c(");
        this.appendLog(((ShakeMainBoard)((AbstractDataCounter)this).simulator).getCurrentShortRtFloor());
        this.appendLog("G)\t");
        this.appendLog(this.getCoin());
        this.appendLog("\t");
        this.appendLog(this.getStockBRCount());
        this.appendLog("\n");
    }

    public void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.menuItemShortRt = new JCheckBoxMenuItem("\u77edRT\u60c5\u5831", false);
        this.addOptionMenu(this.menuItemShortRt);
    }

    public static void main(String[] args) {
        ShakeDataCounter main = null;
        try {
            main = new ShakeDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }
}

