/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.SBJ;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.SBJ.SBJMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class SBJDataCounter
extends AbstractDataCounter4Stock {
    private int stCount = 0;
    private int rcCount = 0;
    private int sbCount = 0;
    private int nbCount = 0;
    private int sbBonusCoin = 0;
    private int nbBonusCoin = 0;
    private JCheckBoxMenuItem menuItemDebug = null;

    public SBJDataCounter() {
        this.initialize();
    }

    protected String getFrameTitle() {
        return "\u30b9\u30fc\u30d1\u30fc\u30d6\u30e9\u30c3\u30af\u30b8\u30e3\u30c3\u30af\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new SBJMainBoard();
    }

    public void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.menuItemDebug = new JCheckBoxMenuItem("\u30c7\u30d0\u30c3\u30b0", false);
        this.addOptionMenu(this.menuItemDebug);
    }

    protected void processEvent(int event) {
        switch (event) {
            case 20: {
                ++this.stCount;
            }
            case 21: 
            case 22: {
                this.eventSt(event);
                break;
            }
            case 23: {
                ++this.rcCount;
            }
            case 24: 
            case 25: {
                this.eventRc(event);
                break;
            }
            case 0: {
                this.eventDebug(event);
            }
        }
    }

    protected void eventDebug(int event) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.menuItemDebug.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(this.getCurrentGameCount());
        this.appendLog("(");
        this.appendLog(this.getTotalGameCount());
        this.appendLog(")");
        this.appendLog("]");
        this.appendLog("\t");
        int flag = ((SBJMainBoard)((AbstractDataCounter)this).simulator).getCurrentFlag2();
        switch (flag) {
            case 7: {
                this.appendLog("\u62bc\u3057\u9806\u30d9\u30eb");
                break;
            }
            case 8: {
                this.appendLog("\u62bc\u3057\u9806\u4e0d\u554f\u30d9\u30eb");
                break;
            }
            case 2: {
                this.appendLog("\u5185\u90e8BIG");
                break;
            }
            case 3: {
                this.appendLog("\u5185\u90e8REG");
                break;
            }
            case 0: {
                this.appendLog("\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            case 9: {
                this.appendLog("X\u5c0f\u5f79");
                break;
            }
            case 1: {
                this.appendLog("\u30ea\u30d7\u30ec\u30a4");
                break;
            }
            case 10: {
                this.appendLog("X\u30ea\u30d7\u30ec\u30a4");
                break;
            }
            case 5: {
                this.appendLog("\u30b9\u30a4\u30ab(");
                this.appendLog(((SBJMainBoard)((AbstractDataCounter)this).simulator).getSuikaCount());
                this.appendLog(")");
                break;
            }
            case 6: {
                this.appendLog("\u30c1\u30a7\u30ea\u30fc");
                break;
            }
            default: {
                this.appendLog("!" + flag);
            }
        }
        if (((SBJMainBoard)((AbstractDataCounter)this).simulator).isSt()) {
            this.appendLog("(ST)");
        }
        if (((SBJMainBoard)((AbstractDataCounter)this).simulator).isRc()) {
            this.appendLog("(RC)");
        }
        this.appendLog("\t");
        this.appendLog(this.getCoin());
        this.appendLog("\t");
        this.appendLog(this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventSt(int event) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(this.getCurrentGameCount());
        this.appendLog("]");
        this.appendLog("\t");
        switch (event) {
            case 21: {
                this.appendLog("ST");
                this.appendLog(((SBJMainBoard)((AbstractDataCounter)this).simulator).getStGameFloor());
                this.appendLog("\u958b\u59cb");
                break;
            }
            case 22: {
                this.appendLog("ST\u7d42\u4e86");
                break;
            }
            case 20: {
                this.appendLog("[ST");
                this.appendLog(((SBJMainBoard)((AbstractDataCounter)this).simulator).getStCurrentHitFloor());
                this.appendLog("\u5f53\u9078]");
            }
        }
        this.appendLog("\t");
        this.appendLog(this.getCoin());
        this.appendLog("\n");
    }

    protected void eventRc(int event) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(this.getCurrentGameCount());
        this.appendLog("]");
        this.appendLog("\t");
        switch (event) {
            case 24: {
                this.appendLog("RC\u958b\u59cb");
                break;
            }
            case 25: {
                this.appendLog("RC\u7d42\u4e86");
                break;
            }
            case 23: {
                this.appendLog("[RC");
                this.appendLog(((SBJMainBoard)((AbstractDataCounter)this).simulator).getRcCurrentHitCount());
                this.appendLog("\u9023\u5f53\u9078]");
            }
        }
        this.appendLog("\t");
        this.appendLog(this.getCoin());
        this.appendLog("\n");
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            boolean isSb = ((SBJMainBoard)((AbstractDataCounter)this).simulator).isSb();
            if (isSb) {
                ++this.sbCount;
                this.sbBonusCoin = (int)((long)this.sbBonusCoin + ((AbstractDataCounter)this).currentBonusCoin);
            } else {
                ++this.nbCount;
                this.nbBonusCoin = (int)((long)this.nbBonusCoin + ((AbstractDataCounter)this).currentBonusCoin);
            }
        }
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(this.getCurrentGameCount());
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            if (((SBJMainBoard)((AbstractDataCounter)this).simulator).isSb()) {
                this.appendLog("S-BIG(");
            } else {
                this.appendLog("N-BIG(");
            }
            this.appendLog(((AbstractDataCounter)this).currentBonusCoin);
            this.appendLog(")");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t");
        if (this.getBreakFactor() == -11) {
            this.appendLog("\u7d14\u30cf\u30ba\u30ec");
        } else if (this.getBreakFactor() == 20) {
            this.appendLog("\u5929\u4e95");
        } else if (this.getBreakFactor() == 21) {
            this.appendLog("\u5c0f\u5f796\u9023");
        } else if (this.getBreakFactor() == 22) {
            this.appendLog("RC");
        } else if (this.getBreakFactor() == 23) {
            this.appendLog("\u901a\u5e38\u89e3\u9664");
        }
        this.appendLog("\t");
        this.appendLog(this.getCoin());
        this.appendLog("\t");
        this.appendLog(this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        this.stCount = 0;
        this.rcCount = 0;
        this.sbCount = 0;
        this.nbCount = 0;
        this.sbBonusCoin = 0;
        this.nbBonusCoin = 0;
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        this.appendLog("\n");
        this.appendLogDenominator("ST", this.stCount, this.getTotalGameCount());
        this.appendLogDenominator("RC", this.rcCount, this.getTotalGameCount());
        this.appendLogDenominator("S-BIG", this.sbCount, this.getTotalGameCount());
        this.appendLogDenominator("N-BIG", this.nbCount, this.getTotalGameCount());
        this.appendLog("\n");
        this.appendLog("S-BIG\u7372\u5f97\u5e73\u5747:");
        this.appendLog("\t");
        this.appendLog((double)this.sbBonusCoin / (double)this.sbCount);
        this.appendLog("\u679a\n");
        this.appendLog("N-BIG\u7372\u5f97\u5e73\u5747:");
        this.appendLog("\t");
        this.appendLog((double)this.nbBonusCoin / (double)this.nbCount);
        this.appendLog("\u679a\n");
        this.appendLogPayout();
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusStart() {
    }

    public static void main(String[] args) {
        SBJDataCounter main = null;
        try {
            main = new SBJDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }
}

