/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Nights;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;

public class NightsMainBoard
extends AbstractMainBoard {
    public static final int EVENT_HZ_START = 21;
    public static final int EVENT_HZ_END = 22;
    private boolean isHz = false;
    private int hzState = -1;
    public static final int HZ_NO_HZ = -1;
    public static final int HZ_BIG_PERFECT = 1;
    public static final int HZ_BIG_SAFETY = 2;
    public static final int HZ_BIG_DANGERAS = 3;
    public static final int HZ_SUIKA_SAFETY = 4;
    public static final int HZ_SUIKA_DANGERAS = 5;
    private boolean isHyper = false;
    private int currentGameCount = 0;
    private boolean isJacInShift = false;
    public static final int FLAG_BIG_15 = 2;
    private static final int[][] flagBigTable = new int[][]{{2, 2450, 13932}, {2, 2450, 13932}, {2, 2450, 13932}, {2, 2450, 13932}, {2, 2450, 13932}, {2, 2450, 13932}};
    private static final int[][] flagJacTable = new int[][]{{1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}, {1, 16383}};
    public static final int FLAG_LUMP = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_SUIKA = 6;
    private static final int[][] flagTable = new int[][]{{10927, 2245, 82, 0, 1850, 1200, 80}, {10922, 2245, 87, 0, 1850, 1200, 80}, {10917, 2245, 92, 0, 1850, 1200, 80}, {10910, 2245, 99, 0, 1850, 1200, 80}, {10900, 2245, 109, 0, 1850, 1200, 80}, {10872, 2245, 137, 0, 1850, 1200, 80}};
    private static final int[] dummy = new int[]{0, 0, 0, 0, 0, 0};

    public void bigGame(int flag, int game, int jacInCount) {
        if (game == 1) {
            this.isJacInShift = false;
        }
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                if (game < 30 || !this.isJacInShift) break;
                this.fireCoinPlus(3);
                this.setJacIn();
                break;
            }
            case 1: {
                if (game >= 29) {
                    this.fireCoinPlus(3);
                    this.setJacIn();
                    break;
                }
                this.isJacInShift = true;
                break;
            }
            case 2: {
                if (game == 30 && this.isJacInShift) {
                    this.fireCoinPlus(3);
                    this.setJacIn();
                    break;
                }
                if (this.isHyper) {
                    this.fireCoinPlus(15);
                    break;
                }
                if (SimulatorLibrary.random((int)3) == 0) {
                    this.fireCoinPlus(15);
                    break;
                }
                this.fireCoinPlus(1);
                break;
            }
            default: {
                throw new RuntimeException("Unknown flag(big)! " + flag);
            }
        }
    }

    public void game(int flag) {
        boolean random3 = false;
        int random4 = 0;
        ++this.currentGameCount;
        if (!this.isReplay) {
            this.fireCoinMinus(3);
        }
        if (flag != 1) {
            this.isReplay = false;
        }
        switch (flag) {
            case 4: {
                this.fireCoinPlus(6);
                if (!this.isHz) break;
                switch (this.hzState) {
                    case 1: {
                        if (this.currentGameCount <= 50 || SimulatorLibrary.random((int)3) != 0) break;
                        this.hzState = 2;
                        break;
                    }
                    case 2: {
                        if (SimulatorLibrary.random((int)4) >= 3) break;
                        this.hzState = 3;
                        break;
                    }
                    case 3: {
                        random4 = SimulatorLibrary.random((int)4);
                        if (random4 < 1) {
                            this.hzState = -1;
                            this.isHz = false;
                            this.fireEvent(22);
                            break;
                        }
                        if (random4 >= 2) break;
                        this.hzState = 2;
                        break;
                    }
                    case 4: {
                        this.hzState = 3;
                        break;
                    }
                    case 5: {
                        random4 = SimulatorLibrary.random((int)4);
                        if (random4 < 3) {
                            this.hzState = -1;
                            this.isHz = false;
                            this.fireEvent(22);
                            break;
                        }
                        this.hzState = 4;
                    }
                }
                break;
            }
            case 5: {
                if (SimulatorLibrary.random((int)2) == 0) {
                    this.fireCoinPlus(2);
                    break;
                }
                this.fireCoinPlus(4);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
                if (this.isHz) break;
                this.isHz = true;
                this.hzState = 4;
                this.fireEvent(21);
                break;
            }
            case 2: {
                this.isBonus = true;
                if (this.isHz) {
                    this.isHyper = true;
                    break;
                }
                if (SimulatorLibrary.random((int)3) >= 1) break;
                this.isHyper = true;
                break;
            }
            case 0: {
                if (!this.isBonus) break;
                this.fireCoinPlus(15);
                this.bonusGet();
                break;
            }
            case 1: {
                this.isReplay = true;
                break;
            }
            default: {
                throw new RuntimeException("Unknown flag! " + flag);
            }
        }
    }

    public void reset() {
        if (this.isHyper) {
            this.isHz = true;
            this.hzState = 1;
            this.fireEvent(21);
        }
        this.isBonus = false;
        this.isHyper = false;
        this.currentGameCount = 0;
    }

    public int getCurrentBonus() {
        return 3;
    }

    public int getRandomMax() {
        return 16384;
    }

    public int getMaxJacInCount() {
        return 1;
    }

    public int[][] getFlagTableBigGame() {
        return flagBigTable;
    }

    public int[][] getFlagTableBonusGame() {
        return flagJacTable;
    }

    public int[][] getFlagTableHigh() {
        return flagTable;
    }

    public int[][] getFlagTableLow() {
        return this.getFlagTableHigh();
    }

    public int[] genzanchi() {
        return dummy;
    }

    public int[] kasanchi() {
        return dummy;
    }

    public boolean isHyper() {
        return this.isHyper;
    }
}

