/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.MillionGod;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;

public class MillionGodMainBoard
extends AbstractMainBoard {
    public static final int EVENT_PGG_HIT = 20;
    public static final int EVENT_SGG_HIT = 21;
    public static final int EVENT_GG_HIT = 22;
    public static final int EVENT_GG_START = 23;
    public static final int EVENT_GG_GAMEPLUS = 24;
    public static final int EVENT_GG_STOCK_BREAK = 25;
    public static final int EVENT_MODE_MOVE = 26;
    public static final int EVENT_GZ_START = 27;
    public static final int EVENT_GZ_END = 27;
    public static final int EVENT_CZ_START = 28;
    public static final int EVENT_CZ_END = 29;
    public static final int EVENT_GG_END = 30;
    public static final int EVENT_PGG_START = 31;
    public static final int EVENT_SGG_START = 32;
    public static final int GG_HIT_FACTOR_PGG = 0;
    public static final int GG_HIT_FACTOR_SGG = 1;
    public static final int GG_HIT_FACTOR_GYAKU15 = 2;
    public static final int GG_HIT_FACTOR_JUN15 = 3;
    public static final int GG_HIT_FACTOR_REPLAY4 = 4;
    public static final int GG_HIT_FACTOR_REPLAY = 5;
    public static final int GG_HIT_FACTOR_NORMAL = 6;
    public static final int MODE_A = 0;
    public static final int MODE_B = 1;
    public static final int MODE_C = 2;
    public static final int MODE_D = 3;
    private int mode = -1;
    private int stockCount = 0;
    private boolean isGgSenpuku = false;
    private int ggSenpukuFloor = 0;
    private int ggSenpukuCounter = 0;
    private boolean isHatuhatari = false;
    private boolean isGg = false;
    private int ggGameFloor = 0;
    private int ggGameCount = 0;
    private int ggCount = 0;
    private int ggCurrentHitCount = 0;
    private int ggCurrentHitFactor = 0;
    private int ggCurrentFactor = 0;
    private int ggCurrentFloorPlus = 0;
    private int replayContinueCount = 0;
    private boolean isGz = false;
    private final int gzFloor = 5;
    private int gzGameCount = 0;
    private boolean isCz = false;
    private final int czFloor = 45;
    private int czGameCount = 0;
    private int ggFloorCounter = 0;
    private boolean isStockUntilGgFloor = false;
    private int[][] ggGyaku7HitRatioTable = new int[][]{{0, 128, 128, 1280}, {0, 143, 143, 1430}, {0, 165, 165, 1650}, {0, 190, 190, 1900}, {0, 234, 234, 2340}, {0, 444, 444, 4440}};
    private int[][] ggGyaku7HitCountTable = new int[][]{{25598, 8192, 14850, 2562, 3585, 2045, 3585, 1534, 3585}, {24746, 8251, 13749, 3211, 4122, 2294, 3663, 1835, 3663}, {24235, 8343, 12707, 3971, 4764, 2386, 3572, 1986, 3572}, {23455, 8277, 11724, 4483, 5518, 2759, 3795, 2071, 3454}, {24084, 7845, 10079, 4476, 5603, 3080, 3644, 3080, 3644}, {25389, 9450, 5905, 3539, 4725, 3539, 4725, 3539, 4725}};
    private int[][] ggJun7HitRatioTable = new int[][]{{64907, 557, 13, 59}, {64814, 636, 20, 66}, {64737, 701, 26, 72}, {64612, 806, 33, 85}, {64468, 918, 52, 98}, {64002, 1022, 256, 256}};
    private int[] modeMoveHitTable = new int[]{72, 108, 162, 648};
    private int[][] modeMoveTable = new int[][]{{46080, 5120, 1536, 12800}, {5120, 46080, 12800, 1536}, {1536, 12800, 46080, 5120}, {12800, 1536, 5120, 46080}};
    private int[] sggGgHitCountTable = new int[]{60976, 512, 2048, 256, 1024, 208, 512};
    private int[] replay4GgHitCountTable = new int[]{56320, 1024, 8192};
    private int[] ggSenpukuGameTable = new int[]{384, 96, 80, 64, 256, 144};
    int[][] flagTable = new int[][]{{3452, 8980, 8, 16, 53080}, {3444, 8980, 8, 16, 53088}, {3436, 8980, 8, 16, 53096}, {3428, 8980, 8, 16, 53104}, {3420, 8980, 8, 16, 53112}, {3412, 8980, 8, 16, 53120}};
    public static final int FLAG_PGG = 2;
    public static final int FLAG_SGG = 3;
    public static final int FLAG_15 = 4;
    int[] dummy = new int[]{0, 0, 0, 0, 0, 0};

    public void game(int flag) {
        int random256 = 0;
        boolean random1024 = false;
        int random4096 = 0;
        int random65536 = 0;
        int index = -1;
        if (!this.isReplay) {
            this.fireCoinMinus(3);
        }
        if (!this.isGg) {
            random65536 = SimulatorLibrary.random((int)65536);
            if (random65536 < this.modeMoveHitTable[this.mode] && (index = SimulatorLibrary.getTableIndex((int[])this.modeMoveTable[this.mode], (int)65536)) != this.mode) {
                this.mode = index;
                this.fireEvent(26);
            }
            ++this.ggFloorCounter;
        }
        if (this.isGgSenpuku) {
            if (this.isHatuhatari) {
                random4096 = SimulatorLibrary.random((int)4096);
                if (this.ggSenpukuCounter == 0 && random4096 < 1124) {
                    this.ggCurrentFactor = 6;
                    this.ggStart(50);
                } else if (this.ggSenpukuCounter == 1 && random4096 < 744) {
                    this.ggCurrentFactor = 6;
                    this.ggStart(50);
                } else if (this.ggSenpukuCounter == 2 && random4096 < 896) {
                    this.ggCurrentFactor = 6;
                    this.ggStart(50);
                } else if (this.ggSenpukuCounter == 3 && random4096 < 1170) {
                    this.ggCurrentFactor = 6;
                    this.ggStart(50);
                } else if (this.ggSenpukuCounter == 4) {
                    this.ggCurrentFactor = 6;
                    this.ggStart(50);
                }
                ++this.ggSenpukuCounter;
            } else {
                random4096 = SimulatorLibrary.random((int)4096);
                ++this.ggSenpukuCounter;
                if (this.ggSenpukuCounter >= this.ggSenpukuFloor) {
                    this.ggCurrentFactor = 6;
                    this.ggStart(50);
                } else if (this.ggSenpukuCounter > 5 && this.ggSenpukuFloor == 50) {
                    if (random4096 < 256) {
                        this.ggCurrentFactor = 6;
                        this.ggStart(50);
                    } else if (this.ggSenpukuCounter >= 51) {
                        this.ggCurrentFactor = 6;
                        this.ggStart(50);
                    }
                }
            }
        }
        if (this.isGz) {
            ++this.gzGameCount;
            if (this.gzGameCount >= 5) {
                this.isGz = false;
                this.isCz = true;
                this.czGameCount = 0;
            }
        } else if (this.isCz) {
            ++this.czGameCount;
            if (this.czGameCount >= 45) {
                this.isCz = false;
            }
        }
        if (flag != 1) {
            this.isReplay = false;
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isGg) {
                    this.isReplay = true;
                    break;
                }
                if (this.isCz && this.czGameCount == 45) {
                    this.isReplay = false;
                    break;
                }
                this.isReplay = false;
                break;
            }
            case 2: {
                this.fireCoinPlus(15);
                if (this.isGg) {
                    this.ggCurrentFloorPlus = 500;
                    this.ggGameFloor += this.ggCurrentFloorPlus;
                    this.fireEvent(20);
                    if (this.stockCount >= 5) {
                        this.stockCount -= 5;
                        this.ggCount += 5;
                        break;
                    }
                    this.ggCount += this.stockCount;
                    this.stockCount = 0;
                    break;
                }
                if (this.isGz) {
                    this.ggCount += this.stockCount;
                    this.stockCount = 0;
                    this.ggCurrentFactor = 0;
                    ++this.ggCount;
                    this.ggStart(500);
                    break;
                }
                if (this.stockCount >= 3) {
                    this.stockCount -= 3;
                    this.ggCount += 3;
                } else {
                    this.ggCount += this.stockCount;
                    this.stockCount = 0;
                }
                this.ggCurrentFactor = 0;
                ++this.ggCount;
                this.ggStart(500);
                break;
            }
            case 3: {
                this.fireCoinPlus(1);
                random65536 = SimulatorLibrary.random((int)65536);
                index = SimulatorLibrary.getTableIndex((int[])this.sggGgHitCountTable, (int)65536);
                this.ggCurrentHitCount = index + 3;
                this.ggCurrentHitFactor = 1;
                this.fireEvent(22);
                if (this.mode < 2 && this.ggCurrentHitCount > 3) {
                    this.ggCount += 3;
                    this.stockCount += this.ggCurrentHitCount - 3;
                } else {
                    this.ggCount += this.ggCurrentHitCount;
                }
                if (this.isGg) {
                    this.ggCurrentFloorPlus = 50;
                    this.ggGameFloor += this.ggCurrentFloorPlus;
                    this.fireEvent(21);
                    if (this.stockCount >= 3) {
                        this.stockCount -= 3;
                        this.ggCount += 3;
                        break;
                    }
                    this.ggCount += this.stockCount;
                    this.stockCount = 0;
                    break;
                }
                if (this.isGz) {
                    if (this.stockCount >= 5) {
                        this.stockCount -= 5;
                        this.ggCount += 5;
                    } else {
                        this.ggCount += this.stockCount;
                        this.stockCount = 0;
                    }
                    this.ggCurrentFactor = 1;
                    this.ggStart(50);
                    break;
                }
                this.ggCurrentFactor = 1;
                this.ggStart(50);
                break;
            }
            case 4: {
                if (this.isGg) {
                    this.fireCoinPlus(15);
                    break;
                }
                random256 = SimulatorLibrary.random((int)256);
                if (random256 < 11) {
                    if (this.isGgSenpuku && this.isHatuhatari) {
                        this.ggCurrentFactor = 6;
                        this.ggStart(50);
                        break;
                    }
                    if (this.stockCount <= 0 || (index = SimulatorLibrary.getTableIndex((int[])this.ggJun7HitRatioTable[this.settei - 1], (int)65536)) <= 0) break;
                    break;
                }
                if (random256 >= 60 || this.mode <= 0 || (random65536 = SimulatorLibrary.random((int)32768)) >= this.ggGyaku7HitRatioTable[this.settei - 1][this.mode]) break;
                this.ggCurrentHitFactor = 2;
                index = SimulatorLibrary.getTableIndex((int[])this.ggGyaku7HitCountTable[this.settei - 1], (int)65536);
                this.ggCurrentHitCount = index + 1;
                if (this.mode == 1) {
                    this.stockCount += this.ggCurrentHitCount;
                    this.isStockUntilGgFloor = true;
                } else if (!this.isGgSenpuku) {
                    this.ggCount += this.ggCurrentHitCount;
                    this.isGgSenpuku = true;
                    this.isHatuhatari = true;
                    this.ggSenpukuCounter = 0;
                }
                this.fireEvent(22);
            }
        }
        if (this.isGg && this.replayContinueCount >= 3) {
            if (this.stockCount > 0) {
                --this.stockCount;
                ++this.ggCount;
            }
        } else if (this.replayContinueCount == 4 && !this.isGgSenpuku || this.replayContinueCount != 4 || this.isGgSenpuku) {
            // empty if block
        }
        if (this.isGg) {
            if (flag != 3 && flag != 2) {
                ++this.ggGameCount;
            }
            if (this.ggGameCount >= this.ggGameFloor) {
                this.fireEvent(30);
                this.isGg = false;
                this.ggGameCount = 0;
                this.ggGameFloor = 0;
                if (this.ggCount > 0) {
                    this.isGgSenpuku = true;
                    index = SimulatorLibrary.getTableIndex((int[])this.ggSenpukuGameTable, (int)1024);
                    this.ggSenpukuFloor = index < 5 ? index + 1 : 50;
                }
                this.ggFloorCounter = 0;
                this.isGz = true;
            }
        }
    }

    private void ggStart(int gameCount) {
        this.isGz = false;
        this.gzGameCount = 0;
        this.isCz = false;
        this.czGameCount = 0;
        this.isHatuhatari = false;
        this.isGgSenpuku = false;
        this.ggSenpukuCounter = 0;
        this.ggSenpukuFloor = 0;
        this.isGg = true;
        this.ggGameCount = 0;
        this.ggGameFloor = gameCount;
        --this.ggCount;
        this.isStockUntilGgFloor = false;
        if (this.ggCurrentFactor == 0) {
            this.fireEvent(31);
        } else if (this.ggCurrentFactor == 1) {
            this.fireEvent(32);
        } else {
            this.fireEvent(23);
        }
    }

    public void reset() {
        if (this.mode == -1) {
            this.mode = 3;
            this.fireEvent(26);
        }
    }

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableLow() {
        return this.getFlagTableHigh();
    }

    public int[] genzanchi() {
        return this.dummy;
    }

    public int getCurrentBonus() {
        return 0;
    }

    public int[] kasanchi() {
        return this.dummy;
    }

    public void bigGame(int flag, int game, int jacInCount) {
    }

    public int[][] getFlagTableBigGame() {
        return null;
    }

    public int[][] getFlagTableBonusGame() {
        return null;
    }

    public int getGgCurrentHitCount() {
        return this.ggCurrentHitCount;
    }

    public int getGgCurrentHitFactor() {
        return this.ggCurrentHitFactor;
    }

    public int getGgGameFloor() {
        return this.ggGameFloor;
    }

    public boolean isGg() {
        return this.isGg;
    }

    public int getMode() {
        return this.mode;
    }

    public int[] getModeMoveHitTable() {
        return this.modeMoveHitTable;
    }

    public int getStockCount() {
        return this.stockCount;
    }

    public void setModeMoveHitTable(int[] is) {
        this.modeMoveHitTable = is;
    }

    public int getGgFloorCounter() {
        return this.ggFloorCounter;
    }

    public int getGgCount() {
        return this.ggCount;
    }

    public int getGgGameCount() {
        return this.ggGameCount;
    }

    public int getGgCurrentFloorPlus() {
        return this.ggCurrentFloorPlus;
    }
}

