/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.MillionGod;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.machines.MillionGod.MillionGodMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class MillionGodDataCounter
extends AbstractDataCounter {
    private boolean isGg = false;
    private int ggCount = 0;
    private int pggCount = 0;
    private int sggCount = 0;

    protected void initializeGui(JPanel northPanel) {
    }

    protected String getFrameTitle() {
        return "\u30df\u30ea\u30aa\u30f3\u30b4\u30c3\u30c9\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new MillionGodMainBoard();
    }

    protected void processEvent(int event) {
        switch (event) {
            case 23: {
                this.isGg = true;
                ++this.ggCount;
                this.logGg(event);
                break;
            }
            case 30: {
                this.isGg = false;
                this.logGg(event);
                break;
            }
            case 20: {
                ++this.pggCount;
                this.logGg(event);
                break;
            }
            case 21: {
                ++this.sggCount;
                this.logGg(event);
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                this.logGg(event);
                break;
            }
            case 26: {
                this.logModeMove(event);
            }
        }
    }

    protected void eventSimulateStart() {
        this.ggCount = 0;
        this.pggCount = 0;
        this.sggCount = 0;
    }

    protected void eventStart() {
    }

    protected void eventSimulateEnd() {
        this.appendLog("\n");
        this.appendLog(this.getGgFloorCounter());
        this.appendLog("\t\u30e4\u30e1\ttotal");
        this.appendLog(this.getTotalGameCount());
        this.appendLog("\n");
        this.appendLog("\n");
        this.appendLogDenominator("GG", this.ggCount, this.getTotalGameCount());
        this.appendLogDenominator("PGG", this.pggCount, this.getTotalGameCount());
        this.appendLogDenominator("SGG", this.sggCount, this.getTotalGameCount());
        this.appendLogPayout();
    }

    protected void logGg(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        switch (event) {
            case 23: {
                this.appendLogGameCount();
                this.appendLog("\tGG");
                this.appendLog(((MillionGodMainBoard)this.simulator).getGgGameFloor());
                this.appendLog("\t\u958b\u59cb");
                break;
            }
            case 30: {
                this.appendLog("\t[");
                this.appendLog(this.getGgGameCount());
                this.appendLog("]GG\u7d42\u4e86\t\u6b8b=");
                this.appendLog(this.getGgCount());
                break;
            }
            case 22: {
                this.appendLog("[");
                this.appendLog(this.getGgFloorCounter());
                this.appendLog("]\tGG\u5f53\u9078\t\u9023=");
                this.appendLog(((MillionGodMainBoard)this.simulator).getGgCurrentHitCount());
                this.appendLog("]");
                break;
            }
            case 25: {
                this.appendLogGameCount();
                this.appendLog("\t[ST\u653e\u51fa\u5f53\u9078\t\u9023=");
                this.appendLog(((MillionGodMainBoard)this.simulator).getGgCurrentHitCount());
                this.appendLog("]");
                break;
            }
            case 24: {
                this.appendLogGameCount();
                this.appendLog("\t\u4e0a\u4e57\u305b=");
                this.appendLog(((MillionGodMainBoard)this.simulator).getGgCurrentFloorPlus());
                this.appendLog("]");
                break;
            }
            case 20: {
                this.appendLogGameCount();
                this.appendLog("\tPGG");
                break;
            }
            case 21: {
                this.appendLogGameCount();
                this.appendLog("\tSGG");
                break;
            }
            case 31: {
                this.appendLogGameCount();
                this.appendLog("\tPGG");
                break;
            }
            case 32: {
                this.appendLogGameCount();
                this.appendLog("\tSGG");
                break;
            }
            default: {
                this.appendLogGameCount();
                this.appendLog("\t???");
            }
        }
        this.appendLog("\t");
        this.appendLog(this.getCoin());
        this.appendLog("\tST=");
        this.appendLog(((MillionGodMainBoard)this.simulator).getStockCount());
        this.appendLog("\n");
    }

    private void appendLogGameCount() {
        if (this.isGg() && this.getGgGameCount() != 0) {
            this.appendLog("\t[GG\u4e2d");
            this.appendLog(this.getGgGameCount());
            this.appendLog("]");
        } else {
            this.appendLog(this.getGgFloorCounter());
        }
    }

    private boolean isGg() {
        return ((MillionGodMainBoard)this.simulator).isGg();
    }

    private int getGgCount() {
        return ((MillionGodMainBoard)this.simulator).getGgCount();
    }

    private int getGgGameCount() {
        return ((MillionGodMainBoard)this.simulator).getGgGameCount();
    }

    private int getGgFloorCounter() {
        return ((MillionGodMainBoard)this.simulator).getGgFloorCounter();
    }

    protected void logModeMove(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog("[");
        this.appendLog(this.getGgFloorCounter());
        this.appendLog("]");
        int mode = ((MillionGodMainBoard)this.simulator).getMode();
        switch (mode) {
            case 0: {
                this.appendLog("\t\u5730\u7344M");
                break;
            }
            case 1: {
                this.appendLog("\t\u30b9\u30c8\u30c3\u30afM");
                break;
            }
            case 2: {
                this.appendLog("\t\u901a\u5e38M");
                break;
            }
            case 3: {
                this.appendLog("\t\u5929\u56fdM");
                break;
            }
            default: {
                this.appendLog("\t???M");
            }
        }
        this.appendLog("\n");
    }

    public static void main(String[] args) {
        MillionGodDataCounter main = null;
        try {
            main = new MillionGodDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusStart() {
    }

    protected void eventBonusEnd() {
    }
}

